/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.io.async;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.io.async.AbstractAsyncChannel;
import com.ibm.io.async.AsyncChannelGroup;
import com.ibm.io.async.AsyncException;
import com.ibm.io.async.AsyncLibrary;
import com.ibm.io.async.CompletionKey;
import com.ibm.io.async.IAsyncProvider;
import com.ibm.nws.ffdc.FFDCFilter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class AsyncSocketChannel
extends AbstractAsyncChannel {
    protected static final TraceComponent tc = Tr.register(AsyncSocketChannel.class, "TCPChannel", "com.ibm.ws.tcp.channel.resources.tcpchannelmessages");
    private static final long INVALID_SOCKET = -1L;
    private static IAsyncProvider provider = AsyncLibrary.getInstance();
    protected static boolean nioUtilsClassChecked = false;
    protected static Class nioUtilsClass = null;
    protected static Method getFileDescriptorMethod = null;
    protected SocketChannel channel;
    private boolean prepared = false;
    static /* synthetic */ Class class$java$nio$channels$SocketChannel;

    public static AsyncSocketChannel open(AsyncChannelGroup asyncChannelGroup) throws AsyncException, IOException {
        return new AsyncSocketChannel(SocketChannel.open(), asyncChannelGroup);
    }

    public AsyncSocketChannel(SocketChannel socketChannel, AsyncChannelGroup asyncChannelGroup) throws IOException {
        super(asyncChannelGroup);
        this.channel = socketChannel;
        if (this.channel.isConnected()) {
            this.prepareSocket();
        }
    }

    public SocketChannel getSocketChannel() {
        return this.channel;
    }

    public synchronized void close() throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "close");
        }
        if (this.prepared) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "close - disposing of socket, channelIdentifier = " + this.channelIdentifier + ", local: " + this.channel.socket().getLocalSocketAddress() + ", remote: " + this.channel.socket().getRemoteSocketAddress());
            }
            if (this.readFuture != null && this.readFuture.getTimeoutWorkItem() != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "cancelling timeout entry. readFuture.getTimeoutWorkItem().state: " + this.readFuture.getTimeoutWorkItem().state);
                }
                this.readFuture.getTimeoutWorkItem().state = 2L;
            }
            if (this.writeFuture != null && this.writeFuture.getTimeoutWorkItem() != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "cancelling timeout entry writeFuture.getTimeoutWorkItem().state: " + this.writeFuture.getTimeoutWorkItem().state);
                }
                this.writeFuture.getTimeoutWorkItem().state = 2L;
            }
            if (this.channelVCI != null && this.channelVCI.isInputStateTrackingOperational()) {
                int n;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Input Tracking (Permission logic) is on");
                }
                if (this.channelVCI.isCloseWithReadOutstanding()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "calling cancel2 on readiocb: channelID: " + this.channelIdentifier + "  callid: " + this.readIOCB.getCallIdentifier());
                    }
                    n = provider.cancel2(this.channelIdentifier, this.readIOCB.getCallIdentifier());
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "return from cancel2 rc (0 - success): " + n);
                    }
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "read was not outstanding");
                }
                if (this.channelVCI.isCloseWithWriteOutstanding()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "calling cancel2 on writeiocb channelID: " + this.channelIdentifier + "  callid: " + this.writeIOCB.getCallIdentifier());
                    }
                    n = provider.cancel2(this.channelIdentifier, this.writeIOCB.getCallIdentifier());
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "return from cancel2 rc (0 - success): " + n);
                    }
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "write was not outstanding");
                }
            }
            provider.terminateIOCB(this.readIOCB);
            provider.terminateIOCB(this.writeIOCB);
            provider.dispose(this.channelIdentifier);
            this.prepared = false;
        }
        this.channel.close();
        super.close();
    }

    protected long getFileDescriptor() throws AsyncException {
        StartPrivilegedThread2 startPrivilegedThread2 = new StartPrivilegedThread2(this.channel);
        FieldReturn fieldReturn = (FieldReturn)AccessController.doPrivileged(startPrivilegedThread2);
        if (fieldReturn.e != null) {
            throw fieldReturn.e;
        }
        return fieldReturn.val;
    }

    public boolean isConnected() {
        return this.channel.isConnected();
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public synchronized void prepareSocket() throws IOException {
        if (!this.prepared) {
            long l = this.getFileDescriptor();
            if (l == -1L) {
                throw new AsyncException("Unable to get socket handle");
            }
            this.channelIdentifier = provider.prepare2(l, this.asyncChannelGroup.getCompletionPort());
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "prepareSocket - socket prepared, fd = " + l + " channelIdentifier = " + this.channelIdentifier + " " + ", local: " + this.channel.socket().getLocalSocketAddress() + ", remote: " + this.channel.socket().getRemoteSocketAddress());
            }
            long l2 = 0L;
            this.readIOCB = new CompletionKey(this.channelIdentifier, l2, 10);
            this.writeIOCB = new CompletionKey(this.channelIdentifier, l2, 10);
            provider.initializeIOCB(this.readIOCB);
            provider.initializeIOCB(this.writeIOCB);
            this.prepared = true;
        }
    }

    public Socket socket() {
        return this.channel.socket();
    }

    class StartPrivilegedThread2
    implements PrivilegedAction {
        SocketChannel ioSocket;

        public StartPrivilegedThread2(SocketChannel socketChannel) {
            this.ioSocket = socketChannel;
        }

        public Object run() {
            FieldReturn fieldReturn = new FieldReturn();
            if (!nioUtilsClassChecked) {
                block10: {
                    try {
                        nioUtilsClass = Class.forName("com.ibm.nio.NIOUtils");
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "NIOUtils class was found");
                        }
                        getFileDescriptorMethod = nioUtilsClass.getDeclaredMethod("getFileDescriptor", class$java$nio$channels$SocketChannel == null ? (class$java$nio$channels$SocketChannel = AsyncSocketChannel.class$("java.nio.channels.SocketChannel")) : class$java$nio$channels$SocketChannel);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "NIOUtils getFileDescriptor method was found");
                        }
                    }
                    catch (Exception exception) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block10;
                        Tr.debug(tc, "Problem loading NIOUtils class/method: " + exception.getMessage());
                    }
                }
                nioUtilsClassChecked = true;
            }
            try {
                if (getFileDescriptorMethod != null) {
                    fieldReturn.val = (Long)getFileDescriptorMethod.invoke((Object)nioUtilsClass, AsyncSocketChannel.this.channel);
                } else {
                    Field field = AsyncSocketChannel.this.channel.getClass().getDeclaredField("fdVal");
                    field.setAccessible(true);
                    fieldReturn.val = field.getInt(AsyncSocketChannel.this.channel);
                }
            }
            catch (Exception exception) {
                fieldReturn.e = new AsyncException(exception.getLocalizedMessage());
            }
            if (fieldReturn.val == -1L) {
                fieldReturn.e = new AsyncException("Invalid fd val obtained from JDK");
                FFDCFilter.processException((Throwable)fieldReturn.e, (String)"com.ibm.io.async.AsyncSocketChannel", (String)"161");
            }
            return fieldReturn;
        }
    }

    public class FieldReturn {
        public long val;
        public AsyncException e = null;
    }

    public class ConnectReturn {
        public boolean isConnected = false;
        public IOException ioe = null;
    }
}

