/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.io.async;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.io.async.AbstractAsyncFuture;
import com.ibm.io.async.AsyncProperties;
import com.ibm.io.async.AsyncSocketChannel;
import com.ibm.io.async.AsyncTimeoutException;
import com.ibm.io.async.IAbstractAsyncFuture;
import com.ibm.io.async.IAsyncFuture;
import com.ibm.io.async.Timer;
import com.ibm.io.async.TimerCallback;
import com.ibm.io.async.TimerWorkItem;
import com.ibm.nws.ffdc.FFDCFilter;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class AsyncSocketChannelHelper {
    protected final AsyncSocketChannel schannel;
    protected final boolean providerIsMultiCapable;
    protected static final TraceComponent tc = Tr.register(AsyncSocketChannelHelper.class, "TCPChannel", "com.ibm.ws.tcp.channel.resources.tcpchannelmessages");
    tCallback callback = new tCallback();
    static Timer timer = null;
    static AsyncTimeoutException timeoutException = null;

    public AsyncSocketChannelHelper(AsyncSocketChannel asyncSocketChannel) {
        if (asyncSocketChannel == null) {
            throw new IllegalArgumentException();
        }
        this.schannel = asyncSocketChannel;
        this.providerIsMultiCapable = this.schannel.isCapable(1);
    }

    public IAsyncFuture read(ByteBuffer[] byteBufferArray, boolean bl, long l, boolean bl2, VirtualConnection virtualConnection, boolean bl3) {
        return this.schannel.multiIO(byteBufferArray, 0L, true, bl, l, bl2, virtualConnection, bl3);
    }

    public IAsyncFuture read(ByteBuffer[] byteBufferArray, long l, boolean bl, long l2, boolean bl2, VirtualConnection virtualConnection, boolean bl3) {
        if (l < 0L) {
            throw new IllegalArgumentException();
        }
        IAsyncFuture iAsyncFuture = this.read(byteBufferArray, bl, l2, bl2, virtualConnection, bl3);
        if (iAsyncFuture != null && !iAsyncFuture.isCompleted() && l > 0L) {
            this.createTimeout(iAsyncFuture, l, true);
        }
        return iAsyncFuture;
    }

    public IAsyncFuture write(ByteBuffer[] byteBufferArray, long l, boolean bl, long l2, VirtualConnection virtualConnection, boolean bl2) {
        if (l < 0L) {
            throw new IllegalArgumentException();
        }
        IAsyncFuture iAsyncFuture = this.write(byteBufferArray, bl, l2, virtualConnection, bl2);
        if (iAsyncFuture != null && !iAsyncFuture.isCompleted() && l > 0L) {
            this.createTimeout(iAsyncFuture, l, false);
        }
        return iAsyncFuture;
    }

    public IAsyncFuture write(ByteBuffer[] byteBufferArray, boolean bl, long l, VirtualConnection virtualConnection, boolean bl2) {
        return this.schannel.multiIO(byteBufferArray, 0L, false, bl, l, false, virtualConnection, bl2);
    }

    public AsyncSocketChannel getChannel() {
        return this.schannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTimeout(IAbstractAsyncFuture iAbstractAsyncFuture, long l, boolean bl) {
        if (AsyncProperties.disableTimeouts) {
            return;
        }
        long l2 = System.currentTimeMillis() + l + 1024L & 0xFFFFFFFFFFFFFC00L;
        Object object = iAbstractAsyncFuture.getCompletedSemaphore();
        synchronized (object) {
            if (!iAbstractAsyncFuture.isCompleted()) {
                timer.createTimeoutRequest(l2, this.callback, iAbstractAsyncFuture);
            }
        }
    }

    static {
        StartPrivilegedThread startPrivilegedThread = new StartPrivilegedThread();
        AccessController.doPrivileged(startPrivilegedThread);
    }

    class tCallback
    implements TimerCallback {
        tCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void timerTriggered(TimerWorkItem timerWorkItem) {
            AbstractAsyncFuture abstractAsyncFuture = (AbstractAsyncFuture)timerWorkItem.attachment;
            try {
                Object object = abstractAsyncFuture.getCompletedSemaphore();
                synchronized (object) {
                    if (!abstractAsyncFuture.isCompleted()) {
                        if (abstractAsyncFuture.getReuseCount() != timerWorkItem.futureCount) {
                            return;
                        }
                        if (timeoutException == null) {
                            timeoutException = new AsyncTimeoutException();
                        }
                        abstractAsyncFuture.setCancelInProgress(1);
                        abstractAsyncFuture.cancel(timeoutException);
                    }
                }
            }
            catch (Exception exception) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Error in timerTriggered while trying to timeout an operation. exception: " + exception.getMessage());
                }
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.io.async.AsyncSocketChannelHelper", (String)"98");
            }
        }
    }

    static class StartPrivilegedThread
    implements PrivilegedAction {
        public Object run() {
            timer = new Timer();
            return null;
        }
    }
}

