/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.io.async;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.io.async.AbstractAsyncChannel;
import com.ibm.io.async.AsyncException;
import com.ibm.nws.ffdc.FFDCFilter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;

public class CompletionKey {
    private static final TraceComponent tc;
    private static final int CHANNEL_ID_INDEX = 0;
    private static final int CALL_ID_INDEX = 1;
    private static final int RETURN_CODE_INDEX = 2;
    private static final int BYTES_AFFECTED_INDEX = 3;
    private static final int NATIVE_STRUCTURE_INDEX = 4;
    private static final int JIT_BUFFER_USED = 4;
    private static final int RETURN_STATUS_INDEX = 5;
    private static final int FIRST_BUFFER_INDEX = 6;
    ByteBuffer rawData;
    LongBuffer longBuffer;
    int bufferCount = 0;
    long channelIdentifier;
    long callIdentifier;
    static final /* synthetic */ boolean $assertionsDisabled;

    CompletionKey() {
        this(0L, 0L, 1);
    }

    public CompletionKey(long l, long l2, int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Buffer count cannot be < 0 !");
        }
        int n2 = 8 * (6 + n * 2);
        this.rawData = ByteBuffer.allocateDirect(n2);
        this.rawData.order(ByteOrder.nativeOrder());
        this.longBuffer = this.rawData.asLongBuffer();
        this.longBuffer.put(0, l);
        this.longBuffer.put(1, l2);
        this.longBuffer.put(3, -1L);
        this.longBuffer.put(2, 0L);
        this.longBuffer.put(4, 0L);
        this.longBuffer.put(5, 0L);
        this.channelIdentifier = l;
        this.callIdentifier = l2;
        this.bufferCount = n;
    }

    public long getAddress() {
        return AbstractAsyncChannel.getBufAddress(this.rawData);
    }

    public void setBuffer(long l, long l2, int n) {
        if (n < 0 || n >= this.bufferCount) {
            throw new IllegalArgumentException();
        }
        this.longBuffer.put(6 + 2 * n, l);
        this.longBuffer.put(6 + 2 * n + 1, l2);
    }

    public int getBufferCount() {
        return this.bufferCount;
    }

    public int getBytesAffected() {
        long l = this.longBuffer.get(3);
        if (l > Integer.MAX_VALUE) {
            AsyncException asyncException = new AsyncException("Bytes affected value invalid: " + l);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Invalid value returned for bytes affected, exception: " + asyncException.getMessage());
            }
            FFDCFilter.processException((Throwable)asyncException, (String)"com.ibm.io.async.CompletionKey", (String)"156", (Object)this);
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }
        return (int)l;
    }

    public void setBytesAffected(int n) {
        this.longBuffer.put(3, n);
    }

    public long getCallIdentifier() {
        return this.longBuffer.get(1);
    }

    public void setCallIdentifier(long l) {
        this.callIdentifier = l;
        this.longBuffer.put(1, l);
    }

    public long getChannelIdentifier() {
        return this.longBuffer.get(0);
    }

    public long getReturnStatus() {
        return this.longBuffer.get(5);
    }

    public void setReturnStatus(int n) {
        this.longBuffer.put(5, n);
    }

    public int getReturnCode() {
        long l = this.longBuffer.get(2);
        if (l > Integer.MAX_VALUE) {
            AsyncException asyncException = new AsyncException("Return code value invalid");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Invalid value returned for return code, exception: " + asyncException.getMessage());
            }
            FFDCFilter.processException((Throwable)asyncException, (String)"com.ibm.io.async.AsyncChannelFuture", (String)"227", (Object)this);
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }
        return (int)l;
    }

    public boolean wasJITBufferUsed() {
        long l = this.longBuffer.get(4);
        return l == 1L;
    }

    public void setReturnCode(int n) {
        this.longBuffer.put(2, n);
    }

    protected void expandBuffers(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Buffer count cannot be < 0 !");
        }
        int n2 = 8 * (6 + n * 2);
        long l = this.longBuffer.get(4);
        this.rawData = ByteBuffer.allocateDirect(n2);
        this.rawData.order(ByteOrder.nativeOrder());
        this.longBuffer = this.rawData.asLongBuffer();
        this.longBuffer.put(0, this.channelIdentifier);
        this.longBuffer.put(1, this.callIdentifier);
        this.longBuffer.put(3, -1L);
        this.longBuffer.put(2, 0L);
        this.longBuffer.put(4, l);
        this.longBuffer.put(5, 0L);
        this.bufferCount = n;
    }

    protected void reset() {
        this.longBuffer.put(3, -1L);
        this.longBuffer.put(2, 0L);
        this.longBuffer.put(4, 0L);
        this.longBuffer.put(5, 0L);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append("[channel id=");
        stringBuffer.append(this.getChannelIdentifier());
        stringBuffer.append(", call id=");
        stringBuffer.append(this.getCallIdentifier());
        stringBuffer.append(", rc=");
        stringBuffer.append(this.getReturnCode());
        stringBuffer.append(", bytes=");
        stringBuffer.append(this.getBytesAffected());
        stringBuffer.append(", Native address/JIT used=");
        stringBuffer.append(this.longBuffer.get(4));
        stringBuffer.append("]\n");
        return stringBuffer.toString();
    }

    static {
        $assertionsDisabled = !CompletionKey.class.desiredAssertionStatus();
        tc = Tr.register(CompletionKey.class, "TCPChannel", "com.ibm.ws.tcp.channel.resources.tcpchannelmessages");
    }
}

