/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.io.async;

import java.util.BitSet;

public class LookupTable {
    static final int DEFAULT_INITIAL_CAPACITY = 1000;
    static final int DEFAULT_INCREMENT = 1000;
    private Object[] theElementArray;
    private int currentCapacity;
    private volatile int increment = 1000;
    private int elementCount;
    private BitSet occupiedSlots;

    public LookupTable(int n) {
        this(n, 1000);
    }

    public LookupTable(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("Capacity cannot be <0");
        }
        if (n == 0) {
            n = 1000;
        }
        this.theElementArray = new Object[n];
        this.currentCapacity = n;
        this.occupiedSlots = new BitSet(n);
        this.elementCount = 0;
        this.increment = n2;
    }

    public synchronized Object lookupElement(int n) {
        if (!this.indexInRange(n)) {
            return null;
        }
        return this.theElementArray[n];
    }

    public synchronized int addElement(Object object) {
        if (object == null) {
            return -1;
        }
        if (this.isFull()) {
            this.expandTable();
            if (this.isFull()) {
                throw new IllegalStateException("Unable to grow LookupTable.");
            }
        }
        int n = this.findFirstFreeIndex();
        this.theElementArray[n] = object;
        ++this.elementCount;
        this.occupiedSlots.set(n);
        return n;
    }

    public synchronized Object removeElement(int n) {
        if (!this.indexInRange(n)) {
            throw new IllegalArgumentException("Index is out of range.");
        }
        Object object = this.theElementArray[n];
        if (object != null) {
            this.theElementArray[n] = null;
            --this.elementCount;
            this.occupiedSlots.clear(n);
        }
        return object;
    }

    public int findElement(Object object) {
        for (int i = 0; i < this.currentCapacity; ++i) {
            if (object != this.theElementArray[i]) continue;
            return i;
        }
        return -1;
    }

    public void setIncrement(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Increment must be >0");
        }
        this.increment = n;
    }

    private void expandTable() {
        int n = this.currentCapacity + this.increment;
        if (n < this.currentCapacity) {
            throw new IllegalStateException("Attempt to expand LookupTable beyond maximum capacity");
        }
        Object[] objectArray = new Object[n];
        System.arraycopy(this.theElementArray, 0, objectArray, 0, this.currentCapacity);
        this.theElementArray = objectArray;
        this.currentCapacity = n;
    }

    private int findFirstFreeIndex() {
        int n = this.occupiedSlots.nextClearBit(0);
        if (this.indexInRange(n)) {
            return n;
        }
        throw new IllegalStateException("Suggested free index is out of range.");
    }

    private boolean isFull() {
        return this.elementCount == this.currentCapacity;
    }

    private boolean indexInRange(int n) {
        return n >= 0 && n <= this.currentCapacity - 1;
    }
}

