/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.io.async;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.io.async.AbstractAsyncChannel;
import com.ibm.io.async.AsyncException;
import com.ibm.io.async.AsyncFuture;
import com.ibm.io.async.AsyncLibrary;
import com.ibm.io.async.AsyncProperties;
import com.ibm.io.async.CompletedFutureWorkItem;
import com.ibm.io.async.CompletedFuturesLinkedList;
import com.ibm.io.async.CompletionKey;
import com.ibm.io.async.IAsyncProvider;
import com.ibm.io.async.SyncInt;
import com.ibm.nws.ffdc.FFDCFilter;
import com.ibm.ws.buffermgmt.impl.WsByteBufferPoolManagerImpl;
import com.ibm.ws.timeutils.QuickApproxTime;
import com.ibm.ws.util.objectpool.TwoTierObjectPool;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferPoolManager;
import com.ibm.wsspi.runtime.ThreadPool;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.NoSuchElementException;

final class ResultHandler {
    protected static final TraceComponent tc = Tr.register(ResultHandler.class, "TCPChannel", "com.ibm.ws.tcp.channel.resources.tcpchannelmessages");
    private static final int COMPLETION_TIMEOUT = AsyncProperties.completionTimeout;
    protected static IAsyncProvider provider = AsyncLibrary.getInstance();
    protected WsByteBufferPoolManager wsByteBufferManager = WsByteBufferPoolManagerImpl.getRef();
    private static final int jitBufferSize = 8192;
    boolean handlersStarted = false;
    private SyncInt numHandlersInFlight = new SyncInt(0);
    private int maxHandlersInFlight = 0;
    private int numTimesCompletionThreadStarted = 0;
    private long numItemsFromQueue = 0L;
    private long lastNumItemsFromQueue = 0L;
    private long numItemsFromNative = 0L;
    private int maxHandlers;
    private int minWaitingHandlers;
    private int maxWaitingHandlers;
    private SyncInt handlersWaiting = new SyncInt(0);
    private SyncInt handlersWaitingOnQueue = new SyncInt(0);
    private Runnable completionTask;
    private long completionPort;
    protected ThreadPool threadPool;
    protected CompletionProcessingRunnable completionProcessingRunnable = null;
    protected boolean completionProcessingThreadRunning = false;
    protected int syncBlockedThreads = 0;
    protected Object blockedThreadsSyncObject = new Object();
    protected CompletedFuturesLinkedList readyWorkItems;
    private static final int SIZE_THREAD = 32;
    private static final int SIZE_COMMON = 64;
    private static final TwoTierObjectPool workItemPool = new TwoTierObjectPool(32, 64);
    protected static int batchSize = 1;
    private ThreadLocal threadCompletionValueArray = new ThreadLocal(){

        protected synchronized Object initialValue() {
            CompletionKey[] completionKeyArray = new CompletionKey[batchSize];
            for (int i = 0; i < batchSize; ++i) {
                completionKeyArray[i] = new CompletionKey();
            }
            return completionKeyArray;
        }
    };

    public ResultHandler(ThreadPool threadPool, long l, CompletedFuturesLinkedList completedFuturesLinkedList) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "ResultHandler");
        }
        batchSize = provider.hasCapability(8) ? 32 : 1;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Batch size set to: " + batchSize);
        }
        this.completionPort = l;
        this.threadPool = threadPool;
        this.readyWorkItems = completedFuturesLinkedList;
        int n = threadPool.getMaximumPoolSize();
        if (threadPool instanceof com.ibm.ws.util.ThreadPool && ((com.ibm.ws.util.ThreadPool)threadPool).isGrowAsNeeded()) {
            n = 1000;
        }
        if (n > 1) {
            this.minWaitingHandlers = 1;
            this.maxHandlers = n;
            if (this.maxHandlers >= 10) {
                this.maxHandlers = this.maxHandlers * 9 / 10;
            }
            this.maxWaitingHandlers = AsyncProperties.maxThreadsWaitingForEvents + 1;
            if (this.maxWaitingHandlers >= this.maxHandlers / 2) {
                this.maxWaitingHandlers = this.maxHandlers / 2;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "completionPort = " + l + ", threadpool = " + threadPool);
            Tr.debug(tc, "maxHandlers = " + this.maxHandlers + " minWaitingHandlers = " + this.minWaitingHandlers + " maxWaitingHandlers = " + this.maxWaitingHandlers);
        }
        this.completionTask = this.getProcessCompletionEventTask();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "ResultHandler");
        }
    }

    void complete(AsyncFuture asyncFuture, int n, int n2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "complete, numBytes = " + n + ", rc = " + n2);
        }
        if (n2 == 0) {
            asyncFuture.setCancelInProgress(0);
            asyncFuture.completed(n);
        } else if (asyncFuture.getCancelInProgress() == 1) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "CancelInProgress() is 1, skip completing");
            }
            asyncFuture.setCancelInProgress(0);
        } else {
            String string = AsyncLibrary.getErrorMessage(n2);
            asyncFuture.completed(new IOException("Async IO operation failed, reason: " + string));
        }
    }

    public final void eventPending() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "eventPending");
        }
        if (!this.handlersStarted) {
            this.startHandler();
            this.handlersStarted = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void startHandler() {
        int n = 0;
        SyncInt syncInt2 = this.numHandlersInFlight;
        synchronized (syncInt2) {
            if (this.numHandlersInFlight.getInt() < this.maxHandlers) {
                n = this.numHandlersInFlight.incrementInt();
            }
        }
        if (n > 0) {
            int n2;
            if (n > this.maxHandlersInFlight) {
                this.maxHandlersInFlight = n;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "startHandler starting another handler thread from thread pool " + this.threadPool + " Completion Port: " + this.completionPort);
                Tr.debug(tc, "numHandlersInFlight = " + this.numHandlersInFlight.getInt() + ", handlersWaiting = " + this.handlersWaiting.getInt());
            }
            if ((n2 = this.threadPool.execute(this.completionTask, 3)) != 0) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "startHandler couldn't start another handler thread, rc = " + n2);
                }
                this.numHandlersInFlight.decrementInt();
                Exception exception = new Exception("internal error getting thread, rc = " + n2 + " from ThreadPool " + this.threadPool + " numHandlersInFlight =" + this.numHandlersInFlight.getInt());
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.io.async.ResultHandler.startHandler", (String)"186", (Object)this);
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "startHandler completed execute call to start another thread successfully");
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "MaxHandler reached");
            }
            if (this.syncBlockedThreads > 0) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Starting dedicated (constrained) thread");
                }
                this.startCompletionProcessingThread();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runEventProcessingLoop(boolean bl) {
        WsByteBuffer[] wsByteBufferArray;
        long[] lArray;
        boolean bl2;
        block109: {
            int n;
            bl2 = bl;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "runEventProcessingLoop");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "fromThreadPool: " + bl2 + " Completion Port: " + this.completionPort);
            }
            boolean bl3 = provider.hasCapability(4);
            boolean bl4 = provider.hasCapability(8);
            CompletionKey[] completionKeyArray = new CompletionKey[batchSize];
            long[] lArray2 = new long[batchSize];
            lArray = new long[batchSize];
            wsByteBufferArray = new WsByteBuffer[batchSize];
            CompletedFutureWorkItem[] completedFutureWorkItemArray = new CompletedFutureWorkItem[batchSize];
            int n2 = 0;
            int n3 = 0;
            CompletionKey completionKey = null;
            int n4 = 0;
            int n5 = 0;
            boolean bl5 = true;
            long l = 0L;
            boolean bl6 = false;
            if (bl2) {
                completionKeyArray = (CompletionKey[])this.threadCompletionValueArray.get();
                for (n = 0; n < batchSize; ++n) {
                    lArray2[n] = completionKeyArray[n].getAddress();
                }
            } else {
                for (n = 0; n < batchSize; ++n) {
                    completionKeyArray[n] = new CompletionKey();
                    lArray2[n] = completionKeyArray[n].getAddress();
                }
            }
            try {
                while (bl5) {
                    if (AsyncLibrary.aioInitialized == 2) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "thread was interrupted, ending loop");
                        }
                        break;
                    }
                    if (!bl2) {
                        boolean bl7 = false;
                        Object object = this;
                        synchronized (object) {
                            if (this.syncBlockedThreads < 1) {
                                if (this.numItemsFromQueue > this.lastNumItemsFromQueue + 20L) {
                                    this.completionProcessingThreadRunning = false;
                                    bl7 = true;
                                }
                            } else {
                                this.lastNumItemsFromQueue = this.numItemsFromQueue;
                            }
                        }
                        if (bl7) {
                            object = this.readyWorkItems;
                            synchronized (object) {
                                this.readyWorkItems.notifyAll();
                            }
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "dedicated thread no longer needed, ending loop");
                            }
                            break;
                        }
                    }
                    AsyncFuture asyncFuture = null;
                    if (bl2) {
                        CompletedFutureWorkItem completedFutureWorkItem = null;
                        CompletedFuturesLinkedList completedFuturesLinkedList = this.readyWorkItems;
                        synchronized (completedFuturesLinkedList) {
                            if (!this.readyWorkItems.isEmpty()) {
                                try {
                                    this.threadPool.setThreadWaiting(true);
                                    completedFutureWorkItem = (CompletedFutureWorkItem)this.readyWorkItems.removeFirst();
                                    this.threadPool.setThreadWaiting(false);
                                }
                                catch (NoSuchElementException noSuchElementException) {}
                            } else if (this.isCompletionProcessingThreadRunning() && this.handlersWaitingOnQueue.getInt() < 1) {
                                try {
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        Tr.debug(tc, "waiting for data to be put on the queue");
                                    }
                                    this.threadPool.setThreadWaiting(true);
                                    this.handlersWaitingOnQueue.incrementInt();
                                    this.readyWorkItems.wait(COMPLETION_TIMEOUT);
                                }
                                catch (InterruptedException interruptedException) {
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        Tr.debug(tc, "thread interrupted while waiting for data, exiting loop");
                                    }
                                    break;
                                }
                                finally {
                                    this.handlersWaitingOnQueue.decrementInt();
                                    this.threadPool.setThreadWaiting(false);
                                }
                                if (!this.readyWorkItems.isEmpty()) {
                                    try {
                                        completedFutureWorkItem = (CompletedFutureWorkItem)this.readyWorkItems.removeFirst();
                                    }
                                    catch (NoSuchElementException noSuchElementException) {}
                                } else if (this.isCompletionProcessingThreadRunning() && this.handlersWaitingOnQueue.getInt() < 1) {
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        Tr.debug(tc, "completion processing thread running, looping back to check work item list again");
                                    }
                                    continue;
                                }
                            }
                            if (completedFutureWorkItem != null) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "got work item off of the queue.  Completion port: " + this.completionPort);
                                }
                                ++this.numItemsFromQueue;
                                asyncFuture = completedFutureWorkItem.future;
                                n5 = completedFutureWorkItem.numBytes;
                                n4 = completedFutureWorkItem.returnCode;
                                workItemPool.put((Object)completedFutureWorkItem);
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "looking to see if new thread needs to go start.  handlers waiting: " + this.handlersWaiting.getInt() + " minWaitingHandlers: " + this.minWaitingHandlers);
                                }
                                if (this.handlersWaiting.getInt() < this.minWaitingHandlers) {
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        Tr.debug(tc, "calling starting new thread");
                                    }
                                    this.startHandler();
                                }
                            }
                        }
                    }
                    if (asyncFuture == null) {
                        int n6;
                        if (bl2) {
                            if (this.handlersWaiting.getInt() >= this.maxWaitingHandlers || bl6 && this.handlersWaiting.getInt() >= this.minWaitingHandlers) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Current handler no longer required, returning thread to threadpool");
                                    Tr.debug(tc, "numHandlersInFlight = " + this.numHandlersInFlight.getInt() + ", handlersWaiting = " + this.handlersWaiting.getInt());
                                }
                                break;
                            }
                            this.handlersWaiting.incrementInt();
                            this.threadPool.setThreadWaiting(true);
                        }
                        for (n6 = 0; n6 < batchSize; n6 += 1) {
                            if (lArray[n6] == 0L && bl3) {
                                wsByteBufferArray[n6] = this.wsByteBufferManager.allocateDirect(8192);
                                ByteBuffer byteBuffer = wsByteBufferArray[n6].getWrappedByteBuffer();
                                lArray[n6] = AbstractAsyncChannel.getBufAddress(byteBuffer);
                            }
                            completionKeyArray[n6].reset();
                            completionKeyArray[n6].setBuffer(lArray[n6], 8192L, 0);
                        }
                        try {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "waiting for event from native code for completionPort " + this.completionPort);
                            }
                            l = QuickApproxTime.getRef().getApproxTime();
                            bl6 = false;
                            if (bl4) {
                                n3 = provider.getCompletionData3(lArray2, batchSize, COMPLETION_TIMEOUT, this.completionPort);
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "events received from native code: " + n3);
                                }
                            } else {
                                n6 = provider.getCompletionData2(lArray2[0], COMPLETION_TIMEOUT, this.completionPort) ? 1 : 0;
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "done waiting (no batch) for events from native code: " + (n6 != 0));
                                }
                                if (n6) {
                                    n3 = 1;
                                    completionKeyArray[0].setReturnStatus(1);
                                } else {
                                    n3 = 0;
                                    completionKeyArray[0].setReturnStatus(0);
                                }
                            }
                        }
                        catch (AsyncException asyncException) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Error getting IO completion event", asyncException);
                            }
                            FFDCFilter.processException((Throwable)asyncException, (String)"com.ibm.io.async.ResultHandler.runEventProcessingLoop", (String)"331", (Object)this);
                        }
                        finally {
                            if (bl2) {
                                this.threadPool.setThreadWaiting(false);
                                this.handlersWaiting.decrementInt();
                            }
                            if (this.handlersWaiting.getInt() < this.minWaitingHandlers && n3 > 0) {
                                this.startHandler();
                            }
                        }
                        if (n3 == 0) {
                            if (QuickApproxTime.getRef().getApproxTime() - l < (long)COMPLETION_TIMEOUT) continue;
                            bl6 = true;
                            continue;
                        }
                        this.numItemsFromNative += (long)n3;
                        n2 = 0;
                        for (int i = n3 - 1; i >= 0; --i) {
                            Object object;
                            completionKey = completionKeyArray[i];
                            long l2 = completionKey.getCallIdentifier();
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "batch index: " + i + " call id: " + Long.toHexString(l2) + " channel id(hex): " + Long.toHexString(completionKey.getChannelIdentifier()) + " channel id(dec): " + completionKey.getChannelIdentifier());
                            }
                            int n7 = (int)(l2 & 0xFFFFFFFFFFFFFFFFL);
                            int n8 = (int)(l2 >> 32);
                            AbstractAsyncChannel abstractAsyncChannel = AbstractAsyncChannel.getChannelFromIndex(n7);
                            if (abstractAsyncChannel == null) {
                                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "Completion event could not find channel, channel may have just been closed " + completionKey);
                                continue;
                            }
                            asyncFuture = abstractAsyncChannel.getFutureFromIndex(n8);
                            if (asyncFuture == null) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Completion event could not find future" + completionKey);
                                }
                                object = new AsyncException("Future not found");
                                FFDCFilter.processException((Throwable)object, (String)"com.ibm.io.async.AsyncChannelGroup.CompletionProcessingThread", (String)"142", (Object)this);
                                continue;
                            }
                            if (completionKey.wasJITBufferUsed()) {
                                asyncFuture.setJITBuffer(wsByteBufferArray[i]);
                                lArray[i] = 0L;
                            } else {
                                asyncFuture.setJITBuffer(null);
                            }
                            n4 = completionKey.getReturnCode();
                            n5 = completionKey.getBytesAffected();
                            if (n8 == -3 || n8 == -4) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Processing Sync Request rc: " + n4);
                                }
                                if (n4 == 0) {
                                    if (n5 == 0) {
                                        object = new IOException("Async IO operation failed, internal error");
                                        FFDCFilter.processException((Throwable)object, (String)"com.ibm.io.async.ResultHandler", (String)"356");
                                        asyncFuture.completed((Exception)object);
                                        continue;
                                    }
                                    asyncFuture.setCancelInProgress(0);
                                    asyncFuture.completed(n5);
                                    continue;
                                }
                                if (asyncFuture.getCancelInProgress() == 1) {
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        Tr.debug(tc, "CancelInProgress() is 1, skip completing");
                                    }
                                    asyncFuture.setCancelInProgress(0);
                                    continue;
                                }
                                object = AsyncLibrary.getErrorMessage(n4);
                                asyncFuture.completed(new IOException("Async IO operation failed, reason: " + (String)object));
                                continue;
                            }
                            if (i != 0 || !bl2) {
                                object = (CompletedFutureWorkItem)workItemPool.get();
                                if (object == null) {
                                    object = new CompletedFutureWorkItem(asyncFuture, n5, n4);
                                } else {
                                    ((CompletedFutureWorkItem)object).future = asyncFuture;
                                    ((CompletedFutureWorkItem)object).numBytes = n5;
                                    ((CompletedFutureWorkItem)object).returnCode = n4;
                                }
                                completedFutureWorkItemArray[n2] = object;
                                if (i == 0 && ++n2 > 0) {
                                    CompletedFuturesLinkedList completedFuturesLinkedList = this.readyWorkItems;
                                    synchronized (completedFuturesLinkedList) {
                                        for (int j = n2 - 1; j >= 0; --j) {
                                            this.readyWorkItems.add(completedFutureWorkItemArray[j]);
                                        }
                                    }
                                    n2 = 0;
                                }
                                if (bl2) continue;
                                this.startHandler();
                                continue;
                            }
                            if (n2 > 0) {
                                object = this.readyWorkItems;
                                synchronized (object) {
                                    for (int j = n2 - 1; j >= 0; --j) {
                                        this.readyWorkItems.add(completedFutureWorkItemArray[j]);
                                    }
                                }
                                n2 = 0;
                            }
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "processing last batch item on user's thread");
                                Tr.debug(tc, "processing last batch item on user's thread. Completing future for callid: " + Long.toHexString(l2) + " channel id: " + Long.toHexString(completionKey.getChannelIdentifier()));
                            }
                            this.complete(asyncFuture, n5, n4);
                        }
                        if (n2 > 0) {
                            CompletedFuturesLinkedList completedFuturesLinkedList = this.readyWorkItems;
                            synchronized (completedFuturesLinkedList) {
                                for (int i = n2 - 1; i >= 0; --i) {
                                    this.readyWorkItems.add(completedFutureWorkItemArray[i]);
                                }
                            }
                            n2 = 0;
                        }
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                        if (n3 > batchSize) {
                            Tr.debug(tc, "!!Error keysReady is greater than batch size");
                            System.exit(1);
                            continue;
                        }
                        if (n3 == batchSize || n3 == 0) continue;
                        completionKey = completionKeyArray[n3];
                        int n9 = completionKey.getReturnCode();
                        int n10 = completionKey.getBytesAffected();
                        if (n9 == 0 && n10 == -1) continue;
                        Tr.debug(tc, "!!Error FOUND EXTRA KEY");
                        System.exit(1);
                        continue;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Completing Work");
                    }
                    this.complete(asyncFuture, n5, n4);
                }
            }
            catch (Throwable throwable) {
                if (AsyncLibrary.aioInitialized == 2) break block109;
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.io.async.ResultHandler.startHandler", (String)"792", (Object)this);
                throw new RuntimeException(throwable);
            }
        }
        if (bl2) {
            this.numHandlersInFlight.decrementInt();
        }
        for (int i = 0; i < batchSize; ++i) {
            if (lArray[i] == 0L) continue;
            wsByteBufferArray[i].release();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "runEventProcessingLoop for: " + this.threadPool);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incrementSyncBlockedThreads() {
        Object object = this.blockedThreadsSyncObject;
        synchronized (object) {
            ++this.syncBlockedThreads;
            if (this.syncBlockedThreads > this.maxHandlers - 2 || this.handlersWaiting.getInt() < 1) {
                this.startCompletionProcessingThread();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decrementSyncBlockedThreads() {
        Object object = this.blockedThreadsSyncObject;
        synchronized (object) {
            --this.syncBlockedThreads;
        }
    }

    protected synchronized boolean isCompletionProcessingThreadRunning() {
        return this.completionProcessingThreadRunning;
    }

    protected void dumpStatistics() {
        int n = this.handlersWaiting.getInt();
        int n2 = this.handlersWaitingOnQueue.getInt();
        int n3 = this.numHandlersInFlight.getInt();
        int n4 = this.maxHandlersInFlight;
        System.out.println("   Current number of threads waiting for events from native: " + n);
        System.out.println("   Current number of threads waiting for events from queue: " + n2);
        System.out.println("   Current number of threads processing requests: " + (n3 - n));
        System.out.println("   Current number of threads blocked waiting on synchronous requests: " + this.syncBlockedThreads);
        System.out.println("   Maximum number of threads used in last interval: " + n4);
        System.out.println("   Number of times event was obtained from queue: " + this.numItemsFromQueue);
        System.out.println("   Number of times event was obtained from native: " + this.numItemsFromNative);
        System.out.println("   Number of times the completion thread had to be started: " + this.numTimesCompletionThreadStarted);
        this.maxHandlersInFlight = n3;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append("[");
        return stringBuffer.toString();
    }

    Runnable getProcessCompletionEventTask() {
        return new Runnable(){

            public void run() {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.entry(tc, "getProcessCompletionEventTask>Runnable#run()", Thread.currentThread());
                }
                ResultHandler.this.runEventProcessingLoop(true);
            }
        };
    }

    protected synchronized void startCompletionProcessingThread() {
        if (!this.completionProcessingThreadRunning) {
            this.completionProcessingThreadRunning = true;
            if (this.completionProcessingRunnable == null) {
                this.completionProcessingRunnable = new CompletionProcessingRunnable();
            }
            ++this.numTimesCompletionThreadStarted;
            PrivilegedThreadStarter privilegedThreadStarter = new PrivilegedThreadStarter();
            AccessController.doPrivileged(privilegedThreadStarter);
        }
    }

    class PrivilegedThreadStarter
    implements PrivilegedAction {
        public void setParms() {
        }

        public Object run() {
            String string = "Completion Processing Thread for: " + ResultHandler.this.threadPool;
            Thread thread = new Thread(ResultHandler.this.completionProcessingRunnable);
            thread.setName(string);
            thread.setDaemon(true);
            thread.start();
            return null;
        }
    }

    class CompletionProcessingRunnable
    implements Runnable {
        public void run() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "completionProcessingRunnable for: " + ResultHandler.this.threadPool);
            }
            ResultHandler.this.runEventProcessingLoop(false);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "completionProcessingRunnable for: " + ResultHandler.this.threadPool);
            }
        }
    }
}

