/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.io.async;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.io.async.AsyncProperties;
import com.ibm.io.async.IAbstractAsyncFuture;
import com.ibm.io.async.TimeSlot;
import com.ibm.io.async.TimerCallback;
import com.ibm.io.async.TimerLinkedList;
import com.ibm.io.async.TimerWorkItem;
import com.ibm.ws.timeutils.QuickApproxTime;

public class Timer
extends Thread {
    public static final long TIMESLOT_PRUNING_THRESHOLD = 4096L;
    public static final long TIMEOUT_CHECKING_THRESHOLD = 1000L;
    TimeSlot firstSlot = null;
    TimeSlot lastSlot = null;
    public static final long timeoutResolution = -1024L;
    public static final long timeoutRoundup = 1024L;
    protected TimerLinkedList requestQueue1 = new TimerLinkedList();
    protected TimerLinkedList requestQueue2 = new TimerLinkedList();
    protected int queueToUse = 1;
    protected static int numQueues = AsyncProperties.numTimerQueues;
    protected static final TraceComponent tc = Tr.register(Timer.class, "TCPChannel", "com.ibm.ws.tcp.channel.resources.tcpchannelmessages");
    boolean waitingFlag = false;

    public Timer() {
        if (AsyncProperties.disableTimeouts) {
            return;
        }
        if (numQueues > 2) {
            numQueues = 2;
        }
        this.setName("AIO Timer Thread 1");
        this.setDaemon(true);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimerWorkItem createTimeoutRequest(long l, TimerCallback timerCallback, IAbstractAsyncFuture iAbstractAsyncFuture) {
        TimerWorkItem timerWorkItem = new TimerWorkItem(l, timerCallback, iAbstractAsyncFuture, iAbstractAsyncFuture.getReuseCount());
        iAbstractAsyncFuture.setTimeoutWorkItem(timerWorkItem);
        if (this.queueToUse == 1 || numQueues == 1) {
            TimerLinkedList timerLinkedList = this.requestQueue1;
            synchronized (timerLinkedList) {
                this.requestQueue1.add(timerWorkItem);
            }
        }
        TimerLinkedList timerLinkedList = this.requestQueue2;
        synchronized (timerLinkedList) {
            this.requestQueue2.add(timerWorkItem);
        }
        return timerWorkItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int n = 0;
        TimerWorkItem[] timerWorkItemArray = null;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        int n2 = 1;
        int n3 = 0;
        int n4 = AsyncProperties.timerSleepTime;
        int n5 = AsyncProperties.timerBatchSize;
        boolean bl = AsyncProperties.timerSleepAlways;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Timeout thread running with the following parameters");
            Tr.debug(tc, "numQueues:      " + numQueues);
            Tr.debug(tc, "sleepAlways:    " + bl);
            Tr.debug(tc, "sleepTime:      " + n4);
            Tr.debug(tc, "batchLimitSize: " + n5);
        }
        timerWorkItemArray = new TimerWorkItem[n5];
        l = QuickApproxTime.getRef().getApproxTime();
        while (true) {
            TimerLinkedList timerLinkedList;
            if (n2 == 0 || bl) {
                try {
                    Thread.sleep(n4);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            n = 0;
            if (this.queueToUse == 1 || numQueues == 1) {
                this.queueToUse = 2;
                timerLinkedList = this.requestQueue1;
                synchronized (timerLinkedList) {
                    n2 = this.requestQueue1.size();
                    if (n2 != 0) {
                        for (n3 = 0; n3 < n2 && n < n5; ++n3) {
                            timerWorkItemArray[n] = (TimerWorkItem)this.requestQueue1.removeFirst();
                            if (timerWorkItemArray[n].state == 2L) continue;
                            ++n;
                        }
                    }
                }
            }
            this.queueToUse = 1;
            timerLinkedList = this.requestQueue2;
            synchronized (timerLinkedList) {
                n2 = this.requestQueue2.size();
                if (n2 != 0) {
                    for (n3 = 0; n3 < n2 && n < n5; ++n3) {
                        timerWorkItemArray[n] = (TimerWorkItem)this.requestQueue2.removeFirst();
                        if (timerWorkItemArray[n].state == 2L) continue;
                        ++n;
                    }
                }
            }
            for (n3 = 0; n3 < n; ++n3) {
                if (timerWorkItemArray[n3].state == 2L) continue;
                this.insertWorkItem(timerWorkItemArray[n3], l);
            }
            l = QuickApproxTime.getRef().getApproxTime();
            if (l - l3 > 1000L) {
                this.checkForTimeouts(l);
                l3 = l;
            }
            if (l - l2 <= 4096L) continue;
            this.timeSlotPruning(l);
            l2 = l;
        }
    }

    public void timeSlotPruning(long l) {
        TimeSlot timeSlot = this.firstSlot;
        TimeSlot timeSlot2 = null;
        int n = 0;
        while (timeSlot != null) {
            timeSlot2 = timeSlot.nextEntry;
            if (l - timeSlot.mostRecentlyAccessedTime > 4096L) {
                int n2;
                for (n2 = n = timeSlot.lastEntryIndex; n2 >= 0 && timeSlot.entries[n2].state != 1L; --n2) {
                }
                if (n2 < 0) {
                    this.removeSlot(timeSlot);
                }
            }
            timeSlot = timeSlot2;
        }
    }

    public void insertWorkItem(TimerWorkItem timerWorkItem, long l) {
        long l2 = timerWorkItem.timeoutTime;
        TimeSlot timeSlot = this.firstSlot;
        while (timeSlot != null) {
            if (l2 == timeSlot.timeoutTime && timeSlot.lastEntryIndex != 299) {
                timeSlot.addEntry(timerWorkItem, l);
                break;
            }
            if (l2 < timeSlot.timeoutTime) {
                timeSlot = this.insertSlot(l2, timeSlot);
                timeSlot.addEntry(timerWorkItem, l);
                break;
            }
            timeSlot = timeSlot.nextEntry;
        }
        if (timeSlot == null) {
            timeSlot = this.insertSlotAtEnd(l2);
            timeSlot.addEntry(timerWorkItem, l);
        }
    }

    public TimeSlot insertSlot(long l, TimeSlot timeSlot) {
        TimeSlot timeSlot2 = new TimeSlot(l);
        timeSlot2.nextEntry = timeSlot;
        timeSlot2.prevEntry = timeSlot.prevEntry;
        if (timeSlot2.prevEntry != null) {
            timeSlot2.prevEntry.nextEntry = timeSlot2;
        } else {
            this.firstSlot = timeSlot2;
        }
        timeSlot.prevEntry = timeSlot2;
        return timeSlot2;
    }

    public TimeSlot insertSlotAtEnd(long l) {
        TimeSlot timeSlot = new TimeSlot(l);
        if (this.lastSlot == null) {
            this.lastSlot = timeSlot;
            this.firstSlot = timeSlot;
        } else {
            timeSlot.prevEntry = this.lastSlot;
            this.lastSlot.nextEntry = timeSlot;
            this.lastSlot = timeSlot;
        }
        return timeSlot;
    }

    public void removeSlot(TimeSlot timeSlot) {
        if (timeSlot.nextEntry != null) {
            timeSlot.nextEntry.prevEntry = timeSlot.prevEntry;
        } else {
            this.lastSlot = timeSlot.prevEntry;
        }
        if (timeSlot.prevEntry != null) {
            timeSlot.prevEntry.nextEntry = timeSlot.nextEntry;
        } else {
            this.firstSlot = timeSlot.nextEntry;
        }
    }

    public void checkForTimeouts(long l) {
        TimeSlot timeSlot = this.firstSlot;
        TimerWorkItem timerWorkItem = null;
        TimeSlot timeSlot2 = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "looking for timeouts");
        }
        while (timeSlot != null && l >= timeSlot.timeoutTime) {
            int n = timeSlot.lastEntryIndex;
            for (int i = 0; i <= n; ++i) {
                timerWorkItem = timeSlot.entries[i];
                if (timerWorkItem.state != 1L) continue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found a timeout, calling timerTriggered");
                }
                timerWorkItem.state = 2L;
                timerWorkItem.callback.timerTriggered(timerWorkItem);
            }
            timeSlot2 = timeSlot;
            this.removeSlot(timeSlot2);
            timeSlot = timeSlot.nextEntry;
        }
    }
}

