/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivj.ejb.associations.links;

import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

public abstract class Link {
    protected EntityBean source;
    protected boolean isComplete = false;
    protected boolean isRequired = false;
    protected boolean isComposite = false;
    protected boolean isComponent = false;
    protected boolean isConstrained = false;
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 2000";
    private static InitialContext initialContext = null;
    private static final String defaultContextFactoryName = "com.ibm.ejs.ns.jndi.CNInitialContextFactory";
    private static final String dynamicContextFactoryPropertyName = "java.naming.factory.initial";

    public Link(EntityBean entityBean) {
        this.source = entityBean;
    }

    public void beComponent() {
        this.isComponent = true;
        this.isComposite = false;
    }

    public void beComposite() {
        this.isComposite = true;
        this.isComponent = false;
    }

    public void beNoAggregation() {
        this.isComponent = false;
        this.isComposite = false;
    }

    protected boolean canQuery() throws RemoteException {
        return this.isKeyValid();
    }

    private static String contextFactoryName() {
        String string = Link.getSystemProperty(dynamicContextFactoryPropertyName);
        if (string != null) {
            return string;
        }
        return defaultContextFactoryName;
    }

    private static String getSystemProperty(final String string) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(string);
            }
        });
    }

    public abstract EntityContext getEntityContext();

    protected static synchronized InitialContext getInitialContext() throws NamingException {
        if (initialContext == null) {
            Properties properties = new Properties();
            properties.put(dynamicContextFactoryPropertyName, Link.contextFactoryName());
            initialContext = new InitialContext(properties);
        }
        return initialContext;
    }

    protected abstract boolean isKeyValid() throws RemoteException;

    protected static EJBHome lookupTargetHome(String string, Class clazz) throws NamingException {
        Object object = Link.getInitialContext().lookup(string);
        return (EJBHome)PortableRemoteObject.narrow((Object)object, (Class)clazz);
    }

    public abstract void remove() throws RemoteException, RemoveException, FinderException;

    protected abstract void stitchTo(EJBObject var1) throws RemoteException;
}

