/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jrom.convertors;

import com.ibm.jrom.JROMComplexValue;
import com.ibm.jrom.JROMException;
import com.ibm.jrom.JROMIntegerValue;
import com.ibm.jrom.JROMQNameValue;
import com.ibm.jrom.JROMStringValue;
import com.ibm.jrom.JROMType;
import com.ibm.jrom.JROMValue;
import com.ibm.jrom.factory.JROMFactory;
import com.ibm.jrom.util.ConvertorUtils;
import com.ibm.jrom.util.JROMUtils;
import com.ibm.jrom.util.xml.NSStack;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;

public class JROM2XML {
    static final String schemaNS = "http://www.w3.org/2001/XMLSchema";
    static final String schemaxsi = "http://www.w3.org/2001/XMLSchema-instance";

    public static Map createDefaultTypeMap() {
        HashMap<JROMType, QName> hashMap = new HashMap<JROMType, QName>();
        hashMap.put(JROMType.JROM_STRING_VALUE, new QName(schemaNS, "string"));
        hashMap.put(JROMType.JROM_BOOLEAN_VALUE, new QName(schemaNS, "boolean"));
        hashMap.put(JROMType.JROM_FLOAT_VALUE, new QName(schemaNS, "float"));
        hashMap.put(JROMType.JROM_DOUBLE_VALUE, new QName(schemaNS, "double"));
        hashMap.put(JROMType.JROM_DECIMAL_VALUE, new QName(schemaNS, "decimal"));
        hashMap.put(JROMType.JROM_DURATION_VALUE, new QName(schemaNS, "duration"));
        hashMap.put(JROMType.JROM_TIME_VALUE, new QName(schemaNS, "dateTime"));
        hashMap.put(JROMType.JROM_DATE_VALUE, new QName(schemaNS, "date"));
        hashMap.put(JROMType.JROM_BASE64BINARY_VALUE, new QName(schemaNS, "base64Binary"));
        hashMap.put(JROMType.JROM_QNAME_VALUE, new QName(schemaNS, "QName"));
        hashMap.put(JROMType.JROM_BYTE_VALUE, new QName(schemaNS, "byte"));
        hashMap.put(JROMType.JROM_LONG_VALUE, new QName(schemaNS, "long"));
        hashMap.put(JROMType.JROM_SHORT_VALUE, new QName(schemaNS, "short"));
        hashMap.put(JROMType.JROM_INTEGER_VALUE, new QName(schemaNS, "int"));
        return hashMap;
    }

    public static Writer convert(JROMValue jROMValue) throws JROMException, IOException {
        StringWriter stringWriter = new StringWriter();
        NSStack nSStack = new NSStack();
        JROM2XML.convert(jROMValue, null, false, stringWriter, nSStack);
        return stringWriter;
    }

    public static void convert(JROMValue jROMValue, Map map, boolean bl, Writer writer) throws JROMException, IOException {
        JROM2XML.convert(jROMValue, map, bl, writer, new NSStack());
    }

    public static void convert(JROMValue jROMValue, Map map, boolean bl, Writer writer, NSStack nSStack) throws JROMException, IOException {
        boolean bl2 = false;
        nSStack.pushScope();
        QName qName = new QName(jROMValue.getNameNamespace(), jROMValue.getNameLocalPart());
        QName qName2 = null;
        if (jROMValue.getJROMType() != JROMType.JROM_COMPLEX_VALUE) {
            if (bl && (qName2 = (QName)map.get(jROMValue.getJROMType())) == null) {
                throw new JROMException("Could not find a QName for the type of JROM " + jROMValue);
            }
            JROM2XML.convertSimpleJROM(jROMValue, bl, qName, qName2, writer, nSStack);
        } else {
            JROMComplexValue jROMComplexValue = (JROMComplexValue)jROMValue;
            Iterator iterator = jROMComplexValue.getAttributeValues();
            Iterator iterator2 = jROMComplexValue.getElementValues();
            qName2 = new QName(jROMComplexValue.getTypeNamespace(), jROMComplexValue.getTypeLocalPart());
            bl2 = jROMComplexValue.getNumElements() == 0 && jROMComplexValue.getNumAttributes() == 0;
            JROM2XML.generateOpeningBrace(qName2, qName, bl, iterator, writer, nSStack, bl2);
            while (iterator2.hasNext()) {
                JROMValue jROMValue2 = (JROMValue)iterator2.next();
                JROM2XML.convert(jROMValue2, map, bl, writer, nSStack);
            }
            if (!bl2) {
                JROM2XML.generateClosingBrace(qName, nSStack, writer);
            }
        }
        writer.write(JROMUtils.lineSeparator);
        nSStack.popScope();
    }

    protected static void convertSimpleJROM(JROMValue jROMValue, boolean bl, QName qName, QName qName2, Writer writer, NSStack nSStack) throws JROMException, IOException {
        boolean bl2 = false;
        String string = JROM2XML.getStringFromSimpleJROM(jROMValue, nSStack, writer);
        bl2 = string == null;
        JROM2XML.generateOpeningBrace(qName2, qName, bl, null, writer, nSStack, bl2);
        if (!bl2) {
            writer.write(string);
            JROM2XML.generateClosingBrace(qName, nSStack, writer);
            writer.write(JROMUtils.lineSeparator);
        }
    }

    protected static void generateClosingBrace(QName qName, NSStack nSStack, Writer writer) throws IOException {
        String string = null;
        String string2 = qName.getNamespaceURI();
        if (string2 != null && !string2.equals("")) {
            string = nSStack.getPrefixFromURI(string2);
        }
        if (string != null) {
            writer.write("</" + string + ":" + qName.getLocalPart() + ">");
        } else {
            writer.write("</" + qName.getLocalPart() + ">");
        }
    }

    protected static void generateOpeningBrace(QName qName, QName qName2, boolean bl, Iterator iterator, Writer writer, NSStack nSStack, boolean bl2) throws JROMException, IOException {
        String string;
        Object object;
        String string2 = "";
        String string3 = qName2.getNamespaceURI();
        String string4 = null;
        if (string3 != null && !string3.equals("") && (string4 = nSStack.getPrefixFromURI(string3)) == null) {
            string4 = nSStack.addNSDeclaration(string3);
            string2 = " xmlns:" + string4 + "=\"" + string3 + '\"';
        }
        writer.write('<' + string4 + ":" + qName2.getLocalPart() + string2);
        if (bl) {
            if (qName.getLocalPart() == null || qName.getLocalPart().equals("")) {
                throw new JROMException("Cannot create a type attribute for a JROM with an anonymous type");
            }
            object = nSStack.getPrefixFromURI(qName.getNamespaceURI(), writer);
            string = nSStack.getPrefixFromURI(schemaxsi, writer);
            writer.write(' ' + string + ':' + "type" + "=\"" + (String)object + ':' + qName.getLocalPart() + '\"');
        }
        if (bl2) {
            object = nSStack.getPrefixFromURI(schemaxsi, writer);
            writer.write(' ' + (String)object + ':' + "nillable" + "=\"true\"/");
        }
        if (iterator != null) {
            while (iterator.hasNext()) {
                object = (JROMValue)iterator.next();
                string = object.getNameNamespace();
                String string5 = object.getNameLocalPart();
                writer.write(32);
                if (string != null && string.equals("")) {
                    String string6 = nSStack.getPrefixFromURI(qName.getNamespaceURI(), writer);
                    writer.write(string6 + ':');
                }
                if (string5 == null || string5.equals("")) {
                    throw new JROMException("cannot have an attribute without a name");
                }
                writer.write(string5 + "=\"" + JROM2XML.getStringFromSimpleJROM((JROMValue)object, nSStack, writer) + '\"');
            }
        }
        writer.write(62);
    }

    protected static String getStringFromSimpleJROM(JROMValue jROMValue, NSStack nSStack, Writer writer) throws JROMException, IOException {
        String string = null;
        if (jROMValue.getJROMType().equals(JROMType.JROM_QNAME_VALUE)) {
            QName qName = ((JROMQNameValue)jROMValue).getValue();
            if (qName != null) {
                string = nSStack.getPrefixFromURI(qName.getNamespaceURI(), writer);
            }
        } else {
            string = ConvertorUtils.getStringFromSJROM(jROMValue);
        }
        if (jROMValue.getJROMType().equals(JROMType.JROM_STRING_VALUE)) {
            string = JROMUtils.xmlizeString(string);
        }
        return string;
    }

    public static void main(String[] stringArray) throws JROMException, IOException {
        JROMFactory jROMFactory = JROMFactory.newInstance();
        JROMComplexValue jROMComplexValue = jROMFactory.newJROMComplexValue("http://foo.com", "addressType");
        jROMComplexValue.setNameNamespace("http://foo.com");
        jROMComplexValue.setNameLocalPart("address");
        JROMStringValue jROMStringValue = jROMFactory.newJROMStringValue();
        jROMStringValue.setValue("Sanjiva Street");
        jROMStringValue.setNameNamespace("http://foo.com");
        jROMStringValue.setNameLocalPart("streetName");
        jROMComplexValue.addElementValue(jROMStringValue);
        JROMStringValue jROMStringValue2 = jROMFactory.newJROMStringValue();
        jROMStringValue2.setValue("Weerawarana");
        jROMStringValue2.setNameNamespace("http://foo.com");
        jROMStringValue2.setNameLocalPart("city");
        jROMComplexValue.addElementValue(jROMStringValue2);
        JROMStringValue jROMStringValue3 = jROMFactory.newJROMStringValue();
        jROMStringValue3.setValue("Weerawarandom");
        jROMStringValue3.setNameNamespace("http://foo.com");
        jROMStringValue3.setNameLocalPart("state");
        jROMComplexValue.addElementValue(jROMStringValue3);
        JROMIntegerValue jROMIntegerValue = jROMFactory.newJROMIntegerValue();
        jROMIntegerValue.setValue(34);
        jROMIntegerValue.setNameNamespace("");
        jROMIntegerValue.setNameLocalPart("zip");
        jROMComplexValue.addAttributeValue(jROMIntegerValue);
        JROMIntegerValue jROMIntegerValue2 = jROMFactory.newJROMIntegerValue();
        jROMIntegerValue2.setValue(55);
        jROMIntegerValue2.setNameNamespace("");
        jROMIntegerValue2.setNameLocalPart("streetNum");
        jROMComplexValue.addAttributeValue(jROMIntegerValue2);
        JROMComplexValue jROMComplexValue2 = jROMFactory.newJROMComplexValue("http://foo.com", "phoneType");
        jROMComplexValue2.setNameNamespace("");
        jROMComplexValue2.setNameLocalPart("phoneNumber");
        JROMStringValue jROMStringValue4 = jROMFactory.newJROMStringValue();
        jROMStringValue4.setValue("exchange");
        jROMStringValue4.setNameLocalPart("exchange");
        jROMComplexValue2.addElementValue(jROMStringValue4);
        JROMStringValue jROMStringValue5 = jROMFactory.newJROMStringValue();
        jROMStringValue5.setValue("248/109");
        jROMStringValue5.setNameLocalPart("number");
        jROMComplexValue2.addElementValue(jROMStringValue5);
        JROMIntegerValue jROMIntegerValue3 = jROMFactory.newJROMIntegerValue();
        jROMIntegerValue3.setValue(617);
        jROMIntegerValue3.setNameNamespace("http://foo.com");
        jROMIntegerValue3.setNameLocalPart("areaCode");
        jROMComplexValue2.addAttributeValue(jROMIntegerValue3);
        jROMComplexValue.addElementValue(jROMComplexValue2);
        Map map = JROM2XML.createDefaultTypeMap();
        System.out.println("starting with JROM: " + jROMComplexValue);
        System.out.println("converting to xml");
        Writer writer = JROM2XML.convert(jROMComplexValue);
        StringReader stringReader = new StringReader(writer.toString());
        System.out.println("marshalled into " + writer.toString());
    }
}

