/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jrom.convertors;

import com.ibm.jrom.JROMComplexValue;
import com.ibm.jrom.JROMException;
import com.ibm.jrom.JROMType;
import com.ibm.jrom.JROMValue;
import com.ibm.jrom.factory.JROMFactory;
import com.ibm.jrom.util.ConvertorUtils;
import com.ibm.jrom.util.JROMUtils;
import com.ibm.jrom.util.xml.DOMUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XML2JROM {
    static DocumentBuilder parser;
    static JROMFactory factory;
    static final String schemaNS = "http://www.w3.org/2001/XMLSchema";
    static final String schemaxsi = "http://www.w3.org/2001/XMLSchema-instance";

    public static Map createDefaultTypeMap() {
        HashMap<QName, JROMType> hashMap = new HashMap<QName, JROMType>();
        hashMap.put(new QName(schemaNS, "string"), JROMType.JROM_STRING_VALUE);
        hashMap.put(new QName(schemaNS, "normalizedString"), JROMType.JROM_STRING_VALUE);
        hashMap.put(new QName(schemaNS, "NMTOKEN"), JROMType.JROM_STRING_VALUE);
        hashMap.put(new QName(schemaNS, "Name"), JROMType.JROM_STRING_VALUE);
        hashMap.put(new QName(schemaNS, "language"), JROMType.JROM_STRING_VALUE);
        hashMap.put(new QName(schemaNS, "token"), JROMType.JROM_STRING_VALUE);
        hashMap.put(new QName(schemaNS, "NCName"), JROMType.JROM_STRING_VALUE);
        hashMap.put(new QName(schemaNS, "boolean"), JROMType.JROM_BOOLEAN_VALUE);
        hashMap.put(new QName(schemaNS, "float"), JROMType.JROM_FLOAT_VALUE);
        hashMap.put(new QName(schemaNS, "double"), JROMType.JROM_DOUBLE_VALUE);
        hashMap.put(new QName(schemaNS, "decimal"), JROMType.JROM_DECIMAL_VALUE);
        hashMap.put(new QName(schemaNS, "duration"), JROMType.JROM_DURATION_VALUE);
        hashMap.put(new QName(schemaNS, "dateTime"), JROMType.JROM_TIME_VALUE);
        hashMap.put(new QName(schemaNS, "date"), JROMType.JROM_DATE_VALUE);
        hashMap.put(new QName(schemaNS, "base64Binary"), JROMType.JROM_BASE64BINARY_VALUE);
        hashMap.put(new QName(schemaNS, "QName"), JROMType.JROM_QNAME_VALUE);
        hashMap.put(new QName(schemaNS, "byte"), JROMType.JROM_BYTE_VALUE);
        hashMap.put(new QName(schemaNS, "long"), JROMType.JROM_LONG_VALUE);
        hashMap.put(new QName(schemaNS, "short"), JROMType.JROM_SHORT_VALUE);
        hashMap.put(new QName(schemaNS, "integer"), JROMType.JROM_INTEGER_VALUE);
        hashMap.put(new QName(schemaNS, "nonNegativeInteger"), JROMType.JROM_INTEGER_VALUE);
        hashMap.put(new QName(schemaNS, "nonPositiveInteger"), JROMType.JROM_INTEGER_VALUE);
        hashMap.put(new QName(schemaNS, "negativeInteger"), JROMType.JROM_INTEGER_VALUE);
        hashMap.put(new QName(schemaNS, "positiveInteger"), JROMType.JROM_INTEGER_VALUE);
        hashMap.put(new QName(schemaNS, "int"), JROMType.JROM_INTEGER_VALUE);
        return hashMap;
    }

    public static JROMValue convert(Element element, Map map) throws JROMException {
        boolean bl = false;
        String string = DOMUtils.getAttributeNS(element, schemaxsi, "type");
        if (string == null) {
            throw new JROMException("tyring to convert an element into JROM that has no xsi:type attribute");
        }
        String[] stringArray = JROMUtils.splitStringOnColon(string);
        String string2 = DOMUtils.getNamespaceURIFromPrefix(element, stringArray[0]);
        String string3 = stringArray[1];
        QName qName = new QName(string2, string3);
        String string4 = element.getNamespaceURI();
        String string5 = XML2JROM.getNameLocalPart(element);
        if (DOMUtils.getFirstChildElement(element) != null) {
            bl = true;
        }
        if (!bl) {
            JROMType jROMType = (JROMType)map.get(qName);
            if (jROMType == null) {
                throw new JROMException("No mapping found from type " + qName + " to a JROM type");
            }
            String string6 = DOMUtils.getChildCharacterData(element);
            if (jROMType.equals(JROMType.JROM_QNAME_VALUE)) {
                String[] stringArray2 = JROMUtils.splitStringOnColon(string6);
                if (stringArray2[0] == null) {
                    throw new JROMException("Trying to deserialize a qname that has no prefix");
                }
                String string7 = DOMUtils.getNamespaceURIFromPrefix(element, stringArray2[0]);
                QName qName2 = new QName(string7, stringArray2[1]);
                return ConvertorUtils.createSimpleJrom(factory, jROMType, qName2, string4, string5, null);
            }
            return ConvertorUtils.createSimpleJROMFromString(factory, jROMType, string6, string4, string5, null);
        }
        JROMComplexValue jROMComplexValue = factory.newJROMComplexValue(string2, string3);
        Element element2 = DOMUtils.getFirstChildElement(element);
        jROMComplexValue.setNameNamespace(string4);
        jROMComplexValue.setNameLocalPart(string5);
        while (element2 != null) {
            jROMComplexValue.addElementValue(XML2JROM.convert(element2, map));
            element2 = DOMUtils.getNextSiblingElement(element2);
        }
        return jROMComplexValue;
    }

    protected static String getNameLocalPart(Element element) {
        String[] stringArray = JROMUtils.splitStringOnColon(element.getTagName());
        return stringArray[1];
    }

    public static void main(String[] stringArray) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(false);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new File(stringArray[0]));
        Element element = document.getDocumentElement();
        JROMValue jROMValue = XML2JROM.convert(element, XML2JROM.createDefaultTypeMap());
        System.out.println(jROMValue);
    }

    static {
        try {
            factory = JROMFactory.newInstance();
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }
}

