/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jrom.factory;

import com.ibm.jrom.JROMBase64BinaryValue;
import com.ibm.jrom.JROMBooleanValue;
import com.ibm.jrom.JROMByteValue;
import com.ibm.jrom.JROMComplexValue;
import com.ibm.jrom.JROMDateValue;
import com.ibm.jrom.JROMDecimalValue;
import com.ibm.jrom.JROMDoubleValue;
import com.ibm.jrom.JROMDurationValue;
import com.ibm.jrom.JROMException;
import com.ibm.jrom.JROMFloatValue;
import com.ibm.jrom.JROMIntegerValue;
import com.ibm.jrom.JROMLongValue;
import com.ibm.jrom.JROMQNameValue;
import com.ibm.jrom.JROMShortValue;
import com.ibm.jrom.JROMStringValue;
import com.ibm.jrom.JROMTimeValue;
import com.ibm.jrom.JROMType;
import com.ibm.jrom.JROMValue;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.namespace.QName;

public abstract class JROMFactory {
    private static final String PROPERTY_NAME = "com.ibm.jrom.factory.JROMFactory";
    private static final String PROPERTY_FILE_NAME = "jrom.properties";
    private static final String DEFAULT_FACTORY_IMPL_NAME = "com.ibm.cs.jrom.factory.JROMFactoryImpl";
    private static String fullPropertyFileName = null;

    public static JROMFactory newInstance() throws JROMException {
        String string = JROMFactory.findFactoryImplName();
        return JROMFactory.newInstance(string);
    }

    public static JROMFactory newInstance(String string) throws JROMException {
        if (string != null) {
            try {
                Class<?> clazz = Class.forName(string);
                return (JROMFactory)clazz.newInstance();
            }
            catch (Exception exception) {
                throw new JROMException("Problem instantiating factory implementation: " + exception.getMessage());
            }
        }
        throw new JROMException("Unable to find name of factory implementation.");
    }

    public JROMValue copyJROMInstance(JROMValue jROMValue) {
        return this.copyJROMInstanceHelper(jROMValue, null);
    }

    private JROMValue copyJROMInstanceHelper(JROMValue jROMValue, JROMComplexValue jROMComplexValue) {
        JROMType jROMType = jROMValue.getJROMType();
        if (!jROMType.equals(JROMType.JROM_COMPLEX_VALUE)) {
            JROMValue jROMValue2;
            if (jROMType.equals(JROMType.JROM_INTEGER_VALUE)) {
                jROMValue2 = this.newJROMIntegerValue(jROMComplexValue);
                jROMValue2.setValue(((JROMIntegerValue)jROMValue).getValue());
            } else if (jROMType.equals(JROMType.JROM_STRING_VALUE)) {
                jROMValue2 = this.newJROMStringValue(jROMComplexValue);
                String string = ((JROMStringValue)jROMValue).getValue();
                ((JROMStringValue)jROMValue2).setValue(string);
            } else if (jROMType.equals(JROMType.JROM_BOOLEAN_VALUE)) {
                jROMValue2 = this.newJROMBooleanValue(jROMComplexValue);
                ((JROMBooleanValue)jROMValue2).setValue(((JROMBooleanValue)jROMValue).getValue());
            } else if (jROMType.equals(JROMType.JROM_DOUBLE_VALUE)) {
                jROMValue2 = this.newJROMDoubleValue(jROMComplexValue);
                ((JROMDoubleValue)jROMValue2).setValue(((JROMDoubleValue)jROMValue).getValue());
            } else if (jROMType.equals(JROMType.JROM_FLOAT_VALUE)) {
                jROMValue2 = this.newJROMFloatValue(jROMComplexValue);
                ((JROMFloatValue)jROMValue2).setValue(((JROMFloatValue)jROMValue).getValue());
            } else if (jROMType.equals(JROMType.JROM_LONG_VALUE)) {
                jROMValue2 = this.newJROMLongValue(jROMComplexValue);
                ((JROMLongValue)jROMValue2).setValue(((JROMLongValue)jROMValue).getValue());
            } else if (jROMType.equals(JROMType.JROM_BYTE_VALUE)) {
                jROMValue2 = this.newJROMByteValue(jROMComplexValue);
                ((JROMByteValue)jROMValue2).setValue(((JROMByteValue)jROMValue).getValue());
            } else if (jROMType.equals(JROMType.JROM_SHORT_VALUE)) {
                jROMValue2 = this.newJROMShortValue(jROMComplexValue);
                ((JROMShortValue)jROMValue2).setValue(((JROMShortValue)jROMValue).getValue());
            } else if (jROMType.equals(JROMType.JROM_DECIMAL_VALUE)) {
                jROMValue2 = this.newJROMDecimalValue(jROMComplexValue);
                BigDecimal bigDecimal = ((JROMDecimalValue)jROMValue).getValue();
                if (bigDecimal != null) {
                    ((JROMDecimalValue)jROMValue2).setValue(new BigDecimal(bigDecimal.toString()));
                }
            } else if (jROMType.equals(JROMType.JROM_DATE_VALUE)) {
                jROMValue2 = this.newJROMDateValue(jROMComplexValue);
                GregorianCalendar gregorianCalendar = ((JROMDateValue)jROMValue).getValue();
                if (gregorianCalendar != null) {
                    ((JROMDateValue)jROMValue2).setValue((GregorianCalendar)((Calendar)gregorianCalendar).clone());
                }
            } else if (jROMType.equals(JROMType.JROM_TIME_VALUE)) {
                jROMValue2 = this.newJROMTimeValue(jROMComplexValue);
                Date date = ((JROMTimeValue)jROMValue).getValue();
                if (date != null) {
                    ((JROMTimeValue)jROMValue2).setValue((Date)date.clone());
                }
            } else if (jROMType.equals(JROMType.JROM_QNAME_VALUE)) {
                jROMValue2 = this.newJROMQNameValue(jROMComplexValue);
                QName qName = ((JROMQNameValue)jROMValue).getValue();
                if (qName != null) {
                    ((JROMQNameValue)jROMValue2).setValue(new QName(qName.getNamespaceURI(), qName.getLocalPart()));
                }
            } else if (jROMType.equals(JROMType.JROM_BASE64BINARY_VALUE)) {
                jROMValue2 = this.newJROMBase64BinaryValue(jROMComplexValue);
                byte[] byArray = ((JROMBase64BinaryValue)jROMValue).getValue();
                if (byArray != null) {
                    byte[] byArray2 = new byte[byArray.length];
                    System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                    ((JROMBase64BinaryValue)jROMValue2).setValue(byArray2);
                }
            } else if (jROMType.equals(JROMType.JROM_DURATION_VALUE)) {
                jROMValue2 = this.newJROMDurationValue(jROMComplexValue);
                int[] nArray = ((JROMDurationValue)jROMValue).getValue();
                if (nArray != null) {
                    int[] nArray2 = new int[nArray.length];
                    System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
                    ((JROMDurationValue)jROMValue2).setValue(nArray2);
                }
            } else {
                throw new IllegalArgumentException("JROM type not supported");
            }
            jROMValue2.setNameNamespace(jROMValue.getNameNamespace());
            jROMValue2.setNameLocalPart(jROMValue.getNameLocalPart());
            return jROMValue2;
        }
        JROMComplexValue jROMComplexValue2 = (JROMComplexValue)jROMValue;
        JROMComplexValue jROMComplexValue3 = this.newJROMComplexValue(jROMComplexValue2.getTypeNamespace(), jROMComplexValue2.getTypeLocalPart(), jROMComplexValue);
        jROMComplexValue3.setNameNamespace(jROMValue.getNameNamespace());
        jROMComplexValue3.setNameLocalPart(jROMValue.getNameLocalPart());
        Iterator iterator = jROMComplexValue2.getElementValues();
        while (iterator.hasNext()) {
            jROMComplexValue3.addElementValue(this.copyJROMInstanceHelper((JROMValue)iterator.next(), jROMComplexValue3));
        }
        iterator = jROMComplexValue2.getAttributeValues();
        while (iterator.hasNext()) {
            jROMComplexValue3.addAttributeValue(this.copyJROMInstanceHelper((JROMValue)iterator.next(), jROMComplexValue3));
        }
        return jROMComplexValue3;
    }

    private static String findFactoryImplName() {
        String string = null;
        try {
            string = System.getProperty(PROPERTY_NAME);
            if (string != null) {
                return string;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        String string2 = JROMFactory.getFullPropertyFileName();
        if (string2 != null) {
            try {
                Properties properties = new Properties();
                File file = new File(string2);
                FileInputStream fileInputStream = new FileInputStream(file);
                properties.load(fileInputStream);
                fileInputStream.close();
                string = properties.getProperty(PROPERTY_NAME);
                if (string != null) {
                    return string;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return DEFAULT_FACTORY_IMPL_NAME;
    }

    private static String getFullPropertyFileName() {
        if (fullPropertyFileName == null) {
            try {
                String string = System.getProperty("java.home");
                fullPropertyFileName = string + File.separator + "lib" + File.separator + PROPERTY_FILE_NAME;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return fullPropertyFileName;
    }

    public abstract JROMComplexValue newJROMComplexValue(String var1, String var2);

    public abstract JROMComplexValue newJROMComplexValue(String var1, String var2, JROMComplexValue var3);

    public abstract JROMIntegerValue newJROMIntegerValue();

    public abstract JROMIntegerValue newJROMIntegerValue(JROMComplexValue var1);

    public abstract JROMStringValue newJROMStringValue();

    public abstract JROMStringValue newJROMStringValue(JROMComplexValue var1);

    public abstract JROMBooleanValue newJROMBooleanValue();

    public abstract JROMBooleanValue newJROMBooleanValue(JROMComplexValue var1);

    public abstract JROMDoubleValue newJROMDoubleValue();

    public abstract JROMDoubleValue newJROMDoubleValue(JROMComplexValue var1);

    public abstract JROMFloatValue newJROMFloatValue();

    public abstract JROMFloatValue newJROMFloatValue(JROMComplexValue var1);

    public abstract JROMLongValue newJROMLongValue();

    public abstract JROMLongValue newJROMLongValue(JROMComplexValue var1);

    public abstract JROMByteValue newJROMByteValue();

    public abstract JROMByteValue newJROMByteValue(JROMComplexValue var1);

    public abstract JROMShortValue newJROMShortValue();

    public abstract JROMShortValue newJROMShortValue(JROMComplexValue var1);

    public abstract JROMDecimalValue newJROMDecimalValue();

    public abstract JROMDecimalValue newJROMDecimalValue(JROMComplexValue var1);

    public abstract JROMDateValue newJROMDateValue();

    public abstract JROMDateValue newJROMDateValue(JROMComplexValue var1);

    public abstract JROMTimeValue newJROMTimeValue();

    public abstract JROMTimeValue newJROMTimeValue(JROMComplexValue var1);

    public abstract JROMQNameValue newJROMQNameValue();

    public abstract JROMQNameValue newJROMQNameValue(JROMComplexValue var1);

    public abstract JROMBase64BinaryValue newJROMBase64BinaryValue();

    public abstract JROMBase64BinaryValue newJROMBase64BinaryValue(JROMComplexValue var1);

    public abstract JROMDurationValue newJROMDurationValue();

    public abstract JROMDurationValue newJROMDurationValue(JROMComplexValue var1);
}

