/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jrom.util;

import com.ibm.jrom.JROMBase64BinaryValue;
import com.ibm.jrom.JROMBooleanValue;
import com.ibm.jrom.JROMByteValue;
import com.ibm.jrom.JROMComplexValue;
import com.ibm.jrom.JROMDateValue;
import com.ibm.jrom.JROMDecimalValue;
import com.ibm.jrom.JROMDoubleValue;
import com.ibm.jrom.JROMDurationValue;
import com.ibm.jrom.JROMException;
import com.ibm.jrom.JROMFloatValue;
import com.ibm.jrom.JROMIntegerValue;
import com.ibm.jrom.JROMLongValue;
import com.ibm.jrom.JROMQNameValue;
import com.ibm.jrom.JROMShortValue;
import com.ibm.jrom.JROMStringValue;
import com.ibm.jrom.JROMTimeValue;
import com.ibm.jrom.JROMType;
import com.ibm.jrom.JROMValue;
import com.ibm.jrom.factory.JROMFactory;
import com.ibm.jrom.util.Base64;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.namespace.QName;

public class ConvertorUtils {
    protected static DateFormat gCalDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    protected static DateFormat stdDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    protected static DateFormat dateFormatWMillis = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'SSS'Z'");
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$com$ibm$jrom$JROMIntegerValue;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$ibm$jrom$JROMStringValue;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$com$ibm$jrom$JROMBooleanValue;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$com$ibm$jrom$JROMDoubleValue;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$com$ibm$jrom$JROMFloatValue;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$com$ibm$jrom$JROMLongValue;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$com$ibm$jrom$JROMByteValue;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$com$ibm$jrom$JROMShortValue;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$com$ibm$jrom$JROMDecimalValue;
    static /* synthetic */ Class class$java$util$GregorianCalendar;
    static /* synthetic */ Class class$com$ibm$jrom$JROMDateValue;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$com$ibm$jrom$JROMTimeValue;
    static /* synthetic */ Class class$javax$xml$namespace$QName;
    static /* synthetic */ Class class$com$ibm$jrom$JROMQNameValue;
    static /* synthetic */ Class class$com$ibm$jrom$JROMBase64BinaryValue;

    public static JROMType getJROMType(Class clazz) {
        if (clazz.equals(class$java$lang$Integer == null ? (class$java$lang$Integer = ConvertorUtils.class$("java.lang.Integer")) : class$java$lang$Integer) || clazz.equals(Integer.TYPE) || (class$com$ibm$jrom$JROMIntegerValue == null ? (class$com$ibm$jrom$JROMIntegerValue = ConvertorUtils.class$("com.ibm.jrom.JROMIntegerValue")) : class$com$ibm$jrom$JROMIntegerValue).isAssignableFrom(clazz)) {
            return JROMType.JROM_INTEGER_VALUE;
        }
        if (clazz.equals(class$java$lang$String == null ? (class$java$lang$String = ConvertorUtils.class$("java.lang.String")) : class$java$lang$String) || (class$com$ibm$jrom$JROMStringValue == null ? (class$com$ibm$jrom$JROMStringValue = ConvertorUtils.class$("com.ibm.jrom.JROMStringValue")) : class$com$ibm$jrom$JROMStringValue).isAssignableFrom(clazz)) {
            return JROMType.JROM_STRING_VALUE;
        }
        if (clazz.equals(class$java$lang$Boolean == null ? (class$java$lang$Boolean = ConvertorUtils.class$("java.lang.Boolean")) : class$java$lang$Boolean) || clazz.equals(Boolean.TYPE) || (class$com$ibm$jrom$JROMBooleanValue == null ? (class$com$ibm$jrom$JROMBooleanValue = ConvertorUtils.class$("com.ibm.jrom.JROMBooleanValue")) : class$com$ibm$jrom$JROMBooleanValue).isAssignableFrom(clazz)) {
            return JROMType.JROM_BOOLEAN_VALUE;
        }
        if (clazz.equals(class$java$lang$Double == null ? (class$java$lang$Double = ConvertorUtils.class$("java.lang.Double")) : class$java$lang$Double) || clazz.equals(Double.TYPE) || (class$com$ibm$jrom$JROMDoubleValue == null ? (class$com$ibm$jrom$JROMDoubleValue = ConvertorUtils.class$("com.ibm.jrom.JROMDoubleValue")) : class$com$ibm$jrom$JROMDoubleValue).isAssignableFrom(clazz)) {
            return JROMType.JROM_DOUBLE_VALUE;
        }
        if (clazz.equals(class$java$lang$Float == null ? (class$java$lang$Float = ConvertorUtils.class$("java.lang.Float")) : class$java$lang$Float) || clazz.equals(Float.TYPE) || (class$com$ibm$jrom$JROMFloatValue == null ? (class$com$ibm$jrom$JROMFloatValue = ConvertorUtils.class$("com.ibm.jrom.JROMFloatValue")) : class$com$ibm$jrom$JROMFloatValue).isAssignableFrom(clazz)) {
            return JROMType.JROM_FLOAT_VALUE;
        }
        if (clazz.equals(class$java$lang$Long == null ? (class$java$lang$Long = ConvertorUtils.class$("java.lang.Long")) : class$java$lang$Long) || clazz.equals(Long.TYPE) || (class$com$ibm$jrom$JROMLongValue == null ? (class$com$ibm$jrom$JROMLongValue = ConvertorUtils.class$("com.ibm.jrom.JROMLongValue")) : class$com$ibm$jrom$JROMLongValue).isAssignableFrom(clazz)) {
            return JROMType.JROM_LONG_VALUE;
        }
        if (clazz.equals(class$java$lang$Byte == null ? (class$java$lang$Byte = ConvertorUtils.class$("java.lang.Byte")) : class$java$lang$Byte) || clazz.equals(Byte.TYPE) || (class$com$ibm$jrom$JROMByteValue == null ? (class$com$ibm$jrom$JROMByteValue = ConvertorUtils.class$("com.ibm.jrom.JROMByteValue")) : class$com$ibm$jrom$JROMByteValue).isAssignableFrom(clazz)) {
            return JROMType.JROM_BYTE_VALUE;
        }
        if (clazz.equals(class$java$lang$Short == null ? (class$java$lang$Short = ConvertorUtils.class$("java.lang.Short")) : class$java$lang$Short) || clazz.equals(Short.TYPE) || (class$com$ibm$jrom$JROMShortValue == null ? (class$com$ibm$jrom$JROMShortValue = ConvertorUtils.class$("com.ibm.jrom.JROMShortValue")) : class$com$ibm$jrom$JROMShortValue).isAssignableFrom(clazz)) {
            return JROMType.JROM_SHORT_VALUE;
        }
        if (clazz.equals(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = ConvertorUtils.class$("java.math.BigDecimal")) : class$java$math$BigDecimal) || (class$com$ibm$jrom$JROMDecimalValue == null ? (class$com$ibm$jrom$JROMDecimalValue = ConvertorUtils.class$("com.ibm.jrom.JROMDecimalValue")) : class$com$ibm$jrom$JROMDecimalValue).isAssignableFrom(clazz)) {
            return JROMType.JROM_DECIMAL_VALUE;
        }
        if (clazz.equals(class$java$util$GregorianCalendar == null ? (class$java$util$GregorianCalendar = ConvertorUtils.class$("java.util.GregorianCalendar")) : class$java$util$GregorianCalendar) || (class$com$ibm$jrom$JROMDateValue == null ? (class$com$ibm$jrom$JROMDateValue = ConvertorUtils.class$("com.ibm.jrom.JROMDateValue")) : class$com$ibm$jrom$JROMDateValue).isAssignableFrom(clazz)) {
            return JROMType.JROM_DATE_VALUE;
        }
        if (clazz.equals(class$java$util$Date == null ? (class$java$util$Date = ConvertorUtils.class$("java.util.Date")) : class$java$util$Date) || (class$com$ibm$jrom$JROMTimeValue == null ? (class$com$ibm$jrom$JROMTimeValue = ConvertorUtils.class$("com.ibm.jrom.JROMTimeValue")) : class$com$ibm$jrom$JROMTimeValue).isAssignableFrom(clazz)) {
            return JROMType.JROM_TIME_VALUE;
        }
        if (clazz.equals(class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = ConvertorUtils.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName) || (class$com$ibm$jrom$JROMQNameValue == null ? (class$com$ibm$jrom$JROMQNameValue = ConvertorUtils.class$("com.ibm.jrom.JROMQNameValue")) : class$com$ibm$jrom$JROMQNameValue).isAssignableFrom(clazz)) {
            return JROMType.JROM_QNAME_VALUE;
        }
        if (clazz.isArray() && clazz.getComponentType().equals(Byte.TYPE) || (class$com$ibm$jrom$JROMBase64BinaryValue == null ? (class$com$ibm$jrom$JROMBase64BinaryValue = ConvertorUtils.class$("com.ibm.jrom.JROMBase64BinaryValue")) : class$com$ibm$jrom$JROMBase64BinaryValue).isAssignableFrom(clazz)) {
            return JROMType.JROM_BASE64BINARY_VALUE;
        }
        return JROMType.JROM_COMPLEX_VALUE;
    }

    public static JROMValue createSimpleJrom(JROMFactory jROMFactory, JROMType jROMType, Object object, String string, String string2) {
        return ConvertorUtils.createSimpleJrom(jROMFactory, jROMType, object, string, string2, null);
    }

    public static JROMValue createSimpleJrom(JROMFactory jROMFactory, JROMType jROMType, Object object, String string, String string2, JROMComplexValue jROMComplexValue) throws IllegalArgumentException {
        boolean bl = object == null;
        Object var8_7 = null;
        try {
            JROMValue jROMValue;
            if (jROMType.equals(JROMType.JROM_INTEGER_VALUE)) {
                jROMValue = jROMFactory.newJROMIntegerValue(jROMComplexValue);
                if (!bl) {
                    jROMValue.setValue((Integer)object);
                }
            } else if (jROMType.equals(JROMType.JROM_STRING_VALUE)) {
                jROMValue = jROMFactory.newJROMStringValue(jROMComplexValue);
                if (!bl) {
                    ((JROMStringValue)jROMValue).setValue((String)object);
                }
            } else if (jROMType.equals(JROMType.JROM_BOOLEAN_VALUE)) {
                jROMValue = jROMFactory.newJROMBooleanValue(jROMComplexValue);
                if (!bl) {
                    ((JROMBooleanValue)jROMValue).setValue((Boolean)object);
                }
            } else if (jROMType.equals(JROMType.JROM_DOUBLE_VALUE)) {
                jROMValue = jROMFactory.newJROMDoubleValue(jROMComplexValue);
                if (!bl) {
                    ((JROMDoubleValue)jROMValue).setValue((Double)object);
                }
            } else if (jROMType.equals(JROMType.JROM_FLOAT_VALUE)) {
                jROMValue = jROMFactory.newJROMFloatValue(jROMComplexValue);
                if (!bl) {
                    ((JROMFloatValue)jROMValue).setValue(((Float)object).floatValue());
                }
            } else if (jROMType.equals(JROMType.JROM_LONG_VALUE)) {
                jROMValue = jROMFactory.newJROMLongValue(jROMComplexValue);
                if (!bl) {
                    ((JROMLongValue)jROMValue).setValue((Long)object);
                }
            } else if (jROMType.equals(JROMType.JROM_BYTE_VALUE)) {
                jROMValue = jROMFactory.newJROMByteValue(jROMComplexValue);
                if (!bl) {
                    ((JROMByteValue)jROMValue).setValue((Byte)object);
                }
            } else if (jROMType.equals(JROMType.JROM_SHORT_VALUE)) {
                jROMValue = jROMFactory.newJROMShortValue(jROMComplexValue);
                if (!bl) {
                    ((JROMShortValue)jROMValue).setValue((Short)object);
                }
            } else if (jROMType.equals(JROMType.JROM_DECIMAL_VALUE)) {
                jROMValue = jROMFactory.newJROMDecimalValue(jROMComplexValue);
                if (!bl) {
                    ((JROMDecimalValue)jROMValue).setValue((BigDecimal)object);
                }
            } else if (jROMType.equals(JROMType.JROM_DATE_VALUE)) {
                jROMValue = jROMFactory.newJROMDateValue(jROMComplexValue);
                if (!bl) {
                    ((JROMDateValue)jROMValue).setValue((GregorianCalendar)object);
                }
            } else if (jROMType.equals(JROMType.JROM_TIME_VALUE)) {
                jROMValue = jROMFactory.newJROMTimeValue(jROMComplexValue);
                if (!bl) {
                    ((JROMTimeValue)jROMValue).setValue((Date)object);
                }
            } else if (jROMType.equals(JROMType.JROM_QNAME_VALUE)) {
                jROMValue = jROMFactory.newJROMQNameValue(jROMComplexValue);
                if (!bl) {
                    ((JROMQNameValue)jROMValue).setValue((QName)object);
                }
            } else if (jROMType.equals(JROMType.JROM_DURATION_VALUE)) {
                jROMValue = jROMFactory.newJROMDurationValue(jROMComplexValue);
                if (!bl) {
                    ((JROMDurationValue)jROMValue).setValue((int[])object);
                }
            } else if (jROMType.equals(JROMType.JROM_BASE64BINARY_VALUE)) {
                jROMValue = jROMFactory.newJROMBase64BinaryValue(jROMComplexValue);
                if (!bl) {
                    ((JROMBase64BinaryValue)jROMValue).setValue((byte[])object);
                }
            } else {
                throw new IllegalArgumentException("JROM type not supported");
            }
            jROMValue.setNameNamespace(string);
            jROMValue.setNameLocalPart(string2);
            return jROMValue;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Cannot create JROM of type " + jROMType + " whose value is " + object);
        }
    }

    public static Object getSimpleJROMObject(JROMValue jROMValue) throws IllegalArgumentException {
        Object object;
        try {
            Method method2 = jROMValue.getClass().getDeclaredMethod("getValue", new Class[0]);
            object = method2.invoke((Object)jROMValue, new Object[0]);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Unable to retrieve value from jrom " + exception.getMessage() + '.');
        }
        return object;
    }

    public static int[] stringToDuration(String string) {
        int n;
        int[] nArray = new int[7];
        Arrays.fill(nArray, 0);
        boolean bl = false;
        if (string.charAt(0) == '-') {
            bl = true;
        }
        int n2 = bl ? 2 : 1;
        int n3 = string.indexOf(84);
        int n4 = string.indexOf(89);
        if (n4 > 0) {
            nArray[0] = Integer.parseInt(string.substring(n2, n4));
        } else {
            n4 = 0;
        }
        int n5 = string.indexOf(77);
        if (n5 > 0 && n5 < n3) {
            nArray[1] = Integer.parseInt(string.substring(n4 + 1, n5));
        } else {
            n5 = n4;
        }
        int n6 = string.indexOf(68);
        if (n6 > 0) {
            nArray[2] = Integer.parseInt(string.substring(n5 + 1, n6));
        } else {
            n6 = n5;
        }
        if (n3 > 0) {
            n = string.indexOf(72);
            if (n > 0) {
                nArray[3] = Integer.parseInt(string.substring(n3 + 1, n));
            } else {
                n = n3;
            }
            int n7 = string.indexOf(77, n3);
            if (n7 > 0) {
                nArray[4] = Integer.parseInt(string.substring(n + 1, n7));
            } else {
                n7 = n;
            }
            int n8 = string.indexOf(83);
            if (n8 > 0) {
                double d = Double.parseDouble(string.substring(n7 + 1, n8));
                nArray[5] = (int)Math.floor(d);
                nArray[6] = (int)(1000.0 * (d - (double)nArray[5]));
            }
        }
        if (bl) {
            n = 0;
            while (n < nArray.length) {
                nArray[n] = -nArray[n];
                ++n;
            }
        }
        return nArray;
    }

    public static String durationToString(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[]{'Y', 'M', 'D', 'H', 'M', 'S'};
        boolean bl = false;
        boolean bl2 = false;
        stringBuffer.append('P');
        int n = 0;
        while (n < cArray.length) {
            if (nArray[n] != 0) {
                if (!bl2 && nArray[n] < 0) {
                    bl2 = true;
                    stringBuffer.insert(0, '-');
                }
                if (n > 2 && !bl) {
                    bl = true;
                    stringBuffer.append('T');
                }
                if (n > 4) {
                    double d = (double)nArray[n] + (double)nArray[n + 1] / 1000.0;
                    if (d > 0.0) {
                        stringBuffer.append(Math.abs(d));
                    }
                } else {
                    stringBuffer.append(Math.abs(nArray[n]));
                }
                stringBuffer.append(cArray[n]);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JROMValue createSimpleJROMFromString(JROMFactory jROMFactory, JROMType jROMType, String string, String string2, String string3, JROMComplexValue jROMComplexValue) throws JROMException {
        Object object = null;
        if (string != null && !string.equals("")) {
            if (jROMType.equals(JROMType.JROM_STRING_VALUE)) {
                object = string;
                return ConvertorUtils.createSimpleJrom(jROMFactory, jROMType, object, string2, string3, jROMComplexValue);
            } else if (jROMType.equals(JROMType.JROM_BYTE_VALUE)) {
                object = new Byte(string);
                return ConvertorUtils.createSimpleJrom(jROMFactory, jROMType, object, string2, string3, jROMComplexValue);
            } else if (jROMType.equals(JROMType.JROM_BOOLEAN_VALUE)) {
                object = new Boolean(string);
                return ConvertorUtils.createSimpleJrom(jROMFactory, jROMType, object, string2, string3, jROMComplexValue);
            } else if (jROMType.equals(JROMType.JROM_DOUBLE_VALUE)) {
                object = new Double(string);
                return ConvertorUtils.createSimpleJrom(jROMFactory, jROMType, object, string2, string3, jROMComplexValue);
            } else if (jROMType.equals(JROMType.JROM_FLOAT_VALUE)) {
                object = new Float(string);
                return ConvertorUtils.createSimpleJrom(jROMFactory, jROMType, object, string2, string3, jROMComplexValue);
            } else if (jROMType.equals(JROMType.JROM_INTEGER_VALUE)) {
                object = new Integer(string);
                return ConvertorUtils.createSimpleJrom(jROMFactory, jROMType, object, string2, string3, jROMComplexValue);
            } else if (jROMType.equals(JROMType.JROM_LONG_VALUE)) {
                object = new Long(string);
                return ConvertorUtils.createSimpleJrom(jROMFactory, jROMType, object, string2, string3, jROMComplexValue);
            } else if (jROMType.equals(JROMType.JROM_SHORT_VALUE)) {
                object = new Short(string);
                return ConvertorUtils.createSimpleJrom(jROMFactory, jROMType, object, string2, string3, jROMComplexValue);
            } else if (jROMType.equals(JROMType.JROM_DECIMAL_VALUE)) {
                object = new BigDecimal(string);
                return ConvertorUtils.createSimpleJrom(jROMFactory, jROMType, object, string2, string3, jROMComplexValue);
            } else if (jROMType.equals(JROMType.JROM_DATE_VALUE)) {
                object = new GregorianCalendar();
                try {
                    ((GregorianCalendar)object).setTime(gCalDateFormat.parse(string));
                    return ConvertorUtils.createSimpleJrom(jROMFactory, jROMType, object, string2, string3, jROMComplexValue);
                }
                catch (ParseException parseException) {
                    throw new JROMException("ConvertorUtils:createSimpleJROMFromElement:Cannot create Calendar from given string: " + string);
                }
            } else if (jROMType.equals(JROMType.JROM_TIME_VALUE)) {
                try {
                    object = stdDateFormat.parse(string);
                    return ConvertorUtils.createSimpleJrom(jROMFactory, jROMType, object, string2, string3, jROMComplexValue);
                }
                catch (Exception exception) {
                    try {
                        object = dateFormatWMillis.parse(string);
                        return ConvertorUtils.createSimpleJrom(jROMFactory, jROMType, object, string2, string3, jROMComplexValue);
                    }
                    catch (Exception exception2) {
                        try {
                            object = gCalDateFormat.parse(string);
                            return ConvertorUtils.createSimpleJrom(jROMFactory, jROMType, object, string2, string3, jROMComplexValue);
                        }
                        catch (Exception exception3) {
                            throw new JROMException("ConvertorUtils:createSimpleJROMFromElement:Cannot create date from given String" + string);
                        }
                    }
                }
            } else if (jROMType.equals(JROMType.JROM_BASE64BINARY_VALUE)) {
                object = Base64.decode(string);
                return ConvertorUtils.createSimpleJrom(jROMFactory, jROMType, object, string2, string3, jROMComplexValue);
            } else {
                if (!jROMType.equals(JROMType.JROM_DURATION_VALUE)) throw new JROMException("Simple Type " + jROMType + "not supported in XML->JROM conversion. QName support coming soon");
                object = ConvertorUtils.stringToDuration(string);
            }
            return ConvertorUtils.createSimpleJrom(jROMFactory, jROMType, object, string2, string3, jROMComplexValue);
        } else {
            string = null;
        }
        return ConvertorUtils.createSimpleJrom(jROMFactory, jROMType, object, string2, string3, jROMComplexValue);
    }

    public static String getStringFromSJROM(JROMValue jROMValue) throws JROMException {
        if (jROMValue.getJROMType().equals(JROMType.JROM_COMPLEX_VALUE)) {
            throw new IllegalArgumentException("ConvetorUtils:getStringValueFromSJROM: Only Simple JROM values can have their values made into a String");
        }
        JROMType jROMType = jROMValue.getJROMType();
        String string = null;
        if (jROMType.equals(JROMType.JROM_STRING_VALUE)) {
            string = ((JROMStringValue)jROMValue).getValue();
        } else if (jROMType.equals(JROMType.JROM_BYTE_VALUE)) {
            string = String.valueOf(((JROMByteValue)jROMValue).getValue());
        } else if (jROMType.equals(JROMType.JROM_BOOLEAN_VALUE)) {
            string = String.valueOf(((JROMBooleanValue)jROMValue).getValue());
        } else if (jROMType.equals(JROMType.JROM_DOUBLE_VALUE)) {
            string = String.valueOf(((JROMDoubleValue)jROMValue).getValue());
        } else if (jROMType.equals(JROMType.JROM_FLOAT_VALUE)) {
            string = String.valueOf(((JROMFloatValue)jROMValue).getValue());
        } else if (jROMType.equals(JROMType.JROM_INTEGER_VALUE)) {
            string = String.valueOf(((JROMIntegerValue)jROMValue).getValue());
        } else if (jROMType.equals(JROMType.JROM_LONG_VALUE)) {
            string = String.valueOf(((JROMLongValue)jROMValue).getValue());
        } else if (jROMType.equals(JROMType.JROM_SHORT_VALUE)) {
            string = String.valueOf(((JROMShortValue)jROMValue).getValue());
        } else if (jROMType.equals(JROMType.JROM_DECIMAL_VALUE)) {
            BigDecimal bigDecimal = ((JROMDecimalValue)jROMValue).getValue();
            if (bigDecimal != null) {
                string = bigDecimal.toString();
            }
        } else if (jROMType.equals(JROMType.JROM_DATE_VALUE)) {
            GregorianCalendar gregorianCalendar = ((JROMDateValue)jROMValue).getValue();
            string = gCalDateFormat.format(gregorianCalendar.getTime());
        } else if (jROMType.equals(JROMType.JROM_TIME_VALUE)) {
            Date date = ((JROMTimeValue)jROMValue).getValue();
            if (date != null) {
                try {
                    string = stdDateFormat.format(date);
                }
                catch (Exception exception) {
                    try {
                        string = dateFormatWMillis.format(date);
                    }
                    catch (Exception exception2) {
                        throw new JROMException("ConvertorUtils:createSimpleJROMFromElement:Cannot create String from given JROMTimeValue");
                    }
                }
            }
        } else if (jROMType.equals(JROMType.JROM_BASE64BINARY_VALUE)) {
            String string2 = Base64.encode(((JROMBase64BinaryValue)jROMValue).getValue());
            string = new String(string2);
        } else if (jROMType.equals(JROMType.JROM_DURATION_VALUE)) {
            string = ConvertorUtils.durationToString(((JROMDurationValue)jROMValue).getValue());
        } else {
            throw new JROMException("Simple Type " + jROMType + "not supported in JROM->String conversion.");
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

