/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jrom.util;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;

public class JROMUtils {
    public static final String lineSeparator = System.getProperty("line.separator", "\n");

    public static PropertyDescriptor[] getPropertyDescriptors(Class clazz) throws IllegalArgumentException {
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        if (beanInfo != null) {
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            if (propertyDescriptorArray != null) {
                return propertyDescriptorArray;
            }
            throw new IllegalArgumentException("Unable to retrieve property descriptors for '" + clazz.getName() + "'.");
        }
        throw new IllegalArgumentException("Unable to retrieve BeanInfo for '" + clazz.getName() + "'.");
    }

    public static Object getPropValue(PropertyDescriptor propertyDescriptor, Object object) {
        Method method2 = propertyDescriptor.getReadMethod();
        Object object2 = null;
        if (method2 != null) {
            try {
                if (object != null) {
                    object2 = method2.invoke(object, new Object[0]);
                }
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Unable to retrieve '" + propertyDescriptor.getName() + " from an object of type " + object.getClass().getName() + "' property " + "value: " + exception.getMessage() + '.');
            }
        }
        return object2;
    }

    public static Method getWriteMethod(String string, PropertyDescriptor[] propertyDescriptorArray, Class clazz) {
        int n = 0;
        while (n < propertyDescriptorArray.length) {
            if (string.equals(propertyDescriptorArray[n].getName())) {
                return propertyDescriptorArray[n].getWriteMethod();
            }
            ++n;
        }
        throw new IllegalArgumentException("Unable to retrieve PropertyDescriptor for property '" + string + "' of class '" + clazz + "'.");
    }

    public static void setProperty(String string, PropertyDescriptor[] propertyDescriptorArray, Object object, Object object2) {
        Method method2 = JROMUtils.getWriteMethod(string, propertyDescriptorArray, object2.getClass());
        if (method2 != null) {
            try {
                method2.invoke(object2, object);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Unable to set '" + string + "' property: " + exception.getMessage() + '.');
            }
        }
    }

    public static String[] splitStringOnColon(String string) {
        String[] stringArray = new String[2];
        int n = string.indexOf(58);
        if (n > -1) {
            stringArray[0] = string.substring(0, n);
            stringArray[1] = string.substring(n + 1);
        } else {
            stringArray[0] = null;
            stringArray[1] = string;
        }
        return stringArray;
    }

    public static Object instantiateBean(Class clazz) throws IllegalArgumentException {
        try {
            return clazz.newInstance();
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException("Unable to instantiate '" + clazz.getName() + "': " + throwable.getMessage());
        }
    }

    public static String xmlizeString(String string) {
        if (string == null || string.equals("")) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            switch (cArray[n]) {
                case '<': {
                    stringBuffer.append("&lt;");
                    break;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    break;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    break;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    break;
                }
                case '\'': {
                    stringBuffer.append("&apos;");
                    break;
                }
                default: {
                    stringBuffer.append(cArray[n]);
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }
}

