/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jrom.util.xml;

import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DOMUtils {
    private static String NS_URI_XMLNS = "http://www.w3.org/2000/xmlns/";

    public static String getAttribute(Element element, String string) {
        String string2 = null;
        Attr attr = element.getAttributeNode(string);
        if (attr != null) {
            string2 = attr.getValue();
        }
        return string2;
    }

    public static String getAttributeNS(Element element, String string, String string2) {
        String string3 = null;
        Attr attr = element.getAttributeNodeNS(string, string2);
        if (attr != null) {
            string3 = attr.getValue();
        }
        return string3;
    }

    public static String getChildCharacterData(Element element) {
        if (element == null) {
            return null;
        }
        Node node = element.getFirstChild();
        StringBuffer stringBuffer = new StringBuffer();
        while (node != null) {
            switch (node.getNodeType()) {
                case 3: 
                case 4: {
                    CharacterData characterData = (CharacterData)node;
                    stringBuffer.append(characterData.getData());
                }
            }
            node = node.getNextSibling();
        }
        return stringBuffer.toString();
    }

    public static Element getFirstChildElement(Element element) {
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1) {
                return (Element)node;
            }
            node = node.getNextSibling();
        }
        return null;
    }

    public static Element getNextSiblingElement(Element element) {
        Node node = element.getNextSibling();
        while (node != null) {
            if (node.getNodeType() == 1) {
                return (Element)node;
            }
            node = node.getNextSibling();
        }
        return null;
    }

    public static Element findChildElementWithAttribute(Element element, String string, String string2) {
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1 && string2.equals(DOMUtils.getAttribute((Element)node, string))) {
                return (Element)node;
            }
            node = node.getNextSibling();
        }
        return null;
    }

    public static int countKids(Element element, short s) {
        int n = 0;
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == s) {
                ++n;
            }
            node = node.getNextSibling();
        }
        return n;
    }

    public static String getNamespaceURIFromPrefix(Node node, String string) {
        short s = node.getNodeType();
        Node node2 = null;
        switch (s) {
            case 2: {
                node2 = ((Attr)node).getOwnerElement();
                break;
            }
            case 1: {
                node2 = node;
                break;
            }
            default: {
                node2 = node.getParentNode();
                break;
            }
        }
        while (node2 != null && node2.getNodeType() == 1) {
            String string2;
            Element element = (Element)node2;
            String string3 = string2 = string == null ? DOMUtils.getAttribute(element, "xmlns") : DOMUtils.getAttributeNS(element, NS_URI_XMLNS, string);
            if (string2 != null) {
                return string2;
            }
            node2 = element.getParentNode();
        }
        return null;
    }
}

