/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.pcf;

import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;

public class CCSID {
    public static final String SCCSID = "@(#) eclipse/com.ibm.mq.pcf/src/com/ibm/mq/pcf/CCSID.java, javagui, p000, p000-L050408  1.4 05/04/07 11:14:39";
    static final Hashtable ht = new Hashtable();

    public static void addCodepage(int ccsid, String codepage) {
        ht.put(new Integer(ccsid), codepage);
    }

    public static String getCodepage(int ccsid) throws UnsupportedEncodingException {
        String codepage = (String)ht.get(new Integer(ccsid));
        if (codepage != null) {
            return codepage;
        }
        throw new UnsupportedEncodingException(ccsid + ": Unknown CCSID");
    }

    public static String convert(byte[] bytes, int ccsid) throws UnsupportedEncodingException {
        return new String(bytes, CCSID.getCodepage(ccsid));
    }

    public static String convert(byte[] bytes, int offset, int length, int ccsid) throws UnsupportedEncodingException {
        return new String(bytes, offset, length, CCSID.getCodepage(ccsid));
    }

    public static byte[] convert(String string, int ccsid) throws UnsupportedEncodingException {
        return string.getBytes(CCSID.getCodepage(ccsid));
    }

    public Enumeration getCCSIDs() {
        return ht.elements();
    }

    public static String getCharSet(int ccsid, int encoding) throws UnsupportedEncodingException {
        String charSet = null;
        charSet = ccsid == 1200 ? ((encoding & 0xF) == 2 ? "UnicodeLittle" : "UnicodeBig") : (String)ht.get(new Integer(ccsid));
        if (charSet != null) {
            return charSet;
        }
        throw new UnsupportedEncodingException(ccsid + ": Unknown CCSID");
    }

    static {
        CCSID.addCodepage(0, System.getProperty("file.encoding"));
        CCSID.addCodepage(37, "IBM-037");
        CCSID.addCodepage(273, "IBM-273");
        CCSID.addCodepage(277, "IBM-277");
        CCSID.addCodepage(278, "IBM-278");
        CCSID.addCodepage(280, "IBM-280");
        CCSID.addCodepage(284, "IBM-284");
        CCSID.addCodepage(285, "IBM-285");
        CCSID.addCodepage(297, "IBM-297");
        CCSID.addCodepage(420, "IBM-420");
        CCSID.addCodepage(424, "IBM-424");
        CCSID.addCodepage(437, "IBM-437");
        CCSID.addCodepage(500, "IBM-500");
        CCSID.addCodepage(737, "IBM-737");
        CCSID.addCodepage(775, "IBM-775");
        CCSID.addCodepage(813, "ISO8859-7");
        CCSID.addCodepage(819, "ISO8859_1");
        CCSID.addCodepage(838, "IBM-838");
        CCSID.addCodepage(850, "IBM-850");
        CCSID.addCodepage(852, "IBM-852");
        CCSID.addCodepage(855, "IBM-855");
        CCSID.addCodepage(856, "IBM-856");
        CCSID.addCodepage(857, "IBM-857");
        CCSID.addCodepage(860, "IBM-860");
        CCSID.addCodepage(861, "IBM-861");
        CCSID.addCodepage(862, "IBM-862");
        CCSID.addCodepage(863, "IBM-863");
        CCSID.addCodepage(864, "IBM-864");
        CCSID.addCodepage(865, "IBM-865");
        CCSID.addCodepage(866, "IBM-866");
        CCSID.addCodepage(868, "IBM-868");
        CCSID.addCodepage(869, "IBM-869");
        CCSID.addCodepage(870, "IBM-870");
        CCSID.addCodepage(871, "IBM-871");
        CCSID.addCodepage(874, "IBM-874");
        CCSID.addCodepage(875, "IBM-875");
        CCSID.addCodepage(878, "KOI8-R");
        CCSID.addCodepage(912, "ISO8859-2");
        CCSID.addCodepage(913, "ISO8859-3");
        CCSID.addCodepage(914, "ISO8859-4");
        CCSID.addCodepage(915, "ISO8859-5");
        CCSID.addCodepage(916, "ISO8859-8");
        CCSID.addCodepage(918, "IBM-918");
        CCSID.addCodepage(920, "ISO8859-9");
        CCSID.addCodepage(921, "IBM-921");
        CCSID.addCodepage(922, "IBM-922");
        CCSID.addCodepage(923, "ISO8859-15");
        CCSID.addCodepage(930, "IBM-930");
        CCSID.addCodepage(932, "IBM-932");
        CCSID.addCodepage(933, "IBM-933");
        CCSID.addCodepage(935, "IBM-935");
        CCSID.addCodepage(937, "IBM-937");
        CCSID.addCodepage(939, "IBM-939");
        CCSID.addCodepage(942, "IBM-942");
        CCSID.addCodepage(943, "PCK");
        CCSID.addCodepage(948, "IBM-948");
        CCSID.addCodepage(949, "IBM-949");
        CCSID.addCodepage(950, "IBM-950");
        CCSID.addCodepage(954, "EUCJIS");
        CCSID.addCodepage(964, "IBM-964");
        CCSID.addCodepage(970, "IBM-970");
        CCSID.addCodepage(1006, "IBM-1006");
        CCSID.addCodepage(1025, "IBM-1025");
        CCSID.addCodepage(1026, "IBM-1026");
        CCSID.addCodepage(1089, "ISO8859-6");
        CCSID.addCodepage(1097, "IBM-1097");
        CCSID.addCodepage(1098, "IBM-1098");
        CCSID.addCodepage(1112, "IBM-1112");
        CCSID.addCodepage(1122, "IBM-1122");
        CCSID.addCodepage(1123, "IBM-1123");
        CCSID.addCodepage(1124, "IBM-1124");
        CCSID.addCodepage(1208, "UTF-8");
        CCSID.addCodepage(1250, "WINDOWS-1250");
        CCSID.addCodepage(1251, "WINDOWS-1251");
        CCSID.addCodepage(1252, "WINDOWS-1252");
        CCSID.addCodepage(1253, "WINDOWS-1253");
        CCSID.addCodepage(1254, "WINDOWS-1254");
        CCSID.addCodepage(1255, "WINDOWS-1255");
        CCSID.addCodepage(1256, "WINDOWS-1256");
        CCSID.addCodepage(1257, "WINDOWS-1257");
        CCSID.addCodepage(1258, "WINDOWS-1258");
        CCSID.addCodepage(1381, "IBM-1381");
        CCSID.addCodepage(1383, "IBM-1383");
        CCSID.addCodepage(1386, "GBK");
        CCSID.addCodepage(2022, "JIS");
        CCSID.addCodepage(5488, "GB18030");
        CCSID.addCodepage(5601, "KSC5601");
    }
}

