/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.pcf;

import com.ibm.mq.MQException;
import com.ibm.mq.MQMessage;
import com.ibm.mq.pcf.MQCFBS;
import com.ibm.mq.pcf.PCFFilterParameter;
import java.io.IOException;
import java.util.Arrays;

public class MQCFBF
extends PCFFilterParameter {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) eclipse/com.ibm.mq.pcf/src/com/ibm/mq/pcf/MQCFBF.java, javagui, p000, p000-L050421  1.3 05/04/20 17:21:07";
    static final String[] pads = new String[]{"", " ", "  ", "   ", ""};
    public static final int type = 15;
    public int strucLength = 20;
    public int parameter;
    public int operator;
    public int filterValueLength;
    public byte[] filterValue;

    public static int write(MQMessage message, int parameter2, int operator, byte[] filterValue) throws IOException {
        int bytesLength = filterValue == null ? 0 : filterValue.length;
        int padLength = bytesLength % 4;
        if (padLength != 0) {
            padLength = 4 - padLength;
        }
        int totalLength = 20 + bytesLength + padLength;
        message.writeString("");
        message.writeInt(15);
        message.writeInt(totalLength);
        message.writeInt(parameter2);
        message.writeInt(operator);
        message.writeInt(bytesLength);
        if (filterValue != null) {
            message.write(filterValue);
        }
        if (padLength != 0) {
            message.writeString(pads[padLength]);
        }
        return totalLength;
    }

    public MQCFBF() {
        this.setFilterValue(new byte[0]);
    }

    public MQCFBF(int parameter2, int operator, byte[] filterValue) {
        this.parameter = parameter2;
        this.operator = operator;
        this.setFilterValue(filterValue);
    }

    public MQCFBF(MQMessage message) throws MQException, IOException {
        this.initialize(message);
    }

    public void initialize(MQMessage message) throws MQException, IOException {
        int type = message.readInt();
        if (type != 15) {
            throw new MQException(2, 3013, (Object)message);
        }
        this.strucLength = message.readInt();
        this.parameter = message.readInt();
        this.operator = message.readInt();
        this.filterValueLength = message.readInt();
        if (this.filterValueLength < 0) {
            throw new MQException(2, 3267, (Object)message);
        }
        if (this.strucLength < 20 + this.filterValueLength) {
            throw new MQException(2, 3264, (Object)message);
        }
        this.filterValue = new byte[this.filterValueLength];
        message.readFully(this.filterValue);
        int padLength = this.strucLength - 20 - this.filterValueLength;
        while (padLength-- > 0) {
            message.readByte();
        }
    }

    public int write(MQMessage message) throws IOException {
        int bytesLength = this.filterValue == null ? 0 : this.filterValue.length;
        int padLength = bytesLength % 4;
        if (padLength != 0) {
            padLength = 4 - padLength;
        }
        message.writeString("");
        message.writeInt(15);
        message.writeInt(this.strucLength);
        message.writeInt(this.parameter);
        message.writeInt(this.operator);
        message.writeInt(bytesLength);
        if (this.filterValue != null) {
            message.write(this.filterValue);
        }
        if (padLength != 0) {
            message.writeString(pads[padLength]);
        }
        return 20 + bytesLength + padLength;
    }

    public int size() {
        int bytesLength = this.filterValue == null ? 0 : this.filterValue.length;
        int padLength = bytesLength % 4;
        if (padLength != 0) {
            padLength = 4 - padLength;
        }
        return 20 + bytesLength + padLength;
    }

    public int getType() {
        return 15;
    }

    public int getParameter() {
        return this.parameter;
    }

    public Object getValue() {
        return this.filterValue;
    }

    public String getStringValue() {
        if (this.filterValue == null) {
            return "";
        }
        return MQCFBS.asHexString(this.filterValue);
    }

    public void setValue(Object value2) throws ClassCastException {
        this.setFilterValue((byte[])value2);
    }

    public int getOperator() {
        return this.operator;
    }

    public void setFilterValue(byte[] value2) {
        int bytesLength = value2 == null ? 0 : value2.length;
        int padLength = bytesLength % 4;
        if (padLength != 0) {
            padLength = 4 - padLength;
        }
        this.strucLength = 20 + bytesLength + padLength;
        this.filterValueLength = bytesLength;
        this.filterValue = value2;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof MQCFBF) {
            MQCFBF other = (MQCFBF)obj;
            return other.parameter == this.parameter && other.operator == this.operator && Arrays.equals(other.filterValue, this.filterValue);
        }
        return false;
    }

    public String toString() {
        return new String(this.getClass().getName() + ": type: " + 15 + ", strucLength: " + this.strucLength + ", parameter: " + this.parameter + " = " + this.getSymbol(this.parameter) + ", operator: " + this.operator + ", filterValueLength: " + this.filterValueLength + ", filterValue: " + (this.filterValue != null ? "0x" + MQCFBS.asHexString(this.filterValue) : "null"));
    }
}

