/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.pcf;

import com.ibm.mq.MQException;
import com.ibm.mq.MQMessage;
import com.ibm.mq.pcf.PCFParameter;
import java.io.IOException;
import java.util.Arrays;

public class MQCFBS
extends PCFParameter {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) eclipse/com.ibm.mq.pcf/src/com/ibm/mq/pcf/MQCFBS.java, javagui, p000, p000-L050421  1.12 05/04/20 17:23:41";
    static final String[] pads = new String[]{"", " ", "  ", "   ", ""};
    public static final int type = 9;
    public int strucLength = 16;
    public int parameter;
    public int stringLength;
    public byte[] string;

    public static final String asHexString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            sb.append(Character.forDigit(b >> 4 & 0xF, 16));
            sb.append(Character.forDigit(b & 0xF, 16));
        }
        return new String(sb);
    }

    public static int write(MQMessage message, int parameter2, byte[] string) throws IOException {
        int stringLength = string == null ? 0 : string.length;
        int padLength = stringLength % 4;
        if (padLength != 0) {
            padLength = 4 - padLength;
        }
        int totalLength = 16 + stringLength + padLength;
        message.writeString("");
        message.writeInt(9);
        message.writeInt(totalLength);
        message.writeInt(parameter2);
        message.writeInt(stringLength);
        message.write(string);
        if (padLength != 0) {
            message.writeString(pads[padLength]);
        }
        return totalLength;
    }

    public MQCFBS() {
        this.setString((byte[])null);
    }

    public MQCFBS(int parameter2, String string) {
        this.parameter = parameter2;
        this.setString(string);
    }

    public MQCFBS(int parameter2, byte[] bytes) {
        this.parameter = parameter2;
        this.setString(bytes);
    }

    public MQCFBS(MQMessage message) throws MQException, IOException {
        this.initialize(message);
    }

    public void initialize(MQMessage message) throws MQException, IOException {
        if (message.readInt() != 9) {
            throw new MQException(2, 3013, (Object)message);
        }
        this.strucLength = message.readInt();
        this.parameter = message.readInt();
        this.stringLength = message.readInt();
        if (this.stringLength < 0) {
            throw new MQException(2, 3011, (Object)message);
        }
        if (this.strucLength < 16 + this.stringLength) {
            throw new MQException(2, 3257, (Object)message);
        }
        this.string = new byte[this.stringLength];
        message.readFully(this.string);
        int padLength = this.strucLength - 16 - this.stringLength;
        while (padLength-- > 0) {
            message.readByte();
        }
    }

    public int write(MQMessage message) throws IOException {
        int stringLength = this.string == null ? 0 : this.string.length;
        int padLength = stringLength % 4;
        if (padLength != 0) {
            padLength = 4 - padLength;
        }
        message.writeString("");
        message.writeInt(9);
        message.writeInt(this.strucLength);
        message.writeInt(this.parameter);
        message.writeInt(this.stringLength);
        message.write(this.string);
        if (padLength != 0) {
            message.writeString(pads[padLength]);
        }
        return 16 + stringLength + padLength;
    }

    public int size() {
        int stringLength = this.string == null ? 0 : this.string.length;
        int padLength = stringLength % 4;
        if (padLength != 0) {
            padLength = 4 - padLength;
        }
        return 16 + stringLength + padLength;
    }

    public int getType() {
        return 9;
    }

    public int getParameter() {
        return this.parameter;
    }

    public Object getValue() {
        return this.string;
    }

    public byte[] getBytesValue() {
        if (this.string == null) {
            return new byte[0];
        }
        return this.string;
    }

    public String getStringValue() {
        if (this.string == null) {
            return "";
        }
        return MQCFBS.asHexString(this.string);
    }

    public void setValue(Object value2) throws ClassCastException {
        this.setString((byte[])value2);
    }

    public void setString(String string) {
        this.setString(string == null ? (byte[])null : string.getBytes());
    }

    public void setString(byte[] bytes) {
        int stringLength = bytes == null ? 0 : bytes.length;
        int padLength = stringLength % 4;
        if (padLength != 0) {
            padLength = 4 - padLength;
        }
        this.strucLength = 16 + stringLength + padLength;
        this.stringLength = stringLength;
        this.string = bytes;
    }

    public int getHeaderVersion() {
        return 2;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof MQCFBS) {
            MQCFBS other = (MQCFBS)obj;
            byte[] otherValue = other.string;
            byte[] value2 = this.string;
            return other.parameter == this.parameter && otherValue != null && value2 != null && Arrays.equals(value2, otherValue);
        }
        return false;
    }

    public String toString() {
        return this.getUnqualifiedClassName() + ": type: " + 9 + ", strucLength: " + this.strucLength + ", parameter: " + this.getParameterName(this.parameter) + ", stringLength: " + this.stringLength + ", string: " + MQCFBS.asHexString(this.string);
    }
}

