/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.pcf;

import com.ibm.mq.MQException;
import com.ibm.mq.MQMessage;
import com.ibm.mq.pcf.PCFParameter;
import java.io.IOException;

public class MQCFGR
extends PCFParameter {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) eclipse/com.ibm.mq.pcf/src/com/ibm/mq/pcf/MQCFGR.java, javagui, p000, p000-L041222  1.5 04/12/21 12:12:17";
    static final int MQCFT_GROUP = 20;
    static final int MQCFGR_STRUC_LENGTH = 16;
    static final int MQRCCF_CFGR_LENGTH_ERROR = 6123;
    public static final int type = 20;
    public static final int strucLength = 16;
    public int parameter;
    public int parameterCount;

    public static int write(MQMessage message, int parameter2, int parameterCount) throws IOException {
        message.writeInt(20);
        message.writeInt(16);
        message.writeInt(parameter2);
        message.writeInt(parameterCount);
        return 16;
    }

    public MQCFGR() {
    }

    public MQCFGR(int parameter2, int parameterCount) {
        this.parameter = parameter2;
        this.parameterCount = parameterCount;
    }

    public MQCFGR(MQMessage message) throws MQException, IOException {
        this.initialize(message);
    }

    public void initialize(MQMessage message) throws MQException, IOException {
        if (message.readInt() != 20) {
            throw new MQException(2, 3013, (Object)message);
        }
        if (message.readInt() != 16) {
            throw new MQException(2, 6123, (Object)message);
        }
        this.parameter = message.readInt();
        this.parameterCount = message.readInt();
    }

    public int write(MQMessage message) throws IOException {
        message.writeInt(20);
        message.writeInt(16);
        message.writeInt(this.parameter);
        message.writeInt(this.parameterCount);
        return 16;
    }

    public int size() {
        return 16;
    }

    public int getType() {
        return 20;
    }

    public int getParameter() {
        return this.parameter;
    }

    public Object getValue() {
        return new Integer(this.parameterCount);
    }

    public String getStringValue() {
        return Integer.toString(this.parameterCount);
    }

    public void setValue(Object value2) throws ClassCastException {
        this.setParameterCount(value2 == null ? 0 : (Integer)value2);
    }

    public void setParameterCount(int parameterCount) {
        if (parameterCount >= 0) {
            this.parameterCount = parameterCount;
        }
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof MQCFGR) {
            MQCFGR other = (MQCFGR)obj;
            return other.parameter == this.parameter && other.parameterCount == this.parameterCount;
        }
        return false;
    }

    public String toString() {
        return this.getUnqualifiedClassName() + ": type: " + 20 + ", strucLength: " + 16 + ", parameter: " + this.getParameterName(this.parameter) + ", parameterCount: " + this.parameterCount;
    }
}

