/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.pcf;

import com.ibm.mq.MQException;
import com.ibm.mq.MQMessage;
import com.ibm.mq.pcf.CMQCFC;
import com.ibm.mq.pcf.PCFHeader;
import java.io.IOException;

public class MQCFH
extends PCFHeader
implements CMQCFC {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) eclipse/com.ibm.mq.pcf/src/com/ibm/mq/pcf/MQCFH.java, javagui, p000, p000-L050114  1.7 04/12/23 11:32:20";
    public int type = 1;
    public static final int strucLength = 36;
    public int version = 1;
    public int command;
    public int msgSeqNumber = 1;
    public int control = 1;
    public int compCode;
    public int reason;
    public int parameterCount;

    public static int write(MQMessage message, int command, int param_count) throws IOException {
        return MQCFH.write(message, command, param_count, 1, 1);
    }

    public static int write(MQMessage message, int command, int param_count, int type, int version) throws IOException {
        message.writeInt(type);
        message.writeInt(36);
        message.writeInt(version);
        message.writeInt(command);
        message.writeInt(1);
        message.writeInt(1);
        message.writeInt(0);
        message.writeInt(0);
        message.writeInt(param_count);
        return 36;
    }

    public MQCFH() {
    }

    public MQCFH(int command, int parameterCount) {
        this.command = command;
        this.parameterCount = parameterCount;
    }

    public MQCFH(MQMessage message) throws MQException, IOException {
        this.initialize(message);
    }

    public void initialize(MQMessage message) throws MQException, IOException {
        this.type = message.readInt();
        switch (this.type) {
            case 1: 
            case 2: 
            case 7: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            default: {
                System.out.println("*** type = " + this.type);
                throw new MQException(2, 3001, (Object)message);
            }
        }
        if (message.readInt() != 36) {
            throw new MQException(2, 3002, (Object)message);
        }
        this.version = message.readInt();
        this.command = message.readInt();
        this.msgSeqNumber = message.readInt();
        this.control = message.readInt();
        this.compCode = message.readInt();
        this.reason = message.readInt();
        this.parameterCount = message.readInt();
    }

    public int write(MQMessage message) throws IOException {
        message.writeInt(this.type);
        message.writeInt(36);
        message.writeInt(this.version);
        message.writeInt(this.command);
        message.writeInt(this.msgSeqNumber);
        message.writeInt(this.control);
        message.writeInt(this.compCode);
        message.writeInt(this.reason);
        message.writeInt(this.parameterCount);
        return 36;
    }

    public int size() {
        return 36;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof MQCFH) {
            MQCFH other = (MQCFH)obj;
            return other.type == this.type && other.version == this.version && other.command == this.command && other.msgSeqNumber == this.msgSeqNumber && other.control == this.control && other.compCode == this.compCode && other.reason == this.reason && other.parameterCount == this.parameterCount;
        }
        return false;
    }

    public String getSymbol(int number) {
        String symbol = null;
        if (symbol == null) {
            symbol = this.getSymbolInternal(number, "MQCMD_");
        }
        return symbol;
    }

    public String toString() {
        String unqualifiedClassName = this.getClass().getName();
        if (unqualifiedClassName.lastIndexOf(46) > 0) {
            unqualifiedClassName = unqualifiedClassName.substring(unqualifiedClassName.lastIndexOf(46) + 1);
        }
        String commandName = Integer.toString(this.command);
        String symbol = this.getSymbol(this.command);
        if (symbol != null) {
            commandName = commandName + " = " + symbol;
        }
        return new String(unqualifiedClassName + ": type: " + this.type + ", strucLength: " + 36 + ", version: " + this.version + ", command: " + commandName + ", msgSeqNumber: " + this.msgSeqNumber + ", control: " + this.control + ", compCode: " + this.compCode + ", reason: " + this.reason + ", parameterCount: " + this.parameterCount);
    }
}

