/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.pcf;

import com.ibm.mq.MQException;
import com.ibm.mq.MQMessage;
import com.ibm.mq.pcf.PCFParameter;
import java.io.IOException;

public class MQCFIL
extends PCFParameter {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) eclipse/com.ibm.mq.pcf/src/com/ibm/mq/pcf/MQCFIL.java, javagui, p000, p000-L041222  1.5 04/12/21 12:12:11";
    public static final int type = 5;
    public int strucLength = 16;
    public int parameter;
    public int count;
    public int[] values;

    public static int write(MQMessage message, int parameter2, int[] values) throws IOException {
        int count = values == null ? 0 : values.length;
        message.writeInt(5);
        message.writeInt(16 + count * 4);
        message.writeInt(parameter2);
        message.writeInt(count);
        for (int i = 0; i < count; ++i) {
            message.writeInt(values[i]);
        }
        return 16 + count * 4;
    }

    public MQCFIL() {
    }

    public MQCFIL(int parameter2, int[] values) {
        this.parameter = parameter2;
        this.setValues(values);
    }

    public MQCFIL(MQMessage message) throws MQException, IOException {
        this.initialize(message);
    }

    public void initialize(MQMessage message) throws MQException, IOException {
        if (message.readInt() != 5) {
            throw new MQException(2, 3013, (Object)message);
        }
        this.strucLength = message.readInt();
        this.parameter = message.readInt();
        this.count = message.readInt();
        if (this.count < 0) {
            throw new MQException(2, 3027, (Object)message);
        }
        if (this.strucLength != 16 + this.count * 4) {
            throw new MQException(2, 3028, (Object)message);
        }
        this.values = new int[this.count];
        for (int i = 0; i < this.count; ++i) {
            this.values[i] = message.readInt();
        }
    }

    public int write(MQMessage message) throws IOException {
        int count = this.values == null ? 0 : this.values.length;
        message.writeInt(5);
        message.writeInt(this.strucLength);
        message.writeInt(this.parameter);
        message.writeInt(count);
        for (int i = 0; i < count; ++i) {
            message.writeInt(this.values[i]);
        }
        return 16 + count * 4;
    }

    public int size() {
        return this.strucLength;
    }

    public int getType() {
        return 5;
    }

    public int getParameter() {
        return this.parameter;
    }

    public Object getValue() {
        try {
            return this.values.clone();
        }
        catch (NullPointerException npe) {
            return null;
        }
    }

    public String getStringValue() {
        if (this.values == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.values.length; ++i) {
            sb.append(this.values[i]);
            sb.append('\n');
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length());
        }
        return new String(sb);
    }

    public void setValue(Object value2) throws ClassCastException {
        this.setValues((int[])value2);
    }

    public void setValues(int[] values) {
        int count = values == null ? 0 : values.length;
        this.strucLength = 16 + count * 4;
        this.count = count;
        this.values = values;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof MQCFIL) {
            MQCFIL other = (MQCFIL)obj;
            int[] otherValues = other.values;
            int[] values = this.values;
            if (other.parameter == this.parameter && otherValues != null && values != null && otherValues.length == values.length) {
                int i = values.length;
                boolean match = true;
                while (match && i-- > 0) {
                    match = otherValues[i] == values[i];
                }
                return match;
            }
            return false;
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getUnqualifiedClassName());
        sb.append(": type: 5");
        sb.append(", strucLength: " + this.strucLength);
        sb.append(", parameter: " + this.getParameterName(this.parameter));
        sb.append(", count: " + this.count);
        sb.append(", values: ");
        try {
            for (int i = 0; i < this.values.length; ++i) {
                sb.append("\t" + this.values[i]);
            }
        }
        catch (NullPointerException npe) {
            sb.append("null");
        }
        return new String(sb);
    }
}

