/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.pcf;

import com.ibm.mq.MQException;
import com.ibm.mq.MQMessage;
import com.ibm.mq.pcf.PCFParameter;
import java.io.IOException;

public class MQCFIL64
extends PCFParameter {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) eclipse/com.ibm.mq.pcf/src/com/ibm/mq/pcf/MQCFIL64.java, javagui, p000, p000-L041222  1.5 04/12/21 12:12:20";
    static final int MQCFT_INTEGER64_LIST = 25;
    static final int MQCFIL64_STRUC_LENGTH_FIXED = 16;
    public static final int type = 5;
    public int strucLength = 16;
    public int parameter;
    public int count;
    public long[] values;

    public static int write(MQMessage message, int parameter2, long[] values) throws IOException {
        int count = values == null ? 0 : values.length;
        message.writeInt(5);
        message.writeInt(16 + count * 8);
        message.writeInt(parameter2);
        message.writeInt(count);
        for (int i = 0; i < count; ++i) {
            message.writeLong(values[i]);
        }
        return 16 + count * 8;
    }

    public MQCFIL64() {
    }

    public MQCFIL64(int parameter2, long[] values) {
        this.parameter = parameter2;
        this.setValues(values);
    }

    public MQCFIL64(MQMessage message) throws MQException, IOException {
        this.initialize(message);
    }

    public void initialize(MQMessage message) throws MQException, IOException {
        if (message.readInt() != 5) {
            throw new MQException(2, 3013, (Object)message);
        }
        this.strucLength = message.readInt();
        this.parameter = message.readInt();
        this.count = message.readInt();
        if (this.count < 0) {
            throw new MQException(2, 3027, (Object)message);
        }
        if (this.strucLength != 16 + this.count * 8) {
            throw new MQException(2, 3028, (Object)message);
        }
        this.values = new long[this.count];
        for (int i = 0; i < this.count; ++i) {
            this.values[i] = message.readLong();
        }
    }

    public int write(MQMessage message) throws IOException {
        int count = this.values == null ? 0 : this.values.length;
        message.writeInt(5);
        message.writeInt(this.strucLength);
        message.writeInt(this.parameter);
        message.writeInt(count);
        for (int i = 0; i < count; ++i) {
            message.writeLong(this.values[i]);
        }
        return 16 + count * 8;
    }

    public int size() {
        return this.strucLength;
    }

    public int getType() {
        return 5;
    }

    public int getParameter() {
        return this.parameter;
    }

    public Object getValue() {
        try {
            return this.values.clone();
        }
        catch (NullPointerException npe) {
            return null;
        }
    }

    public String getStringValue() {
        if (this.values == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.values.length; ++i) {
            sb.append(this.values[i]);
            sb.append('\n');
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length());
        }
        return new String(sb);
    }

    public void setValue(Object value2) throws ClassCastException {
        this.setValues((long[])value2);
    }

    public void setValues(long[] values) {
        int count = values == null ? 0 : values.length;
        this.strucLength = 16 + count * 8;
        this.count = count;
        this.values = values;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof MQCFIL64) {
            MQCFIL64 other = (MQCFIL64)obj;
            long[] otherValues = other.values;
            long[] values = this.values;
            if (other.parameter == this.parameter && otherValues != null && values != null && otherValues.length == values.length) {
                int i = values.length;
                boolean match = true;
                while (match && i-- > 0) {
                    match = otherValues[i] == values[i];
                }
                return match;
            }
            return false;
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getUnqualifiedClassName());
        sb.append(": type: 5\n");
        sb.append(", strucLength: " + this.strucLength);
        sb.append(", parameter: " + this.getParameterName(this.parameter));
        sb.append(", count: " + this.count);
        sb.append(", values: ");
        try {
            for (int i = 0; i < this.values.length; ++i) {
                sb.append("\t" + this.values[i]);
            }
        }
        catch (NullPointerException npe) {
            sb.append("null");
        }
        sb.append('\n');
        return new String(sb);
    }
}

