/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.pcf;

import com.ibm.mq.MQException;
import com.ibm.mq.MQMessage;
import com.ibm.mq.pcf.PCFAgent;
import com.ibm.mq.pcf.PCFFilterParameter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class MQCFSF
extends PCFFilterParameter {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) eclipse/com.ibm.mq.pcf/src/com/ibm/mq/pcf/MQCFSF.java, javagui, p000, p000-L050421  1.13 05/04/20 17:27:18";
    static final String[] pads = new String[]{"", " ", "  ", "   ", ""};
    public static final int type = 14;
    public int strucLength = 24;
    public int parameter;
    public int operator;
    public int codedCharSetId;
    public int filterValueLength;
    public String filterValue;

    public static int write(MQMessage message, int parameter2, int operator, String filterValue) throws IOException {
        int stringLength = MQCFSF.getStringLength(filterValue, message.characterSet);
        int padLength = stringLength % 4;
        if (padLength != 0) {
            padLength = 4 - padLength;
        }
        int totalLength = 24 + stringLength + padLength;
        message.writeString("");
        message.writeInt(14);
        message.writeInt(totalLength);
        message.writeInt(parameter2);
        message.writeInt(operator);
        message.writeInt(message.characterSet);
        message.writeInt(stringLength);
        message.writeString(filterValue);
        if (padLength != 0) {
            message.writeString(pads[padLength]);
        }
        return totalLength;
    }

    public MQCFSF() {
        this.setString("");
    }

    public MQCFSF(int parameter2, int operator, String string) {
        this.parameter = parameter2;
        this.operator = operator;
        this.setString(string);
    }

    public MQCFSF(MQMessage message) throws MQException, IOException {
        this.initialize(message);
    }

    public void initialize(MQMessage message) throws MQException, IOException {
        int type = message.readInt();
        if (type != 14) {
            throw new MQException(2, 3013, (Object)message);
        }
        this.strucLength = message.readInt();
        this.parameter = message.readInt();
        this.operator = message.readInt();
        this.codedCharSetId = message.readInt();
        this.filterValueLength = message.readInt();
        this.filterValue = message.readStringOfByteLength(this.filterValueLength);
        if (this.filterValueLength < 0) {
            throw new MQException(2, 3011, (Object)message);
        }
        if (this.strucLength < 24 + this.filterValueLength) {
            throw new MQException(2, 3010, (Object)message);
        }
        int padLength = this.strucLength - 24 - this.filterValueLength;
        while (padLength-- > 0) {
            message.readByte();
        }
    }

    public int write(MQMessage message) throws IOException {
        int stringLength = MQCFSF.getStringLength(this.filterValue, message.characterSet);
        int padLength = stringLength % 4;
        if (padLength != 0) {
            padLength = 4 - padLength;
        }
        message.writeString("");
        message.writeInt(14);
        message.writeInt(this.strucLength);
        message.writeInt(this.parameter);
        message.writeInt(this.operator);
        message.writeInt(message.characterSet);
        message.writeInt(this.filterValueLength);
        message.writeString(this.filterValue);
        if (padLength != 0) {
            message.writeString(pads[padLength]);
        }
        return 24 + stringLength + padLength;
    }

    public int size() {
        return this.strucLength;
    }

    public int getType() {
        return 14;
    }

    public int getParameter() {
        return this.parameter;
    }

    public Object getValue() {
        return this.filterValue;
    }

    public String getStringValue() {
        if (this.filterValue == null) {
            return "";
        }
        return this.filterValue;
    }

    public void setValue(Object value2) throws ClassCastException {
        this.setString((String)value2);
    }

    public int getOperator() {
        return this.operator;
    }

    public void setString(String string) {
        try {
            this.codedCharSetId = PCFAgent.defaultCharacterSet;
            int stringLength = MQCFSF.getStringLength(string, this.codedCharSetId);
            int padLength = stringLength % 4;
            if (padLength != 0) {
                padLength = 4 - padLength;
            }
            this.strucLength = 24 + stringLength + padLength;
            this.filterValueLength = stringLength;
            this.filterValue = string;
        }
        catch (UnsupportedEncodingException e2) {
            this.strucLength = 24;
            this.filterValueLength = 0;
            this.filterValue = new String();
        }
    }

    public String toString() {
        String filterValueName = "null";
        if (this.filterValue != null) {
            filterValueName = "'" + this.filterValue + "'";
        }
        return new String(this.getUnqualifiedClassName() + ": type: " + 14 + ", strucLength: " + this.strucLength + ", parameter: " + this.getParameterName(this.parameter) + ", operator: " + this.operator + ", codedCharSetId: " + this.codedCharSetId + ", stringLength: " + this.filterValueLength + ", string: " + filterValueName);
    }
}

