/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.pcf;

import com.ibm.mq.MQException;
import com.ibm.mq.MQMessage;
import com.ibm.mq.pcf.PCFAgent;
import com.ibm.mq.pcf.PCFParameter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class MQCFSL
extends PCFParameter {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) eclipse/com.ibm.mq.pcf/src/com/ibm/mq/pcf/MQCFSL.java, javagui, p000, p000-L050216  1.11 05/02/15 14:46:01";
    public static final int type = 6;
    public int strucLength;
    public int parameter;
    public int codedCharSetId;
    public int count;
    public int stringLength;
    public String[] strings;

    public static int write(MQMessage message, int parameter2, String[] inputStrings) throws IOException {
        int length;
        int i;
        String[] strings = inputStrings;
        if (strings == null) {
            strings = new String[]{};
        }
        int count = strings.length;
        int stringLength = 0;
        StringBuffer pad = new StringBuffer();
        for (i = 0; i < count; ++i) {
            length = MQCFSL.getStringLength(strings[i], message.characterSet);
            if (length <= stringLength) continue;
            stringLength = length;
        }
        int padLength = count * stringLength % 4;
        if (padLength != 0) {
            padLength = 4 - padLength;
        }
        message.writeString("");
        message.writeInt(6);
        message.writeInt(24 + count * stringLength + padLength);
        message.writeInt(parameter2);
        message.writeInt(message.characterSet);
        message.writeInt(count);
        message.writeInt(stringLength);
        for (i = 0; i < count; ++i) {
            length = MQCFSL.writeString(message, strings[i]) - stringLength;
            while (length-- > 0) {
                pad.append(' ');
            }
            if (pad.length() <= 0) continue;
            message.writeString(new String(pad));
            pad.setLength(0);
        }
        while (padLength-- > 0) {
            pad.append(' ');
        }
        if (pad.length() > 0) {
            message.writeString(new String(pad));
        }
        return 24 + count * stringLength + padLength;
    }

    public MQCFSL() {
    }

    public MQCFSL(int parameter2, String[] strings) {
        this.parameter = parameter2;
        this.setStrings(strings);
    }

    public MQCFSL(MQMessage message) throws MQException, IOException {
        this.initialize(message);
    }

    public void initialize(MQMessage message) throws MQException, IOException {
        int type = message.readInt();
        if (type != 6) {
            throw new MQException(2, 3013, (Object)message);
        }
        this.strucLength = message.readInt();
        this.parameter = message.readInt();
        this.codedCharSetId = message.readInt();
        this.count = message.readInt();
        this.stringLength = message.readInt();
        if (this.count < 0) {
            throw new MQException(2, 2238, (Object)message);
        }
        if (this.stringLength < 0) {
            throw new MQException(2, 2238, (Object)message);
        }
        if (this.strucLength < 24 + this.count * this.stringLength) {
            throw new MQException(2, 3067, (Object)message);
        }
        this.strings = new String[this.count];
        for (int i = 0; i < this.count; ++i) {
            this.strings[i] = message.readStringOfByteLength(this.stringLength);
        }
        int padLength = this.strucLength - 24 - this.count * this.stringLength;
        while (padLength-- > 0) {
            message.readByte();
        }
    }

    public int write(MQMessage message) throws IOException {
        StringBuffer pad = new StringBuffer();
        int padLength = this.count * this.stringLength % 4;
        if (padLength != 0) {
            padLength = 4 - padLength;
        }
        message.writeString("");
        message.writeInt(6);
        message.writeInt(this.strucLength);
        message.writeInt(this.parameter);
        message.writeInt(message.characterSet);
        message.writeInt(this.count);
        message.writeInt(this.stringLength);
        for (int i = 0; i < this.count; ++i) {
            int length = MQCFSL.writeString(message, this.strings[i]) - this.stringLength;
            while (length-- > 0) {
                pad.append(' ');
            }
            if (pad.length() <= 0) continue;
            message.writeString(new String(pad));
            pad.setLength(0);
        }
        while (padLength-- > 0) {
            pad.append(' ');
        }
        if (pad.length() > 0) {
            message.writeString(new String(pad));
        }
        return 24 + this.count * this.stringLength + padLength;
    }

    public int size() {
        return this.strucLength;
    }

    public int getType() {
        return 6;
    }

    public int getParameter() {
        return this.parameter;
    }

    public Object getValue() {
        try {
            return this.strings.clone();
        }
        catch (NullPointerException npe) {
            return null;
        }
    }

    public String getStringValue() {
        if (this.strings == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.strings.length; ++i) {
            sb.append(this.strings[i]);
            sb.append('\n');
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return new String(sb);
    }

    public void setValue(Object value2) throws ClassCastException {
        this.setStrings((String[])value2);
    }

    public void setStrings(String[] strings) {
        try {
            this.codedCharSetId = PCFAgent.defaultCharacterSet;
            int count = strings.length;
            int stringLength = 0;
            for (int i = 0; i < count; ++i) {
                String string = strings[i];
                int length = MQCFSL.getStringLength(string, this.codedCharSetId);
                if (length <= stringLength) continue;
                stringLength = length;
            }
            int totalLength = count * stringLength;
            int padLength = totalLength % 4;
            if (padLength != 0) {
                padLength = 4 - padLength;
            }
            this.stringLength = stringLength;
            this.strucLength = 24 + totalLength + padLength;
            this.strings = strings;
            this.count = count;
        }
        catch (UnsupportedEncodingException e2) {
            this.stringLength = 0;
            this.strucLength = 24;
            this.strings = new String[0];
            this.count = 0;
        }
        catch (NullPointerException npe) {
            this.stringLength = 0;
            this.strucLength = 24;
            this.strings = new String[0];
            this.count = 0;
        }
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof MQCFSL) {
            MQCFSL other = (MQCFSL)obj;
            String[] otherValues = other.strings;
            String[] values = this.strings;
            if (other.parameter == this.parameter && otherValues != null && values != null && otherValues.length == values.length) {
                int i = values.length;
                boolean match = true;
                while (match && i-- > 0) {
                    if (otherValues[i] != null) {
                        match = otherValues[i].equals(values[i]);
                        continue;
                    }
                    match = values[i] == null;
                }
                return match;
            }
            return false;
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getUnqualifiedClassName());
        sb.append(": type: 6");
        sb.append(", strucLength: " + this.strucLength);
        sb.append(", parameter: " + this.getParameterName(this.parameter));
        sb.append(", codedCharSetId: " + this.codedCharSetId);
        sb.append(", count: " + this.count);
        sb.append(", stringLength: " + this.stringLength);
        sb.append(", strings: ");
        try {
            for (int i = 0; i < this.strings.length; ++i) {
                sb.append("\t'" + this.strings[i] + '\'');
            }
        }
        catch (NullPointerException npe) {
            sb.append("null");
        }
        return new String(sb);
    }
}

