/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.pcf;

import com.ibm.mq.MQException;
import com.ibm.mq.MQMessage;
import com.ibm.mq.pcf.PCFAgent;
import com.ibm.mq.pcf.PCFParameter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class MQCFST
extends PCFParameter {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) eclipse/com.ibm.mq.pcf/src/com/ibm/mq/pcf/MQCFST.java, javagui, p000, p000-L050216  1.10 05/02/15 14:46:01";
    static final String[] pads = new String[]{"", " ", "  ", "   ", ""};
    public static final int type = 4;
    public int strucLength = 20;
    public int parameter;
    public int codedCharSetId;
    public int stringLength;
    public String string;

    public static int write(MQMessage message, int parameter2, String string) throws IOException {
        int stringLength = MQCFST.getStringLength(string, message.characterSet);
        int padLength = stringLength % 4;
        if (padLength != 0) {
            padLength = 4 - padLength;
        }
        int totalLength = 20 + stringLength + padLength;
        message.writeString("");
        message.writeInt(4);
        message.writeInt(totalLength);
        message.writeInt(parameter2);
        message.writeInt(message.characterSet);
        message.writeInt(stringLength);
        message.writeString(string);
        if (padLength != 0) {
            message.writeString(pads[padLength]);
        }
        return totalLength;
    }

    public MQCFST() {
        this.setString("");
    }

    public MQCFST(int parameter2, String string) {
        this.parameter = parameter2;
        this.setString(string);
    }

    public MQCFST(MQMessage message) throws MQException, IOException {
        this.initialize(message);
    }

    public void initialize(MQMessage message) throws MQException, IOException {
        int type = message.readInt();
        if (type != 4) {
            throw new MQException(2, 3013, (Object)message);
        }
        this.strucLength = message.readInt();
        this.parameter = message.readInt();
        this.codedCharSetId = message.readInt();
        this.stringLength = message.readInt();
        this.string = message.readStringOfByteLength(this.stringLength);
        if (this.stringLength < 0) {
            throw new MQException(2, 3011, (Object)message);
        }
        if (this.strucLength < 20 + this.stringLength) {
            throw new MQException(2, 3010, (Object)message);
        }
        int padLength = this.strucLength - 20 - this.stringLength;
        while (padLength-- > 0) {
            message.readByte();
        }
    }

    public int write(MQMessage message) throws IOException {
        int stringLength = MQCFST.getStringLength(this.string, message.characterSet);
        int padLength = stringLength % 4;
        if (padLength != 0) {
            padLength = 4 - padLength;
        }
        message.writeString("");
        message.writeInt(4);
        message.writeInt(this.strucLength);
        message.writeInt(this.parameter);
        message.writeInt(message.characterSet);
        message.writeInt(stringLength);
        message.writeString(this.string);
        if (padLength != 0) {
            message.writeString(pads[padLength]);
        }
        return 20 + stringLength + padLength;
    }

    public int size() {
        return this.strucLength;
    }

    public int getType() {
        return 4;
    }

    public int getParameter() {
        return this.parameter;
    }

    public Object getValue() {
        return this.string;
    }

    public String getStringValue() {
        if (this.string == null) {
            return "";
        }
        return this.string;
    }

    public void setValue(Object value2) throws ClassCastException {
        this.setString((String)value2);
    }

    public void setString(String string) {
        try {
            this.codedCharSetId = PCFAgent.defaultCharacterSet;
            int stringLength = MQCFST.getStringLength(string, this.codedCharSetId);
            int padLength = stringLength % 4;
            if (padLength != 0) {
                padLength = 4 - padLength;
            }
            this.strucLength = 20 + stringLength + padLength;
            this.stringLength = stringLength;
            this.string = string;
        }
        catch (UnsupportedEncodingException e2) {
            this.strucLength = 20;
            this.stringLength = 0;
            this.string = new String();
        }
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof MQCFST) {
            MQCFST other = (MQCFST)obj;
            String otherValue = other.string;
            String value2 = this.string;
            return other.parameter == this.parameter && otherValue != null && value2 != null && otherValue.equals(value2);
        }
        return false;
    }

    public String toString() {
        String stringName = "null";
        if (this.string != null) {
            stringName = "'" + this.string + "'";
        }
        return new String(this.getUnqualifiedClassName() + ": type: " + 4 + ", strucLength: " + this.strucLength + ", parameter: " + this.getParameterName(this.parameter) + ", codedCharSetId: " + this.codedCharSetId + ", stringLength: " + this.stringLength + ", string: " + stringName);
    }
}

