/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.pcf;

import com.ibm.mq.MQEnvironment;
import com.ibm.mq.MQException;
import com.ibm.mq.MQGetMessageOptions;
import com.ibm.mq.MQMessage;
import com.ibm.mq.MQPutMessageOptions;
import com.ibm.mq.MQQueue;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.pcf.MQCFH;
import com.ibm.mq.pcf.MQCFIL;
import com.ibm.mq.pcf.MQCFIN;
import com.ibm.mq.pcf.MQCFST;
import com.ibm.mq.pcf.PCFAgentResponseTracker;
import com.ibm.mq.pcf.PCFAgentResponseTracker390;
import com.ibm.mq.pcf.PCFAgentResponseTrackerNon390;
import com.ibm.mq.pcf.PCFParameter;
import java.io.IOException;
import java.util.Vector;

public class PCFAgent {
    public static final String copyright = "Copyright (c) IBM Corp. 1998, 2004   All rights reserved.";
    static final String DEFAULT_MODEL_QUEUE_NAME = "SYSTEM.DEFAULT.MODEL.QUEUE";
    final MQPutMessageOptions pmo = new MQPutMessageOptions();
    final MQGetMessageOptions gmo = new MQGetMessageOptions();
    protected String modelQueueName = "SYSTEM.DEFAULT.MODEL.QUEUE";
    protected String replyQueuePrefix = "";
    protected MQQueueManager qmanager;
    protected String replyQueueName;
    protected MQQueue adminQueue;
    protected MQQueue replyQueue;
    protected int expiryTime = 300;
    protected int waitInterval = 30000;
    protected int encoding = 273;
    protected static int defaultCharacterSet = 0;
    protected String qmanager_name;
    protected int qmanager_level;
    protected int qmanager_platform;

    public PCFAgent() {
        this.pmo.options = 128;
        this.gmo.options = 24577;
        this.gmo.waitInterval = this.waitInterval;
    }

    public PCFAgent(MQQueueManager qmanager) throws MQException {
        this();
        this.connect(qmanager);
    }

    public PCFAgent(String host, int port2, String channel) throws MQException {
        this();
        this.connect(host, port2, channel);
    }

    public PCFAgent(String qmanager) throws MQException {
        this();
        this.connect(qmanager);
    }

    public synchronized void connect(MQQueueManager qmanager) throws MQException {
        this.open(qmanager, true);
    }

    public synchronized void connect(MQQueueManager qmanager, String targetQueue, String targetQmanager) throws MQException {
        this.open(qmanager, targetQueue, targetQmanager, true);
    }

    public synchronized void connect(String host, int port2, String channel) throws MQException {
        MQEnvironment.hostname = host;
        MQEnvironment.port = port2;
        MQEnvironment.channel = channel;
        this.open(new MQQueueManager(""), false);
    }

    public synchronized void connect(String host, int port2, String channel, String targetQueue, String targetQmanager) throws MQException {
        MQEnvironment.hostname = host;
        MQEnvironment.port = port2;
        MQEnvironment.channel = channel;
        this.open(new MQQueueManager(""), targetQueue, targetQmanager, false);
    }

    public synchronized void connect(String qmanager) throws MQException {
        MQEnvironment.hostname = null;
        MQEnvironment.port = 1414;
        MQEnvironment.channel = null;
        this.open(new MQQueueManager(qmanager), false);
    }

    public synchronized void connect(String qmanager, String targetQueue, String targetQmanager) throws MQException {
        MQEnvironment.hostname = null;
        MQEnvironment.port = 1414;
        MQEnvironment.channel = null;
        this.open(new MQQueueManager(qmanager), targetQueue, targetQmanager, false);
    }

    protected synchronized void open(MQQueueManager qmanager, boolean external) throws MQException {
        this.open(qmanager, null, null, external);
    }

    protected synchronized void open(MQQueueManager qmanager, String targetQueue, String targetQmanager, boolean external) throws MQException {
        String prefix;
        try {
            this.disconnect();
        }
        catch (MQException mqe) {
            // empty catch block
        }
        if (targetQueue == null || targetQueue.length() == 0) {
            targetQueue = qmanager.getCommandInputQueueName();
        }
        if ((prefix = this.replyQueuePrefix) != null && prefix.length() > 0) {
            prefix = prefix + Integer.toString(this.hashCode());
        }
        this.adminQueue = qmanager.accessQueue(targetQueue, 8208, targetQmanager, "", "mqm");
        this.replyQueue = qmanager.accessQueue(this.modelQueueName, 8196, "", prefix, "mqm");
        this.replyQueueName = this.replyQueue.name;
        this.replyQueue.closeOptions = 2;
        if (!external) {
            this.qmanager = qmanager;
        }
        this.getBasicQmgrInfo(qmanager, true);
    }

    private void getBasicQmgrInfo(MQQueueManager qmgr, boolean tryBacklevel) throws MQException {
        block11: {
            int type = 16;
            int version = 3;
            if (tryBacklevel) {
                type = 1;
                version = 1;
            }
            try {
                MQMessage message = this.setRequestMQMD(new MQMessage());
                MQCFH.write(message, 2, 1, type, version);
                MQCFIL.write(message, 1001, new int[]{31, 32, 2015});
                this.adminQueue.put(message, this.pmo);
                message.messageId = null;
                message.encoding = this.encoding;
                message.characterSet = defaultCharacterSet;
                this.replyQueue.get(message, this.gmo);
                MQCFH cfh = new MQCFH(message);
                if (cfh.reason == 0) {
                    int parameterCount = cfh.parameterCount;
                    while (parameterCount-- > 0) {
                        PCFParameter p = PCFParameter.nextParameter(message);
                        switch (p.getParameter()) {
                            case 31: {
                                this.qmanager_level = ((MQCFIN)p).value;
                                break;
                            }
                            case 32: {
                                this.qmanager_platform = ((MQCFIN)p).value;
                                break;
                            }
                            case 2015: {
                                this.qmanager_name = ((MQCFST)p).string.trim();
                            }
                        }
                    }
                    break block11;
                }
                if ((cfh.reason == 3001 || cfh.reason == 3003) && tryBacklevel) {
                    this.getBasicQmgrInfo(this.qmanager, false);
                    break block11;
                }
                throw new MQException(cfh.compCode, cfh.reason, (Object)this);
            }
            catch (IOException e2) {
                throw new MQException(2, 2033, (Object)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void disconnect() throws MQException {
        try {
            block5: {
                try {
                    if (this.qmanager != null) {
                        this.qmanager.disconnect();
                        break block5;
                    }
                    this.adminQueue.close();
                    this.replyQueue.close();
                }
                catch (NullPointerException nullPointerException) {
                    Object var3_2 = null;
                    this.adminQueue = null;
                    this.replyQueue = null;
                    this.replyQueueName = null;
                    this.qmanager = null;
                    this.qmanager_name = null;
                    this.qmanager_platform = 0;
                }
            }
            Object var3_1 = null;
            this.adminQueue = null;
            this.replyQueue = null;
            this.replyQueueName = null;
            this.qmanager = null;
            this.qmanager_name = null;
            this.qmanager_platform = 0;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.adminQueue = null;
            this.replyQueue = null;
            this.replyQueueName = null;
            this.qmanager = null;
            this.qmanager_name = null;
            this.qmanager_platform = 0;
            throw throwable;
        }
    }

    public synchronized MQMessage[] send(int command, PCFParameter[] parameters) throws MQException, IOException {
        PCFAgentResponseTracker tracker;
        int count;
        if (this.adminQueue == null) {
            throw new MQException(2, 6124, (Object)this);
        }
        MQMessage message = this.setRequestMQMD(new MQMessage());
        int n = count = parameters == null ? 0 : parameters.length;
        if (this.qmanager_platform == 1) {
            tracker = new PCFAgentResponseTracker390();
            MQCFH.write(message, command, count, 16, 3);
        } else {
            tracker = new PCFAgentResponseTrackerNon390();
            int version = 1;
            for (int i = 0; i < count && version < 3; ++i) {
                version = Math.max(version, parameters[i].getHeaderVersion());
            }
            MQCFH.write(message, command, count, 1, version);
        }
        for (int i = 0; i < count; ++i) {
            parameters[i].write(message);
        }
        this.adminQueue.put(message, this.pmo);
        byte[] correlationId = message.correlationId;
        Vector<MQMessage> v = new Vector<MQMessage>();
        do {
            message = new MQMessage();
            message.correlationId = correlationId;
            message.encoding = this.encoding;
            message.characterSet = defaultCharacterSet;
            this.replyQueue.get(message, this.gmo);
            v.addElement(message);
        } while (!tracker.isLast(message));
        Object[] responses = new MQMessage[v.size()];
        v.copyInto(responses);
        return responses;
    }

    protected MQMessage setRequestMQMD(MQMessage message) throws MQException {
        if (this.qmanager_level < 500) {
            message.setVersion(1);
        }
        message.messageType = 1;
        message.expiry = this.expiryTime;
        message.report = 64;
        message.feedback = 0;
        message.format = "MQADMIN ";
        message.encoding = this.encoding;
        message.characterSet = defaultCharacterSet;
        message.replyToQueueName = this.replyQueueName;
        message.replyToQueueManagerName = "";
        message.persistence = 0;
        return message;
    }

    public void setWaitInterval(int seconds) {
        this.setWaitInterval(seconds, seconds);
    }

    public void setWaitInterval(int wait, int expiry) {
        if (wait >= 0) {
            this.gmo.waitInterval = this.waitInterval = wait * 1000;
        }
        if (expiry >= 0) {
            this.expiryTime = expiry * 10;
        }
    }

    public int getWaitInterval() {
        return this.waitInterval / 1000;
    }

    public int getExpiry() {
        return this.expiryTime / 10;
    }

    public String getQManagerName() {
        return this.qmanager_name;
    }

    public String getReplyQueueName() {
        return this.replyQueueName;
    }

    public void setEncoding(int encoding) {
        this.encoding = encoding;
    }

    public void setCharacterSet(int ccsid) {
        defaultCharacterSet = ccsid;
    }

    public int getPlatform() {
        return this.qmanager_platform;
    }

    public int getCommandLevel() {
        return this.qmanager_level;
    }

    public String getReplyQueuePrefix() {
        return this.replyQueuePrefix;
    }

    public void setReplyQueuePrefix(String prefix) {
        if (prefix == null || prefix.length() == 0) {
            this.replyQueuePrefix = "";
        } else {
            String uniquifier = Integer.toString(this.hashCode());
            if (prefix.length() > 48 - uniquifier.length()) {
                prefix = prefix.substring(48 - uniquifier.length());
            }
            this.replyQueuePrefix = prefix;
        }
    }

    public String getModelQueueName() {
        return this.modelQueueName;
    }

    public void setModelQueueName(String name2) {
        this.modelQueueName = name2 == null ? DEFAULT_MODEL_QUEUE_NAME : name2;
    }
}

