/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.pcf;

import com.ibm.mq.MQException;
import com.ibm.mq.MQMessage;
import com.ibm.mq.pcf.MQCFBS;
import com.ibm.mq.pcf.MQCFH;
import com.ibm.mq.pcf.MQCFIL;
import com.ibm.mq.pcf.MQCFIN;
import com.ibm.mq.pcf.MQCFSL;
import com.ibm.mq.pcf.MQCFST;
import com.ibm.mq.pcf.PCFException;
import com.ibm.mq.pcf.PCFHeader;
import com.ibm.mq.pcf.PCFParameter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

public class PCFMessage
extends PCFHeader
implements Serializable {
    public static final String copyright = "Copyright (c) IBM Corp. 2000   All rights reserved.";
    MQCFH header;
    Vector parameters = new Vector(8, 8);

    public PCFMessage(int command) {
        this(1, command, 1, true);
    }

    public PCFMessage(int type, int command, int msgSeqNumber, boolean last) {
        this.header = new MQCFH(command, 0);
        this.header.type = type;
        this.header.msgSeqNumber = msgSeqNumber;
        this.header.control = last ? 1 : 0;
    }

    public PCFMessage(MQMessage message) throws MQException, IOException {
        this.initialize(message);
    }

    public void initialize(int command) {
        this.initialize(1, command, 1, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(int type, int command, int msgSeqNumber, boolean last) {
        Vector vector = this.parameters;
        synchronized (vector) {
            this.header.type = 1;
            this.header.version = 1;
            this.header.command = command;
            this.header.msgSeqNumber = msgSeqNumber;
            this.header.control = last ? 1 : 0;
            this.header.compCode = 0;
            this.header.reason = 0;
            this.header.parameterCount = 0;
            this.parameters.removeAllElements();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addParameter(PCFParameter parameter2) {
        Vector vector = this.parameters;
        synchronized (vector) {
            this.parameters.addElement(parameter2);
            ++this.header.parameterCount;
            this.header.version = Math.max(this.header.version, parameter2.getHeaderVersion());
        }
    }

    public void addParameter(int parameter2, int value2) {
        this.addParameter(new MQCFIN(parameter2, value2));
    }

    public void addParameter(int parameter2, int[] values) {
        this.addParameter(new MQCFIL(parameter2, values));
    }

    public void addParameter(int parameter2, String value2) {
        this.addParameter(new MQCFST(parameter2, value2));
    }

    public void addParameter(int parameter2, String[] values) {
        this.addParameter(new MQCFSL(parameter2, values));
    }

    public void addParameter(int parameter2, byte[] value2) {
        this.addParameter(new MQCFBS(parameter2, value2));
    }

    public int getType() {
        return this.header.type;
    }

    public int getCommand() {
        return this.header.command;
    }

    public int getMsgSeqNumber() {
        return this.header.msgSeqNumber;
    }

    public int getControl() {
        return this.header.control;
    }

    public int getCompCode() {
        return this.header.compCode;
    }

    public int getReason() {
        return this.header.reason;
    }

    public int getParameterCount() {
        return this.header.parameterCount;
    }

    public Enumeration getParameters() {
        return this.parameters.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PCFParameter getParameter(int parameter2) {
        PCFParameter match = null;
        Vector vector = this.parameters;
        synchronized (vector) {
            int i = this.parameters.size();
            while (i-- > 0 && match == null) {
                PCFParameter p = (PCFParameter)this.parameters.elementAt(i);
                if (parameter2 != p.getParameter()) continue;
                match = p;
            }
        }
        return match;
    }

    public Object getParameterValue(int parameter2) {
        PCFParameter p = this.getParameter(parameter2);
        return p == null ? null : p.getValue();
    }

    public int getIntParameterValue(int parameter2) throws PCFException {
        Integer value2 = (Integer)this.getParameterValue(parameter2);
        if (value2 == null) {
            throw new PCFException(2, 3014, this);
        }
        return value2;
    }

    public int[] getIntListParameterValue(int parameter2) throws PCFException {
        int[] values = (int[])this.getParameterValue(parameter2);
        if (values == null) {
            throw new PCFException(2, 3047, this);
        }
        return values;
    }

    public String getStringParameterValue(int parameter2) throws PCFException {
        String value2 = (String)this.getParameterValue(parameter2);
        if (value2 == null) {
            throw new PCFException(2, 3015, this);
        }
        return value2;
    }

    public String[] getStringListParameterValue(int parameter2) throws PCFException {
        String[] values = (String[])this.getParameterValue(parameter2);
        if (values == null) {
            throw new PCFException(2, 2238, this);
        }
        return values;
    }

    public byte[] getBytesParameterValue(int parameter2) throws PCFException {
        byte[] value2 = (byte[])this.getParameterValue(parameter2);
        if (value2 == null) {
            throw new PCFException(2, 3256, this);
        }
        return value2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(MQMessage message) throws MQException, IOException {
        Vector vector = this.parameters;
        synchronized (vector) {
            this.header = new MQCFH(message);
            this.parameters.removeAllElements();
            int count = this.header.parameterCount;
            this.header.parameterCount = 0;
            while (count-- > 0) {
                this.addParameter(PCFParameter.nextParameter(message));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(MQMessage message) throws IOException {
        Vector vector = this.parameters;
        synchronized (vector) {
            int bytes = this.header.write(message);
            int count = this.parameters.size();
            for (int i = 0; i < count; ++i) {
                PCFParameter p = (PCFParameter)this.parameters.elementAt(i);
                bytes += p.write(message);
            }
            return bytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Vector vector = this.parameters;
        synchronized (vector) {
            int size = this.header.size();
            int i = this.parameters.size();
            while (i-- > 0) {
                PCFParameter p = (PCFParameter)this.parameters.elementAt(i);
                size += p.size();
            }
            return size;
        }
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof PCFMessage) {
            PCFMessage other = (PCFMessage)obj;
            if (other.getParameterCount() == this.getParameterCount() && other.header.equals(this.header)) {
                Enumeration otherParameters = other.getParameters();
                Enumeration parameters = this.getParameters();
                boolean match = true;
                try {
                    while (match && parameters.hasMoreElements()) {
                        match = otherParameters.nextElement().equals(parameters.nextElement());
                    }
                }
                catch (NoSuchElementException nsee) {
                    return false;
                }
                return match;
            }
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer sb = new StringBuffer();
        Vector vector = this.parameters;
        synchronized (vector) {
            sb.append(this.getUnqualifiedClassName());
            sb.append(": \n");
            sb.append(this.header.toString());
            for (int i = 0; i < this.parameters.size(); ++i) {
                PCFParameter p = (PCFParameter)this.parameters.elementAt(i);
                sb.append('\n');
                sb.append(p.toString());
            }
        }
        return new String(sb);
    }
}

