/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.pcf;

import com.ibm.mq.MQException;
import com.ibm.mq.MQMessage;
import com.ibm.mq.pcf.CCSID;
import com.ibm.mq.pcf.CMQC;
import com.ibm.mq.pcf.CMQCFC;
import com.ibm.mq.pcf.MQCFBF;
import com.ibm.mq.pcf.MQCFBS;
import com.ibm.mq.pcf.MQCFGR;
import com.ibm.mq.pcf.MQCFIF;
import com.ibm.mq.pcf.MQCFIL;
import com.ibm.mq.pcf.MQCFIL64;
import com.ibm.mq.pcf.MQCFIN;
import com.ibm.mq.pcf.MQCFIN64;
import com.ibm.mq.pcf.MQCFSF;
import com.ibm.mq.pcf.MQCFSL;
import com.ibm.mq.pcf.MQCFST;
import com.ibm.mq.pcf.PCFHeader;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;

public abstract class PCFParameter
extends PCFHeader
implements CMQC,
CMQCFC,
Serializable {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) eclipse/com.ibm.mq.pcf/src/com/ibm/mq/pcf/PCFParameter.java, javagui, p000, p000-L050421  1.14 05/04/20 17:30:42";

    public static PCFParameter nextParameter(MQMessage message) throws MQException, IOException {
        message.writeBytes("");
        int pos = message.getDataOffset();
        int type = message.readInt();
        message.seek(pos);
        switch (type) {
            case 3: {
                return new MQCFIN(message);
            }
            case 5: {
                return new MQCFIL(message);
            }
            case 4: {
                return new MQCFST(message);
            }
            case 6: {
                return new MQCFSL(message);
            }
            case 9: {
                return new MQCFBS(message);
            }
            case 23: {
                return new MQCFIN64(message);
            }
            case 25: {
                return new MQCFIL64(message);
            }
            case 20: {
                return new MQCFGR(message);
            }
            case 13: {
                return new MQCFIF(message);
            }
            case 14: {
                return new MQCFSF(message);
            }
            case 15: {
                return new MQCFBF(message);
            }
        }
        throw new MQException(2, 3013, (Object)message);
    }

    public abstract int getType();

    public abstract int getParameter();

    public abstract Object getValue();

    public abstract String getStringValue();

    public abstract void setValue(Object var1) throws ClassCastException;

    protected static int getStringLength(String string, int characterSet) throws UnsupportedEncodingException {
        int length = 0;
        if (string != null) {
            length = CCSID.convert(string, characterSet).length;
        }
        return length;
    }

    protected static int writeString(MQMessage message, String string) throws IOException {
        if (string == null) {
            return 0;
        }
        int pos = message.getDataOffset();
        message.writeString(string);
        return message.getDataOffset() - pos;
    }

    public int getHeaderVersion() {
        return 1;
    }

    public String getSymbol(int number) {
        String symbol = null;
        if (symbol == null) {
            symbol = this.getSymbolInternal(number, "MQCACF_");
        }
        if (symbol == null) {
            symbol = this.getSymbolInternal(number, "MQIACF_");
        }
        if (symbol == null) {
            symbol = this.getSymbolInternal(number, "MQCA_");
        }
        if (symbol == null) {
            symbol = this.getSymbolInternal(number, "MQIA_");
        }
        if (symbol == null) {
            symbol = this.getSymbolInternal(number, "MQRC_");
        }
        if (symbol == null) {
            symbol = this.getSymbolInternal(number, "MQ");
        }
        return symbol;
    }

    public String getParameterName(int parameter2) {
        String parameterName = Integer.toString(parameter2);
        String symbol = this.getSymbol(parameter2);
        if (symbol != null) {
            parameterName = parameterName + " = " + symbol;
        }
        return parameterName;
    }
}

