/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.intrn.util;

public class Ba2Map {
    public byte[][][][] bsList;
    private final int listMaxSize;
    private int listSize;
    private final int bsLength;
    private int offset;
    private int lastBsn;
    private int lastInd;

    public Ba2Map(int offset0, int listMaxSize0, int bsLength0) {
        this.offset = offset0;
        this.listMaxSize = listMaxSize0;
        this.bsLength = bsLength0;
        this.bsList = new byte[this.listMaxSize][][][];
        byte[][][] bs = new byte[this.bsLength][][];
        this.bsList[0] = bs;
        this.listSize = 1;
    }

    public void clear(int pack_n) {
        int gap = pack_n - this.offset;
        if (gap < 0) {
            return;
        }
        int bsn = gap / this.bsLength;
        if (bsn >= this.listSize) {
            return;
        }
        int rsn = gap - bsn * this.bsLength;
        this.bsList[bsn][rsn] = null;
    }

    public byte[][] remove(int pack_n) {
        int gap = pack_n - this.offset;
        if (gap < 0) {
            return null;
        }
        int bsn = gap / this.bsLength;
        if (bsn >= this.listSize) {
            return null;
        }
        int rsn = gap - bsn * this.bsLength;
        this.lastBsn = bsn;
        this.lastInd = rsn;
        byte[][] res = this.bsList[bsn][this.lastInd];
        this.bsList[bsn][this.lastInd] = null;
        return res;
    }

    public byte[][] removeNext() {
        if (this.lastInd == this.bsLength - 1) {
            if (this.lastBsn == this.listSize - 1) {
                return null;
            }
            ++this.lastBsn;
            this.lastInd = 0;
        } else {
            ++this.lastInd;
        }
        byte[][] res = this.bsList[this.lastBsn][this.lastInd];
        this.bsList[this.lastBsn][this.lastInd] = null;
        return res;
    }

    public boolean set(int pack_n, byte[][] obj) {
        int gap = pack_n - this.offset;
        if (gap < 0) {
            return false;
        }
        int bsn = gap / this.bsLength;
        if (bsn >= this.listSize) {
            int to_add = bsn + 1 - this.listSize;
            int i = 0;
            while (i < to_add) {
                byte[][][] bs = new byte[this.bsLength][][];
                this.bsList[this.listSize] = bs;
                ++this.listSize;
                if (this.listSize > this.listMaxSize) {
                    --this.listSize;
                    throw new ArrayIndexOutOfBoundsException("Exceed maximal Bitmap list size");
                }
                ++i;
            }
        }
        int rsn = gap - bsn * this.bsLength;
        this.bsList[bsn][rsn] = obj;
        return true;
    }

    public boolean setTrail(int pack_n) {
        int gap = pack_n - this.offset;
        if (gap < 0) {
            return false;
        }
        int n_to_drop = gap / this.bsLength;
        if (n_to_drop == 0) {
            return true;
        }
        if (n_to_drop >= this.listSize) {
            this.offset = pack_n;
            int i = 0;
            while (i < this.listSize) {
                this.bsList[i] = null;
                ++i;
            }
            this.listSize = 0;
        } else {
            this.offset += n_to_drop * this.bsLength;
            int i = 0;
            while (i < this.listSize - n_to_drop) {
                this.bsList[i] = this.bsList[i + n_to_drop];
                ++i;
            }
            int j = i;
            while (j < this.listSize) {
                this.bsList[j] = null;
                ++j;
            }
            this.listSize -= n_to_drop;
        }
        return true;
    }
}

