/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.intrn.util;

import com.ibm.rmm.intrn.util.RmmBuffer;

public class BufferCyclQueue {
    RmmBuffer[] queue;
    int firstPos;
    int curPos;
    int nElements;
    int qCapacity;

    public BufferCyclQueue(int size) {
        this.queue = new RmmBuffer[size];
        this.qCapacity = size;
        this.firstPos = 0;
        this.curPos = 0;
        this.nElements = 0;
    }

    public void pushLast(RmmBuffer element) {
        if (this.nElements == this.qCapacity) {
            RmmBuffer[] new_q = new RmmBuffer[2 * this.qCapacity];
            int j = 0;
            int i = this.firstPos;
            while (i < this.qCapacity) {
                new_q[j] = this.queue[i];
                ++j;
                ++i;
            }
            i = 0;
            while (i < this.firstPos) {
                new_q[j] = this.queue[i];
                ++j;
                ++i;
            }
            this.queue = new_q;
            this.curPos = this.qCapacity;
            this.qCapacity *= 2;
            this.firstPos = 0;
        }
        this.queue[this.curPos] = element;
        ++this.nElements;
        ++this.curPos;
        if (this.curPos == this.qCapacity) {
            this.curPos = 0;
        }
    }

    public RmmBuffer popFirst() {
        if (this.nElements == 0) {
            return null;
        }
        RmmBuffer res = this.queue[this.firstPos];
        this.queue[this.firstPos] = null;
        --this.nElements;
        if (this.nElements == 0) {
            this.firstPos = 0;
            this.curPos = 0;
        } else {
            ++this.firstPos;
            if (this.firstPos == this.qCapacity) {
                this.firstPos = 0;
            }
        }
        return res;
    }

    public RmmBuffer seeElement(int pack_ind) {
        if (pack_ind < 0 || pack_ind >= this.nElements) {
            return null;
        }
        int ind = this.firstPos + pack_ind;
        if (ind < this.qCapacity) {
            return this.queue[ind];
        }
        return this.queue[ind - this.qCapacity];
    }

    public int qSize() {
        return this.nElements;
    }

    public boolean isEmpty() {
        return this.nElements == 0;
    }

    public String toString() {
        return " " + this.firstPos + " " + this.curPos + " " + this.nElements + " " + this.qCapacity;
    }
}

