/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.intrn.util;

import com.ibm.rmm.intrn.util.RmmBuffer;

public class BufferPool {
    private RmmBuffer[] pool;
    private int buffSize;
    private int fullSize;
    private int currSize;
    private int idleSize;

    public BufferPool(int numOfBuffers, int bufferLength) {
        this.buffSize = bufferLength;
        this.fullSize = numOfBuffers;
        this.pool = new RmmBuffer[this.fullSize];
        this.currSize = 0;
        this.idleSize = 0;
    }

    public synchronized RmmBuffer getBuffer() throws Error {
        if (this.idleSize > 0) {
            return this.pool[--this.idleSize];
        }
        if (this.currSize < this.fullSize) {
            RmmBuffer rb = new RmmBuffer(this.buffSize);
            ++this.currSize;
            return rb;
        }
        return null;
    }

    public synchronized void returnBuffer(RmmBuffer buffer) {
        this._returnBuffer(buffer);
    }

    public void _returnBuffer(RmmBuffer buffer) {
        if (buffer == null) {
            return;
        }
        buffer.bb.clear();
        this.pool[this.idleSize++] = buffer;
    }

    public int size() {
        return this.idleSize;
    }

    public int fullSize() {
        return this.fullSize;
    }

    public int getUtilization() {
        return 100 * (this.currSize - this.idleSize) / this.fullSize;
    }
}

