/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.intrn.util;

import java.net.DatagramPacket;
import java.nio.ByteBuffer;

public class BytePack {
    private byte[] ba;
    private DatagramPacket dp;
    private ByteBuffer bb;
    private int offset;
    private int size;
    private int dataLength;

    public BytePack(int capacity, boolean direct) {
        this.size = capacity;
        this.bb = direct ? ByteBuffer.allocateDirect(this.size) : ByteBuffer.allocate(this.size);
        if (this.bb.hasArray()) {
            this.ba = this.bb.array();
            this.offset = this.bb.arrayOffset();
            this.dp = new DatagramPacket(this.ba, this.offset, this.size);
        } else {
            this.ba = null;
            this.dp = null;
            this.offset = 0;
        }
    }

    public BytePack(byte[] array) {
        this.size = array.length;
        this.bb = ByteBuffer.wrap(array);
        if (this.bb.hasArray()) {
            this.ba = this.bb.array();
            this.offset = this.bb.arrayOffset();
            this.dp = new DatagramPacket(this.ba, this.offset, this.size);
        } else {
            this.ba = null;
            this.dp = null;
            this.offset = 0;
        }
    }

    public void reset() {
        this.bb.clear();
        if (this.dp != null) {
            this.dp.setLength(this.size);
        }
    }

    public byte[] getByteArray() {
        return this.ba;
    }

    public DatagramPacket getDatagramPacket() {
        return this.dp;
    }

    public ByteBuffer getByteBuffer() {
        return this.bb;
    }

    public int getSize() {
        return this.size;
    }

    public void setdataLength(int len) {
        this.dataLength = len;
    }

    public int getdataLength() {
        return this.dataLength;
    }
}

