/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.intrn.util;

import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;

public final class PacManIn
extends InputStream
implements DataInput {
    private byte[] buf;
    private int off;
    private int pos;
    private int mark;
    private int len;
    char[] tc;

    public PacManIn() {
    }

    public PacManIn(byte[] b) {
        this.setBuffer(b);
    }

    public PacManIn(byte[] b, int offset, int length) {
        this.setBuffer(b, offset, length);
    }

    public int read() throws IOException {
        if (!this.haveRoom(1)) {
            return -1;
        }
        return this.buf[this.pos++] & 0xFF;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int offset, int length) throws IOException {
        if (b == null) {
            throw new NullPointerException("read: invalid argument");
        }
        if (offset < 0 || length < 0 || offset + length > b.length) {
            throw new IndexOutOfBoundsException("read: invalid argument");
        }
        if (length == 0) {
            return 0;
        }
        int l = length;
        if (l > this.len - this.pos) {
            if (this.len - this.pos < 1) {
                return -1;
            }
            l = this.len - this.pos;
        }
        System.arraycopy(this.buf, this.pos, b, offset, l);
        this.pos += l;
        return l;
    }

    public long skip(long n) {
        n = this.actSkip(n);
        this.pos = (int)((long)this.pos + n);
        return n;
    }

    public int available() {
        return this.len - this.pos;
    }

    public void mark(int limit) {
        this.mark = this.pos;
    }

    public void reset() {
        this.pos = this.mark;
    }

    public void rewind() {
        this.reset();
    }

    public boolean markSupported() {
        return true;
    }

    public void close() {
    }

    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    public void readFully(byte[] b, int offset, int length) throws IOException {
        int l = this.read(b, offset, length);
        if (l < length) {
            throw new EOFException("readFully: bytes read: " + l);
        }
    }

    public int skipBytes(int n) throws IOException {
        return (int)this.skip(n);
    }

    public boolean readBoolean() throws IOException {
        if (!this.haveRoom(1)) {
            throw new EOFException("readBoolean: ");
        }
        return this.buf[this.pos++] != 0;
    }

    public byte readByte() throws IOException {
        if (!this.haveRoom(1)) {
            throw new EOFException("readByte: ");
        }
        return this.buf[this.pos++];
    }

    public int readUnsignedByte() throws IOException {
        if (!this.haveRoom(1)) {
            throw new EOFException("readUnsignedByte: ");
        }
        return this.buf[this.pos++] & 0xFF;
    }

    public short readShort() throws IOException {
        return (short)this.readUnsignedShort();
    }

    public int readUnsignedShort() throws IOException {
        int l = 2;
        if (!this.haveRoom(l)) {
            throw new EOFException("readUnsignedShort: ");
        }
        int v = this.buf[this.pos++] & 0xFF;
        while (--l > 0) {
            v = v << 8 | this.buf[this.pos++] & 0xFF;
        }
        return v;
    }

    public char readChar() throws IOException {
        return (char)this.readUnsignedShort();
    }

    public int readInt() throws IOException {
        int l = 4;
        if (!this.haveRoom(l)) {
            throw new EOFException("readInt: ");
        }
        int v = this.buf[this.pos++];
        while (--l > 0) {
            v = v << 8 | this.buf[this.pos++] & 0xFF;
        }
        return v;
    }

    public long readLong() throws IOException {
        int l = 8;
        if (!this.haveRoom(l)) {
            throw new EOFException("readLong: ");
        }
        l = 4;
        int hi = this.buf[this.pos++];
        while (--l > 0) {
            hi = hi << 8 | this.buf[this.pos++] & 0xFF;
        }
        l = 4;
        int lo = this.buf[this.pos++];
        while (--l > 0) {
            lo = lo << 8 | this.buf[this.pos++] & 0xFF;
        }
        return (long)hi << 32 | (long)lo << 32 >>> 32;
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public String readLine() throws IOException {
        int v;
        if (!this.haveRoom(1)) {
            return null;
        }
        int l = 0;
        while (this.pos < this.len && (v = this.buf[this.pos++] & 0xFF) != 10) {
            if (v == 13) {
                if (this.pos >= this.len || this.buf[this.pos] != 10) break;
                ++this.pos;
                break;
            }
            if (this.tc == null || l >= this.tc.length) {
                if (this.tc == null) {
                    this.tc = new char[(l + 64) / 64 * 64];
                } else {
                    char[] old = this.tc;
                    this.tc = new char[(l + 64) / 64 * 64];
                    if (l > 0) {
                        System.arraycopy(old, 0, this.tc, 0, l);
                    }
                }
            }
            this.tc[l++] = (char)v;
        }
        return new String(this.tc, 0, l);
    }

    /*
     * WARNING - void declaration
     */
    public String readUTF() throws IOException {
        int l = 2;
        if (!this.haveRoom(l)) {
            throw new EOFException("readUTF: ");
        }
        l = this.readUnsignedShort();
        if (l == 0) {
            return new String("");
        }
        if (!this.haveRoom(l)) {
            throw new EOFException("readUTF: ");
        }
        if (this.tc == null || l >= this.tc.length) {
            this.tc = new char[(l + 63) / 64 * 64];
        }
        int lpos = this.pos + l;
        l = 0;
        while (this.pos < lpos) {
            byte u;
            byte v;
            if (((v = this.buf[this.pos++]) & 0x80) == 0) {
                this.tc[l++] = (char)v;
                continue;
            }
            if ((v & 0xE0) == 192) {
                if (this.pos >= this.len || ((u = this.buf[this.pos++]) & 0xC0) != 128) {
                    throw new UTFDataFormatException("readUTF: ");
                }
                this.tc[l++] = (char)((v & 0x1F) << 6 | u & 0x3F);
                continue;
            }
            if ((v & 0xF0) == 224) {
                void var5_5;
                void var4_4;
                byte w;
                if (this.pos + 1 >= this.len || ((u = this.buf[this.pos++]) & 0xC0) != 128 || ((w = this.buf[this.pos++]) & 0xC0) != 128) {
                    throw new UTFDataFormatException("readUTF: ");
                }
                this.tc[l++] = (char)((v & 0xF) << 12 | (var4_4 & 0x3F) << 6 | var5_5 & 0x3F);
                continue;
            }
            throw new UTFDataFormatException("readUTF: ");
        }
        return new String(this.tc, 0, l);
    }

    private boolean haveRoom(int more) {
        return this.pos + more <= this.len;
    }

    public void setBuffer(byte[] b) {
        if (b == null) {
            this.clear();
        } else {
            this.setBuffer(b, 0, b.length);
        }
    }

    public void setBuffer(byte[] b, int offset, int length) {
        if (b == null) {
            if (offset == 0 && length == 0) {
                this.clear();
            } else {
                throw new NullPointerException("setBuffer: invalid argument");
            }
        }
        if (offset < 0 || length < 0 || offset + length > b.length) {
            throw new IndexOutOfBoundsException("setBuffer: invalid argument");
        }
        this.buf = b;
        this.mark = this.pos = (this.off = offset);
        this.len = this.pos + length;
    }

    private long actSkip(long n) {
        if ((long)this.pos + n < (long)this.off) {
            return this.off - this.pos;
        }
        if ((long)this.pos + n > (long)this.len) {
            return this.len - this.pos;
        }
        return n;
    }

    public void safeSkip(long n) throws IOException {
        if (this.actSkip(n) != n) {
            throw new IOException("safeSkip: invalid skip value: " + n);
        }
        this.pos = (int)((long)this.pos + n);
    }

    public void setPosition(int npos) throws IOException {
        long n = npos - this.pos;
        if (this.actSkip(n) != n) {
            throw new IOException("setPosition: invalid new position: " + npos);
        }
        this.pos = npos;
    }

    public byte[] getBuffer() {
        return this.buf;
    }

    public int getPosition() {
        return this.pos;
    }

    public int getOffset() {
        return this.off;
    }

    public int getLength() {
        return this.len;
    }

    public void clear() {
        this.buf = null;
        this.len = 0;
        this.mark = 0;
        this.pos = 0;
        this.off = 0;
    }
}

