/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.intrn.util;

import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;

public final class PacManOut
extends OutputStream
implements DataOutput {
    private byte[] buf;
    private int off;
    private int pos;
    private int len;
    private boolean fixed;

    public PacManOut() {
        this.fixed = false;
    }

    public PacManOut(byte[] b) {
        this.setBuffer(b, 0, b.length);
    }

    public PacManOut(byte[] b, int offset, int length) {
        this.setBuffer(b, offset, length);
    }

    public void close() {
    }

    public void flush() {
    }

    public void write(int v) throws IOException {
        this.makeRoom(1);
        this.buf[this.pos++] = (byte)v;
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int offset, int length) throws IOException {
        if (b == null) {
            throw new NullPointerException("write: invalid argument");
        }
        if (offset < 0 || length < 0 || offset + length > b.length) {
            throw new IndexOutOfBoundsException("write: invalid argument");
        }
        this.makeRoom(length);
        System.arraycopy(b, offset, this.buf, this.pos, length);
        this.pos += length;
    }

    public void writeBoolean(boolean v) throws IOException {
        this.write(v ? 1 : 0);
    }

    public void writeByte(int v) throws IOException {
        this.write(v);
    }

    public void writeShort(int v) throws IOException {
        int l = 2;
        this.makeRoom(l);
        int i = this.pos + l - 1;
        while (i >= this.pos) {
            this.buf[i] = (byte)v;
            v >>>= 8;
            --i;
        }
        this.pos += l;
    }

    public void writeChar(int v) throws IOException {
        int l = 2;
        this.makeRoom(l);
        int i = this.pos + l - 1;
        while (i >= this.pos) {
            this.buf[i] = (byte)v;
            v >>>= 8;
            --i;
        }
        this.pos += l;
    }

    public void writeInt(int v) throws IOException {
        int l = 4;
        this.makeRoom(l);
        int i = this.pos + l - 1;
        while (i >= this.pos) {
            this.buf[i] = (byte)v;
            v >>>= 8;
            --i;
        }
        this.pos += l;
    }

    public void writeLong(long v) throws IOException {
        int l = 8;
        this.makeRoom(l);
        int i = this.pos + l - 1;
        while (i >= this.pos && v != 0L) {
            this.buf[i] = (byte)v;
            v >>>= 8;
            --i;
        }
        while (i >= this.pos) {
            this.buf[i] = 0;
            --i;
        }
        this.pos += l;
    }

    public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    public void writeBytes(String v) throws IOException {
        if (v == null) {
            throw new NullPointerException("writeBytes: invalid argument");
        }
        int n = v.length();
        if (n == 0) {
            return;
        }
        this.makeRoom(n);
        int i = 0;
        while (i < n) {
            this.buf[this.pos++] = (byte)(v.charAt(i) & 0xFF);
            ++i;
        }
    }

    public void writeChars(String v) throws IOException {
        if (v == null) {
            throw new NullPointerException("writeBytes: invalid argument");
        }
        int n = v.length();
        if (n == 0) {
            return;
        }
        this.makeRoom(2 * n);
        int i = 0;
        while (i < n) {
            this.buf[this.pos++] = (byte)(v.charAt(i) >> 8 & 0xFF);
            this.buf[this.pos++] = (byte)(v.charAt(i) & 0xFF);
            ++i;
        }
    }

    public void writeUTF(String v) throws IOException {
        int c;
        if (v == null) {
            throw new NullPointerException("writeBytes: invalid argument");
        }
        int n = v.length();
        this.makeRoom(2 + 3 * n);
        int lp = this.pos;
        this.pos += 2;
        int i = 0;
        while (i < n) {
            c = v.charAt(i);
            if (c >= 1 && c <= 127) {
                this.buf[this.pos++] = (byte)(c & 0xFF);
            } else if (c == 0 || c >= 128 && c <= 2047) {
                this.buf[this.pos++] = (byte)(0xC0 | 0x1F & c >> 6);
                this.buf[this.pos++] = (byte)(0x80 | 0x3F & c);
            } else {
                this.buf[this.pos++] = (byte)(0xE0 | 0xF & c >> 12);
                this.buf[this.pos++] = (byte)(0x80 | 0x3F & c >> 6);
                this.buf[this.pos++] = (byte)(0x80 | 0x3F & c);
            }
            ++i;
        }
        c = this.pos - lp - 2;
        this.buf[lp++] = (byte)(c >> 8 & 0xFF);
        this.buf[lp] = (byte)(c & 0xFF);
    }

    private void makeRoom(int more) throws IOException {
        if (this.pos + more <= this.len) {
            return;
        }
        if (this.fixed) {
            throw new IOException("makeRoom: no more place in given buffer");
        }
        this.len = (this.pos + more + 1023) / 1024 * 1024;
        byte[] old = this.buf;
        try {
            this.buf = new byte[this.len];
        }
        catch (Throwable e2) {
            throw new IOException("makeRoom: failed to increase internal buffer size to " + this.len + " bytes " + e2);
        }
        if (this.pos > 0) {
            System.arraycopy(old, 0, this.buf, 0, this.pos);
        }
    }

    public void setBuffer(byte[] b) {
        this.setBuffer(b, 0, b.length);
    }

    public void setBuffer(byte[] b, int offset, int length) {
        if (b == null) {
            throw new NullPointerException("read: invalid argument");
        }
        if (offset < 0 || length < 0 || offset + length > b.length) {
            throw new IndexOutOfBoundsException("read: invalid argument " + b.length + " " + length + " " + offset);
        }
        this.fixed = true;
        this.buf = b;
        this.pos = this.off = offset;
        this.len = offset + length;
    }

    public void clear() {
        this.fixed = false;
        this.buf = null;
        this.len = 0;
        this.pos = 0;
        this.off = 0;
    }

    public void reset() {
        this.pos = this.off;
    }

    public byte[] getBuffer() {
        return this.buf;
    }

    public int getPosition() {
        return this.pos;
    }

    public int getOffset() {
        return this.off;
    }

    public int getLength() {
        return this.len;
    }

    public byte[] toByteArray() {
        int l = this.pos - this.off;
        byte[] ba = new byte[l];
        if (l > 0) {
            System.arraycopy(this.buf, this.off, ba, 0, l);
        }
        return ba;
    }

    public long skip(long n) {
        n = this.actSkip(n);
        this.pos = (int)((long)this.pos + n);
        return n;
    }

    private long actSkip(long n) {
        if ((long)this.pos + n < (long)this.off) {
            return this.off - this.pos;
        }
        if ((long)this.pos + n > (long)this.len) {
            return this.len - this.pos;
        }
        return n;
    }

    public void safeSkip(long n) throws IOException {
        if (this.actSkip(n) != n) {
            throw new IOException("safeSkip: invalid skip value: " + n);
        }
        this.pos = (int)((long)this.pos + n);
    }

    public void setPosition(int npos) throws IOException {
        long n = npos - this.pos;
        if (this.actSkip(n) != n) {
            throw new IOException("setPosition: invalid new position: " + npos);
        }
        this.pos = npos;
    }
}

