/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.intrn.util;

import java.net.DatagramPacket;

public class PacketCyclQueue {
    DatagramPacket[] queue;
    int firstPos;
    int curPos;
    int nElements;
    int qCapacity;

    public PacketCyclQueue(int size) {
        this.queue = new DatagramPacket[size];
        this.qCapacity = size;
        this.firstPos = 0;
        this.curPos = 0;
        this.nElements = 0;
    }

    public void pushLast(DatagramPacket element) {
        if (this.nElements == this.qCapacity) {
            DatagramPacket[] new_q = new DatagramPacket[2 * this.qCapacity];
            int j = 0;
            int i = this.firstPos;
            while (i < this.qCapacity) {
                new_q[j] = this.queue[i];
                ++j;
                ++i;
            }
            i = 0;
            while (i < this.firstPos) {
                new_q[j] = this.queue[i];
                ++j;
                ++i;
            }
            this.queue = new_q;
            this.curPos = this.qCapacity;
            this.qCapacity *= 2;
            this.firstPos = 0;
        }
        this.queue[this.curPos] = element;
        ++this.nElements;
        ++this.curPos;
        if (this.curPos == this.qCapacity) {
            this.curPos = 0;
        }
    }

    public DatagramPacket popFirst() {
        if (this.nElements == 0) {
            return null;
        }
        DatagramPacket res = this.queue[this.firstPos];
        this.queue[this.firstPos] = null;
        --this.nElements;
        if (this.nElements == 0) {
            this.firstPos = 0;
            this.curPos = 0;
        } else {
            ++this.firstPos;
            if (this.firstPos == this.qCapacity) {
                this.firstPos = 0;
            }
        }
        return res;
    }

    public DatagramPacket seeElement(int pack_ind) {
        if (this.nElements == 0) {
            return null;
        }
        if (pack_ind >= this.nElements) {
            return null;
        }
        int ind = this.firstPos + pack_ind;
        if (ind < this.qCapacity) {
            return this.queue[ind];
        }
        return this.queue[ind -= this.qCapacity];
    }

    public int qSize() {
        return this.nElements;
    }
}

