/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.intrn.util;

import com.ibm.rmm.intrn.util.PgmIpSocket;
import com.ibm.rmm.util.RmmLogger;
import java.io.IOException;
import java.net.InetAddress;
import java.text.MessageFormat;

public class PgmIpLayer {
    static final String moduleName = "NAT_PGM_IP";
    public static final int NAT_ERROR_INIT = 1;
    public static final int NAT_ERROR_MAX_SOCKET_HANDLES = 2;
    public static final int NAT_ERROR_CREATE_SOCKET = 3;
    public static final int NAT_ERROR_BIND = 4;
    public static final int NAT_ERROR_SETSOCKOPT_IP_MULTICAST_IF = 5;
    public static final int NAT_ERROR_SETSOCKOPT_SO_SNDBUF = 6;
    public static final int NAT_ERROR_SETSOCKOPT_SO_RCVBUF = 7;
    public static final int NAT_ERROR_SETSOCKOPT_IP_MULTICAST_TTL = 8;
    public static final int NAT_ERROR_SETSOCKOPT_ROUTER_ALERT = 9;
    public static final int NAT_ERROR_SETSOCKOPT_IP_MULTICAST_LOOP = 10;
    public static final int NAT_ERROR_SETSOCKOPT_SO_REUSEADDR = 11;
    public static final int NAT_ERROR_SETSOCKOPT_SO_REUSEPORT = 12;
    public static final int NAT_ERROR_FCNTL_F_GETFL = 13;
    public static final int NAT_ERROR_FCNTL_F_SETFL = 14;
    public static final int NAT_ERROR_IOCTLSOCKET_FIONBIO = 15;
    public static final int NAT_ERROR_MALLOC = 16;
    public static final int NAT_ERROR_MAX_ADDRESS_HANDLES = 17;
    public static final int NAT_ERROR_ADDR_TO_IP = 18;
    public static final int NAT_ERROR_RECVFROM = 19;
    public static final int NAT_ERROR_SELECT = 20;
    public static final int NAT_ERROR_SENDTO = 21;
    public static final int NAT_ERROR_SETSOCKOPT_IP_ADD_MEMBERSHIP = 22;
    public static final int NAT_ERROR_SETSOCKOPT_IP_DROP_MEMBERSHIP = 23;
    public static final int NAT_ERROR_CLOSE_SOCKET = 24;
    public static final int NAT_ERROR_INVALID_SOCKET_HANDLE = 25;
    public static final int NAT_ERROR_NO_PERMISSION_FOR_RAW_SOCKETS = 26;
    public static final String[] natErrors = new String[100];
    static RmmLogger rmmLogger;

    static {
        PgmIpLayer.natErrors[1] = "RMM_NAT Error({0}): Failed to init Win Sockets";
        PgmIpLayer.natErrors[2] = "RMM_NAT Error({0}): Socket handle limit exeeded";
        PgmIpLayer.natErrors[3] = "RMM_NAT Error({0}): Failed to create socket";
        PgmIpLayer.natErrors[4] = "RMM_NAT Error({0}): Failed to bind socket";
        PgmIpLayer.natErrors[5] = "RMM_NAT Error({0}): Failed to set multicast interface";
        PgmIpLayer.natErrors[6] = "RMM_NAT Error({0}): Failed to set socket send buffer";
        PgmIpLayer.natErrors[7] = "RMM_NAT Error({0}): Failed to set socket receive buffer";
        PgmIpLayer.natErrors[8] = "RMM_NAT Error({0}): Failed to set multicast ttl";
        PgmIpLayer.natErrors[9] = "RMM_NAT Error({0}): Failed to set router alert bits";
        PgmIpLayer.natErrors[10] = "RMM_NAT Error({0}): Failed to set multicast loop option";
        PgmIpLayer.natErrors[11] = "RMM_NAT Error({0}): Failed to set reuse address option";
        PgmIpLayer.natErrors[12] = "RMM_NAT Error({0}): Failed to set reuse port option";
        PgmIpLayer.natErrors[13] = "RMM_NAT Error({0}): Failed to get socket flags by fcntl (to set nonblocking)";
        PgmIpLayer.natErrors[14] = "RMM_NAT Error({0}): Failed to set socket flags by fcntl (to set nonblocking)";
        PgmIpLayer.natErrors[15] = "RMM_NAT Error({0}): Failed to set nonclocking mode by ioctlsocket";
        PgmIpLayer.natErrors[16] = "RMM_NAT Error({0}): Failed to allocate internal receive buffer";
        PgmIpLayer.natErrors[17] = "RMM_NAT Error({0}): Address handle limit exeeded";
        PgmIpLayer.natErrors[18] = "RMM_NAT Error({0}): Failed to translate address to IP";
        PgmIpLayer.natErrors[19] = "RMM_NAT Error({0}): Failed to receive data from socket (recvfrom)";
        PgmIpLayer.natErrors[20] = "RMM_NAT Error({0}): Failed to wait for data (select)";
        PgmIpLayer.natErrors[21] = "RMM_NAT Error({0}): Failed to send data (sendto)";
        PgmIpLayer.natErrors[22] = "RMM_NAT Error({0}): Failed to join multicast group";
        PgmIpLayer.natErrors[23] = "RMM_NAT Error({0}): Failed to leave multicast group";
        PgmIpLayer.natErrors[24] = "RMM_NAT Error({0}): Failed to close socket";
        PgmIpLayer.natErrors[25] = "RMM_NAT Error({0}): Invalid socket handle";
        PgmIpLayer.natErrors[26] = "RMM_NAT Error({0}): No permission for raw sockets";
        System.loadLibrary("PgmIpLayer");
    }

    static native int natInit(int var0);

    static native int natStop();

    static native int natCreateTrIpSocket(int var0, int var1, String var2, int var3, int var4);

    static native int natCreateRecIpSocket(int var0, String var1, int var2);

    static native int natGetAddressHandle(String var0);

    static native int natSendIpPacket(int var0, int var1, byte[] var2, int var3);

    static native int natReceiveIpPacket(int var0, byte[] var1, int var2);

    static native int natJoinMcGroup(int var0, String var1, String var2);

    static native int natLeaveMcGroup(int var0, String var1, String var2);

    static native int natCloseIpSocket(int var0);

    public static synchronized PgmIpSocket createTrIpSocket(boolean mcast, int ttl, InetAddress interf, int buffer_size, int router_alert) throws IOException {
        String int_name;
        int mc = mcast ? 1 : 0;
        int handle = PgmIpLayer.natCreateTrIpSocket(mc, ttl, int_name = interf == null ? "none" : interf.getHostAddress(), buffer_size, router_alert);
        if (handle < 0) {
            Object[] args = new Object[]{"natCreateTrIpSocket"};
            throw new IOException(PgmIpLayer.getErrorMsg(-handle, args));
        }
        return new PgmIpSocket(handle, int_name);
    }

    public static synchronized PgmIpSocket createRecIpSocket(boolean mcast, InetAddress interf, int buffer_size) throws IOException {
        String int_name;
        int mc = mcast ? 1 : 0;
        int handle = PgmIpLayer.natCreateRecIpSocket(mc, int_name = interf == null ? "none" : interf.getHostAddress(), buffer_size);
        if (handle < 0) {
            Object[] args = new Object[]{"natCreateRecIpSocket"};
            throw new IOException(PgmIpLayer.getErrorMsg(-handle, args));
        }
        return new PgmIpSocket(handle, int_name);
    }

    public static synchronized int getAddressHandle(String address) throws IOException {
        int ah = PgmIpLayer.natGetAddressHandle(address);
        if (ah < 0) {
            Object[] args = new Object[]{"natGetAddressHandle"};
            throw new IOException(PgmIpLayer.getErrorMsg(-ah, args));
        }
        return ah;
    }

    public static synchronized int init(RmmLogger logger) throws IOException {
        rmmLogger = logger;
        int rc = PgmIpLayer.natInit(rmmLogger.getLogLevel());
        if (rc < 0) {
            Object[] args = new Object[]{"natInit"};
            if (-rc == 26) {
                rmmLogger.baseLog(422, new Object[0], null, moduleName);
            }
            throw new IOException(PgmIpLayer.getErrorMsg(-rc, args));
        }
        return rc;
    }

    public static synchronized int stop() {
        return PgmIpLayer.natStop();
    }

    public static String getErrorMsg(int index, Object[] args) {
        if (index >= 0 && index < natErrors.length && natErrors[index] != null) {
            return MessageFormat.format(natErrors[index], args);
        }
        return "No message for index " + index + " in the 'natErrors' message list";
    }

    public static void natLogger(int level, String msg) {
        switch (level) {
            case 0: {
                rmmLogger.baseInfo(msg, moduleName);
                break;
            }
            case 1: {
                rmmLogger.baseWarn(msg, null, moduleName);
                break;
            }
            case 2: {
                rmmLogger.baseError(msg, null, moduleName);
            }
        }
    }
}

