/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.intrn.util;

import com.ibm.rmm.intrn.util.BytePack;
import com.ibm.rmm.intrn.util.PgmIpLayer;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;

public class PgmIpSocket {
    int socketHandle;
    boolean closed;
    String interFace;

    public PgmIpSocket(int handle, String intrf) {
        this.socketHandle = handle;
        this.interFace = intrf;
        this.closed = false;
    }

    public boolean send(int address_handle, byte[] buffer, int len) throws IOException {
        int rc = PgmIpLayer.natSendIpPacket(this.socketHandle, address_handle, buffer, len);
        if (rc < 0) {
            Object[] args = new Object[]{"natSendIpPacket"};
            throw new IOException(PgmIpLayer.getErrorMsg(-rc, args));
        }
        return true;
    }

    public void joinGroup(InetAddress address) throws IOException {
        int rc = PgmIpLayer.natJoinMcGroup(this.socketHandle, address.getHostAddress(), this.interFace);
        if (rc < 0) {
            Object[] args = new Object[]{"natJoinMcGroup"};
            throw new IOException(PgmIpLayer.getErrorMsg(-rc, args));
        }
    }

    public void leaveGroup(InetAddress address) throws IOException {
        int rc = PgmIpLayer.natLeaveMcGroup(this.socketHandle, address.getHostAddress(), this.interFace);
        if (rc < 0) {
            Object[] args = new Object[]{"natLeaveMcGroup"};
            throw new IOException(PgmIpLayer.getErrorMsg(-rc, args));
        }
    }

    public void receive(BytePack bp) throws IOException {
        ByteBuffer bb = bp.getByteBuffer();
        bb.clear();
        int len = PgmIpLayer.natReceiveIpPacket(this.socketHandle, bp.getByteArray(), bp.getSize());
        if (len < 0) {
            Object[] args = new Object[]{"natReceiveIpPacket"};
            throw new IOException(PgmIpLayer.getErrorMsg(-len, args));
        }
        bb.rewind();
        bb.limit(len);
        bp.setdataLength(len);
    }

    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        int rc = PgmIpLayer.natCloseIpSocket(this.socketHandle);
        if (rc < 0) {
            Object[] args = new Object[]{"natCloseIpSocket"};
            throw new IOException(PgmIpLayer.getErrorMsg(-rc, args));
        }
    }
}

