/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.intrn.util;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

public class StreamBitSet
extends BitSet {
    static final long serialVersionUID = 1L;
    private final long MAX_VAL = 0x100000000L;
    private static final int maxIndex = 131272;
    long contSeq;
    long frontSeq;
    long tailSeq;
    int missing;
    private List losses = new ArrayList();

    public StreamBitSet(int first) {
        super(131272);
        long first_l;
        this.frontSeq = this.tailSeq = (first_l = this.translateToLong(first));
        this.contSeq = this.tailSeq;
        this.set(first_l);
    }

    public void addPacket(int seq) {
        long seq_l = this.translateToLong(seq);
        this.set(seq_l);
        long gap = this.getGap(seq_l, this.frontSeq);
        if (gap > 1L) {
            this.missing = (int)((long)this.missing + gap);
            this.incrementFrontPointers(gap);
        } else if (gap == 1L) {
            this.incrementFrontPointers(gap);
            this.checkContiguousData();
        } else {
            this.checkContiguousData();
        }
    }

    public boolean hasPacket(int seq) {
        return this.has(this.translateToLong(seq));
    }

    public void advanceFront(int new_front) {
        long gap = this.getGap(new_front, this.frontSeq);
        if (gap > 0L) {
            this.incrementFrontPointers(gap);
            this.checkContiguousData();
        }
    }

    public void advanceTail(int seq) {
        long gap = this.getGap(seq, this.tailSeq);
        if (gap < 0L) {
            throw new ArrayIndexOutOfBoundsException("Trying to clear bits prior to tailSeq " + this.tailSeq + " seq is " + seq);
        }
        this.losses.clear();
        int i = 0;
        while ((long)i < gap) {
            if (!this.has(this.tailSeq + (long)i)) {
                this.losses.add(new Integer(this.translateToInt(this.tailSeq + (long)i)));
            } else {
                this.clear(this.tailSeq + (long)i);
            }
            ++i;
        }
        this.incrementTailPointers(gap);
    }

    public List getLossList() {
        return this.losses;
    }

    public int getMissing() {
        return this.missing;
    }

    public int getFront() {
        return this.translateToInt(this.frontSeq);
    }

    public int getTail() {
        return this.translateToInt(this.tailSeq);
    }

    public int getContiguous() {
        return this.translateToInt(this.contSeq);
    }

    private long getGap(long seq, long front) {
        if (seq < 0L) {
            seq += 0x100000000L;
        }
        long gap = seq > front ? (seq - front > Integer.MAX_VALUE ? seq - front - 0x100000000L : seq - front) : (front - seq > Integer.MAX_VALUE ? seq - front + 0x100000000L : seq - front);
        if (gap > 65636L) {
            throw new UnsupportedOperationException("Can not handle such big differences between last seq num " + front + " and current seq num " + seq);
        }
        return gap;
    }

    private void checkContiguousData() {
        if (this.contSeq == this.frontSeq) {
            return;
        }
        long gap = this.getGap(this.frontSeq, this.contSeq);
        if (gap < 0L) {
            throw new ArrayIndexOutOfBoundsException("Internal error. contignuous pointer " + this.contSeq + " succeed front pointer " + this.frontSeq);
        }
        this.missing = 0;
        long last_cont = this.contSeq;
        boolean contignuous = true;
        int i = 0;
        while ((long)i < gap) {
            if (!this.has(this.contSeq + (long)i)) {
                ++this.missing;
                contignuous = false;
            }
            if (contignuous) {
                last_cont = this.contSeq + (long)i;
            }
            ++i;
        }
        this.incrementContPointers(last_cont);
    }

    private void incrementFrontPointers(long gap) {
        this.frontSeq += gap;
        this.frontSeq %= 0x100000000L;
    }

    private void incrementContPointers(long gap) {
        this.contSeq += gap;
        this.contSeq %= 0x100000000L;
    }

    private void incrementTailPointers(long gap) {
        this.tailSeq += gap;
        this.tailSeq %= 0x100000000L;
    }

    private int translateToInt(long seq) {
        return (int)(seq > Integer.MAX_VALUE ? seq - 0x100000000L : seq);
    }

    private long translateToLong(int seq) {
        return seq < 0 ? (long)seq + 0x100000000L : (long)seq;
    }

    private int getIndex(long seq) {
        return (int)(seq % 131272L);
    }

    private void set(long seq) {
        int index = this.getIndex(seq);
        super.set(index);
    }

    private boolean has(long seq) {
        int index = this.getIndex(seq);
        return super.get(index);
    }

    private void clear(long seq) {
        int index = this.getIndex(seq);
        super.clear(index);
    }
}

