/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.intrn.util;

public class StreamBitmap {
    private byte[][] bsList;
    private int listMaxSize;
    private int listSize;
    private int bsLength;
    private int offset;
    private byte[][] pool;
    private byte[] z0;
    private int poolMaxSize;
    private int poolSize;

    public StreamBitmap(int offset0, int listMaxSize0, int bsLength0) {
        this.offset = offset0;
        this.listMaxSize = listMaxSize0;
        this.bsLength = bsLength0;
        this.bsList = new byte[this.listMaxSize][];
        this.poolMaxSize = this.listMaxSize / 4;
        if (this.poolMaxSize <= 0) {
            this.poolMaxSize = 1;
        }
        this.pool = new byte[this.poolMaxSize][];
        this.z0 = new byte[this.bsLength];
    }

    public void clear(int pack_n) {
        int gap = pack_n - this.offset;
        if (gap < 0) {
            return;
        }
        int bsn = gap / this.bsLength;
        if (bsn >= this.listSize) {
            return;
        }
        int rsn = gap - bsn * this.bsLength;
        this.bsList[bsn][rsn] = 0;
    }

    public boolean has(int pack_n) {
        int gap = pack_n - this.offset;
        if (gap < 0) {
            return false;
        }
        int bsn = gap / this.bsLength;
        if (bsn >= this.listSize) {
            return false;
        }
        int rsn = gap - bsn * this.bsLength;
        if (bsn < 0 || bsn >= this.bsList.length) {
            String log = "RMM Debug: ERROR: Violate bsList size " + bsn + " " + this.bsList.length + " Thread " + Thread.currentThread().getName();
            System.out.println(log);
            System.err.println(log);
            throw new ArrayIndexOutOfBoundsException(log);
        }
        if (rsn < 0 || rsn >= this.bsList[bsn].length) {
            String log = "RMM Debug: ERROR: Violate list size " + rsn + " " + this.bsList[bsn].length + " Thread " + Thread.currentThread().getName();
            System.out.println(log);
            System.err.println(log);
            throw new ArrayIndexOutOfBoundsException(log);
        }
        return this.bsList[bsn][rsn] == 1;
    }

    public boolean set(int pack_n) {
        String log;
        int gap = pack_n - this.offset;
        if (gap < 0) {
            return false;
        }
        int bsn = gap / this.bsLength;
        if (bsn >= this.listSize) {
            if (bsn >= this.listMaxSize) {
                throw new ArrayIndexOutOfBoundsException("Exceed maximal Bitmap list size");
            }
            int to_add = bsn + 1 - this.listSize;
            int ls = this.listSize;
            int i = 0;
            while (i < to_add) {
                byte[] bs = this.poolSize > 0 ? this.pool[--this.poolSize] : new byte[this.bsLength];
                this.bsList[ls++] = bs;
                ++i;
            }
            this.listSize = ls;
        }
        int rsn = gap - bsn * this.bsLength;
        if (bsn < 0 || bsn >= this.bsList.length) {
            log = "RMM Debug: ERROR: Violate bsList size " + bsn + " " + this.bsList.length + " Thread " + Thread.currentThread().getName();
            System.out.println(log);
            System.err.println(log);
            throw new ArrayIndexOutOfBoundsException(log);
        }
        if (rsn < 0 || rsn >= this.bsList[bsn].length) {
            log = "RMM Debug: ERROR: Violate list size " + rsn + " " + this.bsList[bsn].length + " Thread " + Thread.currentThread().getName();
            System.out.println(log);
            System.err.println(log);
            throw new ArrayIndexOutOfBoundsException(log);
        }
        this.bsList[bsn][rsn] = 1;
        return true;
    }

    public void set(int start, int size) {
        int i = 0;
        while (i < size) {
            this.set(start + i);
            ++i;
        }
    }

    public boolean setTrail(int pack_n) {
        int gap = pack_n - this.offset;
        if (gap < 0) {
            return false;
        }
        int n_to_drop = gap / this.bsLength;
        if (n_to_drop == 0) {
            return true;
        }
        gap = n_to_drop > this.listSize ? this.listSize : n_to_drop;
        int i = 0;
        while (i < gap) {
            byte[] bs = this.bsList[i];
            this.bsList[i] = null;
            if (this.poolSize >= this.poolMaxSize) break;
            System.arraycopy(this.z0, 0, bs, 0, this.bsLength);
            this.pool[this.poolSize++] = bs;
            ++i;
        }
        if (n_to_drop >= this.listSize) {
            this.offset = pack_n;
            i = 0;
            while (i < this.listSize) {
                this.bsList[i] = null;
                ++i;
            }
            this.listSize = 0;
        } else {
            this.offset += n_to_drop * this.bsLength;
            i = 0;
            while (i < this.listSize - n_to_drop) {
                this.bsList[i] = this.bsList[i + n_to_drop];
                ++i;
            }
            int j = i;
            while (j < this.listSize) {
                this.bsList[j] = null;
                ++j;
            }
            this.listSize -= n_to_drop;
        }
        return true;
    }
}

