/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.intrn.util;

import com.ibm.rmm.intrn.util.PersistByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.util.Random;

public class Sutils {
    private static final Sutils myself = new Sutils();
    public static Random randomGen = new Random(System.currentTimeMillis());
    private static byte[] byteArray = new byte[1];
    private static PersistByteArrayInputStream bais = new PersistByteArrayInputStream(byteArray);
    private static DataInputStream dis = new DataInputStream(bais);
    private static ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private static DataOutputStream dos = new DataOutputStream(baos);

    public static synchronized byte[] intToByteArray(int in) throws IOException {
        baos.reset();
        dos.writeInt(in);
        return baos.toByteArray();
    }

    public static synchronized byte[] shortToByteArray(short in) throws IOException {
        baos.reset();
        dos.writeShort(in);
        return baos.toByteArray();
    }

    public static synchronized int byteArrayToInt(byte[] ba) throws IOException {
        bais.setBuffer(ba);
        return dis.readInt();
    }

    public static synchronized int byteArrayToShort(byte[] ba) throws IOException {
        bais.setBuffer(ba);
        return dis.readShort();
    }

    public static synchronized byte[] longToByteArray(long in) throws IOException {
        baos.reset();
        dos.writeLong(in);
        return baos.toByteArray();
    }

    public static synchronized long byteArrayToLong(byte[] ba) throws IOException {
        bais.setBuffer(ba);
        return dis.readLong();
    }

    public static synchronized int parseInt1(byte[] b, int pos) {
        bais.setBuffer(b);
        try {
            long skipped = bais.skip(pos);
            if (skipped != (long)pos) {
                while (skipped < (long)pos) {
                    ++skipped;
                    bais.read();
                }
            }
            return dis.readInt();
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return -1;
        }
    }

    public static boolean compareByteArrays(byte[] tag1, byte[] tag2) {
        if (tag1.length != tag2.length) {
            return false;
        }
        int i = 0;
        while (i < tag1.length) {
            if (tag1[i] != tag2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void insertShort(byte[] buff, int pos, short val) {
        buff[pos + 1] = (byte)val;
        buff[pos] = (byte)(val >> 8);
    }

    public static void insertInt(byte[] buff, int pos, int val) {
        buff[pos + 3] = (byte)val;
        buff[pos + 2] = (byte)(val >> 8);
        buff[pos + 1] = (byte)(val >> 16);
        buff[pos] = (byte)(val >> 24);
    }

    public static void insertLong(byte[] buff, int pos, long val) {
        buff[pos + 7] = (byte)val;
        buff[pos + 6] = (byte)(val >> 8);
        buff[pos + 5] = (byte)(val >> 16);
        buff[pos + 4] = (byte)(val >> 24);
        buff[pos + 3] = (byte)(val >> 32);
        buff[pos + 2] = (byte)(val >> 40);
        buff[pos + 1] = (byte)(val >> 48);
        buff[pos] = (byte)(val >> 56);
    }

    public static byte[] stringToTag(String topic) throws UnsupportedEncodingException {
        return Sutils.stringToBytes(topic);
    }

    public static byte[] stringToBytes(String s) throws UnsupportedEncodingException {
        return s.getBytes("UTF-8");
    }

    public static String bytesToString(byte[] ba, int len) throws UnsupportedEncodingException {
        return new String(ba, 0, len, "UTF-8");
    }

    public static String bytesToString(byte[] ba) throws UnsupportedEncodingException {
        return Sutils.bytesToString(ba, ba.length);
    }

    public static String pb(byte[] b) {
        return Sutils.pb(b, b.length);
    }

    public static String pb(byte[] b, int length) {
        length = Math.min(length, b.length);
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < length) {
            sb.append(":" + b[i]);
            ++i;
        }
        return sb.toString();
    }

    public static String printIsa(InetSocketAddress addr) {
        if (addr == null) {
            return "null";
        }
        return addr.getAddress().getHostAddress() + ":" + addr.getPort();
    }

    public static String toPrintableString(String inStr) {
        try {
            String str = inStr;
            char[] chars = str.toCharArray();
            int i = 0;
            while (i < chars.length) {
                if (Character.isISOControl(chars[i])) {
                    chars[i] = 63;
                }
                ++i;
            }
            return new String(chars);
        }
        catch (Throwable e2) {
            return inStr;
        }
    }

    public Sutils getSutils() {
        return myself;
    }
}

