/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.intrn.util;

import com.ibm.rmm.intrn.util.Clock;
import com.ibm.rmm.intrn.util.TaskIf;

public class TaskManager
extends Thread {
    private long NOMINAL_SLEEP = 10L;
    private boolean listUpdated = false;
    private boolean goOn = true;
    private boolean running = false;
    private Object myLock = new Object();
    private int curSize = 0;
    private int maxSize = 16;
    private TaskIf[] taskList = new TaskIf[this.maxSize];

    public TaskManager() {
        this(10);
    }

    public TaskManager(int nominal_sleep) {
        this.NOMINAL_SLEEP = this.minmax(nominal_sleep, 1, 10000);
        this.setDaemon(true);
        this.setName("Rmm_TaskManager");
        this.setPriority(10);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(TaskIf task) {
        if (task == null) {
            return;
        }
        Object object = this.myLock;
        synchronized (object) {
            int i = this.findTask(task);
            if (i < 0) {
                if (this.curSize >= this.maxSize) {
                    TaskIf[] old = this.taskList;
                    this.maxSize = (this.maxSize + 64) / 64 * 64;
                    this.taskList = new TaskIf[this.maxSize];
                    System.arraycopy(old, 0, this.taskList, 0, this.curSize);
                }
                this.taskList[this.curSize++] = task;
                this.listUpdated = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTask(TaskIf task) {
        if (task == null) {
            return;
        }
        Object object = this.myLock;
        synchronized (object) {
            int i = this.findTask(task);
            if (i >= 0) {
                this.taskList[i] = this.taskList[--this.curSize];
                this.taskList[this.curSize] = null;
                this.listUpdated = true;
            }
        }
    }

    private int findTask(TaskIf task) {
        int i = this.curSize - 1;
        while (i >= 0) {
            if (this.taskList[i] == task) break;
            --i;
        }
        return i;
    }

    public void close() {
        this.interrupt();
    }

    public void interrupt() {
        this.goOn = false;
        super.interrupt();
    }

    public boolean isRunning() {
        return this.running;
    }

    public long nominalSleep() {
        return this.NOMINAL_SLEEP;
    }

    private int minmax(int v, int mn, int mx) {
        if (v < mn) {
            return mn;
        }
        if (v > mx) {
            return mx;
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        long myTime;
        int actTime;
        long sysTime1;
        long sysTime0;
        int ntasks = 0;
        TaskIf[] tasks = null;
        if (this.NOMINAL_SLEEP < 100L) {
            sysTime0 = System.currentTimeMillis();
            int i = 0;
            while (i < 10) {
                try {
                    TaskManager.sleep(this.NOMINAL_SLEEP);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++i;
            }
            sysTime1 = System.currentTimeMillis();
            actTime = (int)(sysTime1 - sysTime0) / 10;
            actTime = this.minmax(actTime, (int)this.NOMINAL_SLEEP, (int)Math.max(this.NOMINAL_SLEEP * 5L, this.NOMINAL_SLEEP + 20L));
        } else {
            actTime = (int)this.NOMINAL_SLEEP;
        }
        int syncFreq = (int)Math.max(10L, 1000L / this.NOMINAL_SLEEP);
        int syncTime = syncFreq * actTime;
        int minSyncT = (int)((long)syncFreq * this.NOMINAL_SLEEP);
        long lastTime = myTime = (sysTime0 = System.currentTimeMillis());
        int counter = 0;
        this.running = true;
        while (this.goOn) {
            try {
                TaskManager.sleep(this.NOMINAL_SLEEP);
                myTime = lastTime + (long)(++counter * syncTime / syncFreq);
                Clock.setTime(myTime);
                if (counter >= syncFreq) {
                    sysTime1 = System.currentTimeMillis();
                    actTime = (int)(sysTime1 - sysTime0);
                    actTime = this.minmax(actTime, 3 * syncTime / 4, 5 * syncTime / 4);
                    actTime = Math.max(actTime, minSyncT);
                    syncTime = actTime = (3 * actTime + 5 * syncTime) / 8;
                    lastTime = myTime;
                    sysTime0 = sysTime1;
                    counter = 0;
                }
                Object i = this.myLock;
                synchronized (i) {
                    if (this.listUpdated) {
                        this.listUpdated = false;
                        if (tasks == null || tasks.length < this.curSize) {
                            tasks = new TaskIf[this.maxSize];
                        }
                        System.arraycopy(this.taskList, 0, tasks, 0, this.curSize);
                        ntasks = this.curSize;
                    }
                }
                int i2 = 0;
                while (i2 < ntasks) {
                    if (myTime >= tasks[i2].getNextTime()) {
                        try {
                            tasks[i2].timerExpired(myTime);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    ++i2;
                }
            }
            catch (Throwable ex) {
                if (this.isInterrupted() || ex instanceof InterruptedException) break;
            }
        }
        this.running = false;
    }
}

