/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.intrn.util;

import com.ibm.rmm.intrn.util.Clock;
import com.ibm.rmm.intrn.util.TaskIf;
import com.ibm.rmm.intrn.util.TaskManager;
import com.ibm.rmm.util.RmmLogger;

public class TokenBucket
implements TaskIf {
    private static final String mn = "Utils";
    private RmmLogger rmmLogger;
    private TaskManager taskMan;
    private final long interval;
    private long token = 0L;
    private long reqRate;
    private long bucketSize = 1L;
    private long creditSize;
    private long fullSize;
    private long remainder;
    private long last_time;
    private long next_time;
    private long diff_time;
    private int nWait;
    private boolean active;

    public TokenBucket(int rate_kbps, RmmLogger rlog, TaskManager tman) {
        this.rmmLogger = rlog;
        this.taskMan = tman;
        this.interval = this.taskMan.nominalSleep();
        this.setRate(rate_kbps);
        this.next_time = 0L;
        this.taskMan.addTask(this);
        this.active = true;
    }

    public synchronized void setRate(int rate_kbps) {
        if (rate_kbps < 1) {
            rate_kbps = 1;
        }
        this.reqRate = rate_kbps * 128;
        this.bucketSize = this.reqRate * this.interval / 1000L;
        if (this.bucketSize < 1L) {
            this.bucketSize = 1L;
        }
        this.creditSize = 2L * this.bucketSize;
        this.fullSize = 4L * this.bucketSize;
        this.last_time = Clock.getTime();
    }

    public synchronized void stop() {
        if (this.active) {
            this.active = false;
            this.taskMan.removeTask(this);
        }
    }

    public long getNextTime() {
        return this.next_time;
    }

    public synchronized void timerExpired(long curTime) {
        this.next_time = curTime + this.interval;
        if (this.token < this.fullSize) {
            this.diff_time = curTime - this.last_time;
            this.last_time = curTime;
            long persec = this.reqRate * this.diff_time + this.remainder;
            long addtoken = persec / 1000L;
            this.remainder = persec - 1000L * addtoken;
            this.token += addtoken;
            if (this.token > this.fullSize) {
                this.token = this.fullSize;
            }
        }
        if (this.nWait > 0) {
            this.notifyAll();
        }
    }

    public synchronized boolean getToken(int bytes, boolean wait, boolean credit, boolean commit) throws InterruptedException {
        if (!this.active) {
            return true;
        }
        if (this.token >= (long)bytes || credit && this.token + this.creditSize >= (long)bytes) {
            this.token -= (long)bytes;
            return true;
        }
        if (commit) {
            this.token -= (long)bytes;
            return false;
        }
        if (!wait) {
            return false;
        }
        long add = credit ? this.creditSize : 0L;
        this.token -= (long)bytes;
        while (this.token + add < 0L) {
            ++this.nWait;
            this.wait();
            --this.nWait;
        }
        return true;
    }

    public boolean hasToken() throws InterruptedException {
        return this.getToken(0, false, false, false);
    }

    public boolean hasCreditToken() throws InterruptedException {
        return this.getToken(0, false, true, false);
    }

    public boolean commitToken(int bytes) throws InterruptedException {
        return this.getToken(bytes, false, false, true);
    }

    public boolean waitForToken(int bytes) throws InterruptedException {
        return this.getToken(bytes, true, false, false);
    }

    public boolean waitForCreditToken(int bytes) throws InterruptedException {
        return this.getToken(bytes, true, true, false);
    }

    public String toString() {
        return "TokenBacket rate=" + this.reqRate / 128L + " Kbps" + " current tokens " + this.token + " bucket size " + this.bucketSize + " bytes.";
    }
}

