/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.jniwrapper;

import com.ibm.rmm.jniwrapper.JniSourceSelector;
import com.ibm.rmm.jniwrapper.JniStreamSetR;
import com.ibm.rmm.jniwrapper.JniTopicR;
import com.ibm.rmm.mtl.receiver.MReceiver;
import com.ibm.rmm.mtl.receiver.MStreamSetR;
import com.ibm.rmm.mtl.receiver.MTopicR;
import com.ibm.rmm.util.RmmLogger;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;

public class JniReceiver {
    private static List topicHandles;
    private static JniReceiver instance;
    private static MReceiver mReceiver;
    private static RmmLogger rmmLogger;

    public static synchronized JniReceiver getInstance() {
        try {
            if (instance != null) {
                return instance;
            }
            topicHandles = new ArrayList();
            mReceiver = MReceiver.getInstance();
            rmmLogger = JniReceiver.mReceiver.rmmLogger;
            instance = new JniReceiver();
            return instance;
        }
        catch (Throwable ex) {
            rmmLogger.baseError("Exception caught in API call", ex, "JNIWRAP");
            return null;
        }
    }

    public synchronized int createTopicReceiver(String topic, boolean reliable, boolean ordered) {
        try {
            MTopicR t = mReceiver.createTopicReceiver(topic, reliable, ordered);
            if (t == null) {
                return -1;
            }
            int id = this.getNewId();
            if (id >= 0) {
                topicHandles.set(this.getIndex(id), new JniTopicR(t, id));
            }
            return id;
        }
        catch (Throwable ex) {
            rmmLogger.baseError("Exception caught in API call", ex, "JNIWRAP");
            return -1;
        }
    }

    public synchronized int createSourceTopicReceiver(String source, String topic, boolean reliable, boolean ordered) {
        try {
            InetAddress addr = InetAddress.getByName(source);
            JniSourceSelector selector = new JniSourceSelector(addr, topic);
            MStreamSetR t = mReceiver.createStreamSetReceiver(selector, reliable, ordered);
            if (t == null) {
                return -1;
            }
            int id = this.getNewId();
            if (id >= 0) {
                topicHandles.set(this.getIndex(id), new JniStreamSetR(t, id));
            }
            return id;
        }
        catch (Throwable ex) {
            rmmLogger.baseError("Exception caught in API call", ex, "JNIWRAP");
            return -1;
        }
    }

    public synchronized int closeTopicReceiver(int id) {
        try {
            int index = this.getIndex(id);
            if (index > topicHandles.size()) {
                rmmLogger.baseError("No such channel", null, "JNIWRAP");
                return -2;
            }
            if (topicHandles.get(index) == null) {
                rmmLogger.baseWarn("Channel already closed", null, "JNIWRAP");
                return -3;
            }
            JniStreamSetR stream = (JniStreamSetR)topicHandles.get(index);
            topicHandles.set(index, null);
            stream.close();
            return 0;
        }
        catch (Throwable ex) {
            rmmLogger.baseError("Exception caught in API call", ex, "JNIWRAP");
            return -1;
        }
    }

    public static String eventDescription(int event_type) {
        try {
            return MReceiver.eventDescription(event_type);
        }
        catch (Throwable ex) {
            rmmLogger.baseError("Exception caught in API call", ex, "JNIWRAP");
            return null;
        }
    }

    public synchronized int stop() {
        try {
            mReceiver.stop();
            instance = null;
            return 0;
        }
        catch (Throwable ex) {
            rmmLogger.baseError("Exception caught in API call", ex, "JNIWRAP");
            return -1;
        }
    }

    public String getVersion() {
        try {
            return mReceiver.getVersion();
        }
        catch (Throwable ex) {
            rmmLogger.baseError("Exception caught in API call", ex, "JNIWRAP");
            return null;
        }
    }

    public synchronized int joinMulticastGroup(String address) {
        try {
            return mReceiver.joinMulticastGroup(address, -1, true) ? 0 : -1;
        }
        catch (Throwable ex) {
            rmmLogger.baseError("Exception caught in API call", ex, "JNIWRAP");
            return -1;
        }
    }

    public synchronized int leaveMulticastGroup(String address) {
        try {
            return mReceiver.leaveMulticastGroup(address, -1, true) ? 0 : -1;
        }
        catch (Throwable ex) {
            rmmLogger.baseError("Exception caught in API call", ex, "JNIWRAP");
            return -1;
        }
    }

    private int getNewId() {
        return topicHandles.size();
    }

    private int getIndex(int id) {
        if (id == topicHandles.size()) {
            topicHandles.add(null);
        }
        return id;
    }
}

