/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.jniwrapper;

import com.ibm.rmm.jniwrapper.JniTopicT;
import com.ibm.rmm.mtl.transmitter.MTopicT;
import com.ibm.rmm.mtl.transmitter.MTransmitter;
import com.ibm.rmm.util.RmmLogger;
import java.util.ArrayList;
import java.util.List;

public class JniTransmitter {
    private static List topicHandles;
    private static MTransmitter mrmTransmitter;
    private static JniTransmitter instance;
    private static RmmLogger rmmLogger;

    public static synchronized JniTransmitter getInstance() {
        try {
            if (instance != null) {
                return instance;
            }
            topicHandles = new ArrayList();
            mrmTransmitter = MTransmitter.getInstance();
            rmmLogger = JniTransmitter.mrmTransmitter.rmmLogger;
            instance = new JniTransmitter();
            return instance;
        }
        catch (Throwable ex) {
            rmmLogger.baseError("Exception caught in API call", ex, "MTL");
            return null;
        }
    }

    public synchronized int createTopicTransmitter(String tag, boolean reliable, String address) {
        try {
            MTopicT t = mrmTransmitter.createTopicTransmitter(tag, reliable, address);
            if (t == null) {
                return -1;
            }
            int id = this.getNewId();
            if (id >= 0) {
                topicHandles.set(this.getIndex(id), new JniTopicT(t));
            }
            return id;
        }
        catch (Throwable ex) {
            rmmLogger.baseError("Exception caught in API call", ex, "MTL");
            return -1;
        }
    }

    public synchronized int sendMessage(int id, byte[] msg, int offset, int msg_len) {
        try {
            int index = this.getIndex(id);
            JniTopicT t = this.getTopicByHandle(index);
            if (t == null) {
                return -2;
            }
            t.submitMessage(msg, offset, msg_len);
            return 0;
        }
        catch (Throwable ex) {
            rmmLogger.baseError("Exception caught in API call", ex, "MTL");
            return -1;
        }
    }

    public synchronized int closeTopicTransmitter(int id) {
        try {
            int index = this.getIndex(id);
            if (index > topicHandles.size()) {
                rmmLogger.baseError("No such channel", null, "JNIWRAP");
                return -2;
            }
            if (topicHandles.get(index) == null) {
                rmmLogger.baseWarn("Channel already closed", null, "JNIWRAP");
                return -3;
            }
            JniTopicT topic = (JniTopicT)topicHandles.get(index);
            topicHandles.set(index, null);
            topic.close();
            return 0;
        }
        catch (Throwable ex) {
            rmmLogger.baseError("Exception caught in API call", ex, "JNIWRAP");
            return -1;
        }
    }

    public String getVersion() {
        try {
            return mrmTransmitter.getVersion();
        }
        catch (Throwable ex) {
            rmmLogger.baseError("Exception caught in API call", ex, "MTL");
            return null;
        }
    }

    public synchronized int stop() {
        try {
            mrmTransmitter.stop(true);
            instance = null;
            return 0;
        }
        catch (Throwable ex) {
            rmmLogger.baseError("Exception caught in API call", ex, "MTL");
            return -1;
        }
    }

    private JniTopicT getTopicByHandle(int handle) {
        return (JniTopicT)topicHandles.get(handle);
    }

    private int getNewId() {
        return topicHandles.size();
    }

    private int getIndex(int id) {
        if (id == topicHandles.size()) {
            topicHandles.add(null);
        }
        return id;
    }
}

