/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.mtl.admin;

import com.ibm.rmm.admin.CatalogMappingStrategy;
import com.ibm.rmm.admin.RMAdmin;
import com.ibm.rmm.ifc.channel.ChannelIf;
import com.ibm.rmm.ifc.channel.ReportIf;
import com.ibm.rmm.ifc.channel.ReportListenerIf;
import com.ibm.rmm.intrn.util.TaskManager;
import com.ibm.rmm.mtl.admin.AdminLJTopicR;
import com.ibm.rmm.mtl.admin.AdminLJTopicT;
import com.ibm.rmm.mtl.admin.AdminTopic;
import com.ibm.rmm.mtl.admin.AdminTopicR;
import com.ibm.rmm.mtl.admin.AdminTopicT;
import com.ibm.rmm.mtl.admin.CatalogT;
import com.ibm.rmm.mtl.admin.ConfirmTopicInterest;
import com.ibm.rmm.mtl.receiver.MReceiver;
import com.ibm.rmm.mtl.receiver.MTopicR;
import com.ibm.rmm.mtl.transmitter.MLJETopicT;
import com.ibm.rmm.mtl.transmitter.MTopicT;
import com.ibm.rmm.mtl.transmitter.MTransmitter;
import com.ibm.rmm.ptl.admin.AdminInfoReport;
import com.ibm.rmm.ptl.admin.AdminNode;
import com.ibm.rmm.ptl.admin.Report;
import com.ibm.rmm.ptl.admin.ReportDispatcher;
import com.ibm.rmm.ptl.admin.ReportFactory;
import com.ibm.rmm.ptl.admin.ReportListener;
import com.ibm.rmm.ptl.admin.Reporter;
import com.ibm.rmm.util.RmmAddress;
import com.ibm.rmm.util.RmmAddressIf;
import com.ibm.rmm.util.RmmLogger;
import java.util.List;
import java.util.Map;

public class AdminClient
implements RMAdmin {
    private static final String mn = "Admin";
    protected static AdminClient myself;
    protected MTransmitter rmt;
    protected MReceiver rmr;
    protected AdminLJTopicR adminLJTopicR;
    protected AdminLJTopicT adminLJTopicT;
    protected AdminTopicR adminTopicR;
    protected AdminTopicT adminTopicT;
    protected AdminNode adminNode;
    protected ConfirmTopicInterest cti;
    protected ChannelIf externalChannel;
    private ReportDispatcher externalReportDispatcher;
    public static RmmLogger rmmLogger;
    public static RmmAddress rmmAddress;
    public static TaskManager taskManR;
    public static TaskManager taskManT;

    protected AdminClient() {
    }

    private static void init() {
        if (myself == null) {
            myself = new AdminClient();
            AdminClient.myself.adminNode = AdminNode.getInstance();
        }
    }

    public static AdminClient getInstance() {
        AdminClient.init();
        return myself;
    }

    public static AdminClient getInstance(MTransmitter t) {
        AdminClient.init();
        rmmLogger = t.rmmLogger;
        rmmAddress = t.rmmAddress;
        taskManT = t.taskMan;
        if (AdminClient.myself.rmt != null) {
            rmmLogger.baseWarn("MTransmitter already set at the admin client", null, mn);
        }
        AdminClient.myself.rmt = t;
        return myself;
    }

    public static AdminClient getInstance(MReceiver r) {
        AdminClient.init();
        rmmLogger = r.rmmLogger;
        rmmAddress = r.rmmAddress;
        taskManR = r.taskMan;
        if (AdminClient.myself.rmr != null) {
            rmmLogger.baseWarn("MReceiver already set at the admin client", null, mn);
        }
        AdminClient.myself.rmr = r;
        return myself;
    }

    public void stop() {
        if (this.adminTopicR != null) {
            this.adminTopicR.stop();
        }
        this.adminNode.stop();
    }

    public void confirmTopicInterest() {
        if (this.cti == null) {
            this.cti = new ConfirmTopicInterest();
        }
    }

    public void connectTcpChannel(ChannelIf tcp) {
        this.externalChannel = tcp;
        Reporter.setExternalChannel(this.externalChannel);
        this.externalReportDispatcher = new ReportDispatcher();
        this.externalChannel.addReportListener(this.getExternalReportListener());
    }

    public void setCatalogMappingStrategy(CatalogMappingStrategy cms) {
        CatalogT.setMappingStrategy(cms);
    }

    public void enableCatalog() {
        this.adminNode.enableCatalog(true);
        if (this.adminLJTopicR != null) {
            this.adminLJTopicR.createCatalog();
        }
        if (this.adminLJTopicT != null) {
            this.adminLJTopicT.createCatalog();
            this.adminLJTopicT.submitMessage();
        }
    }

    public boolean isCatalogEnabled() {
        return this.adminNode.isCatalogEnabled();
    }

    public void enableJmxSupport() {
        this.adminNode.setJmxSupport(true);
    }

    public void setAdminGroup(String group) {
        AdminTopic.setAdminGroup(group);
    }

    public String getAdminGroup() {
        return AdminTopic.getAdminGroup();
    }

    Map getTopicListT() {
        if (this.rmt == null) {
            rmmLogger.baseError("AdminCenter.getTopicListT internal error RMTransmitter is null. Can not return topic list", null, mn);
            return null;
        }
        return this.rmt.getTopicList();
    }

    List getTopicListR() {
        return this.rmr.getTopicList();
    }

    private void createAdminTopicR() {
        this.rmr.joinMulticastGroup(AdminTopic.MC_ADDRESS, -1, true);
        if (this.adminTopicR == null) {
            MTopicR topicR = this.rmr.createTopicReceiver("RMM:ADMIN", true, false);
            this.adminTopicR = new AdminTopicR(topicR);
            this.adminTopicR.start();
        }
        if (this.adminLJTopicR == null) {
            MTopicR ljTopicR = this.rmr.createTopicReceiver("RMM:LJADMIN", true, false);
            this.adminLJTopicR = new AdminLJTopicR(ljTopicR, this);
            ReportListener l = new ReportListener(){

                public void onReport(Report report, Reporter reporter) {
                    AdminInfoReport adminInfoReport;
                    try {
                        adminInfoReport = (AdminInfoReport)report;
                    }
                    catch (ClassCastException e2) {
                        rmmLogger.baseError("Internal error - Failed to downcast report to AdminInfoReport", e2, AdminClient.mn);
                        return;
                    }
                    adminInfoReport.getProperty("NAME");
                }
            };
            this.adminLJTopicR.addReportListener(l, 5);
            this.adminLJTopicR.start();
        }
    }

    AdminTopicR getAdminTopicR() {
        if (this.adminTopicR == null) {
            this.createAdminTopicR();
        }
        return this.adminTopicR;
    }

    AdminTopicR getAdminLJTopicR() {
        if (this.adminLJTopicR == null) {
            this.createAdminTopicR();
        }
        return this.adminLJTopicR;
    }

    private void createAdminTopicT() {
        MTopicT topicT;
        if (this.adminTopicT == null) {
            topicT = this.rmt.createTopicTransmitter("RMM:ADMIN", true, AdminTopicT.MC_ADDRESS);
            this.adminTopicT = new AdminTopicT(topicT);
        }
        if (this.adminLJTopicT == null) {
            topicT = this.rmt.createLJETopicTransmitter("RMM:LJADMIN", AdminTopicT.MC_ADDRESS);
            this.adminLJTopicT = new AdminLJTopicT((MLJETopicT)topicT, this);
        }
    }

    AdminTopicT getAdminTopicT() {
        if (this.adminTopicT == null) {
            this.createAdminTopicT();
        }
        return this.adminTopicT;
    }

    void addReportListener(ReportListener listener, int report_type) {
        if (this.externalChannel != null) {
            this.externalReportDispatcher.addReportListener(listener, report_type);
        }
        this.adminNode.addReportListener(listener, report_type);
    }

    void removeReportListener(ReportListener listener, int report_type) {
        this.adminNode.removeReportListener(listener, report_type);
        if (this.externalChannel != null) {
            this.externalReportDispatcher.removeReportListener(listener, report_type);
        }
    }

    private ReportListenerIf getExternalReportListener() {
        return new ReportListenerIf(){

            public void onReport(ReportIf reportIf, RmmAddressIf addressIf) {
                Reporter reporter = Reporter.getReporter(addressIf, true);
                try {
                    AdminClient.this.externalReportDispatcher.reportReceived(ReportFactory.buildReport(reportIf.getData(), 0), reporter);
                }
                catch (Exception e2) {
                    rmmLogger.baseError("Can not parse and dispatch report", e2, AdminClient.mn);
                }
            }
        };
    }
}

