/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.mtl.admin;

import com.ibm.rmm.mtl.admin.AdminClient;
import com.ibm.rmm.mtl.admin.AdminTopicT;
import com.ibm.rmm.mtl.admin.CatalogT;
import com.ibm.rmm.mtl.transmitter.MLJETopicT;
import com.ibm.rmm.ptl.admin.ReportFactory;
import java.util.Properties;

public class AdminLJTopicT
extends AdminTopicT {
    private MLJETopicT topicT;
    private Properties adminState;
    private CatalogT catalogT;

    AdminLJTopicT(MLJETopicT topicT, Properties p, AdminClient parent2) {
        super(topicT);
        this.topicT = topicT;
        this.adminState = p;
        if (parent2.isCatalogEnabled()) {
            this.createCatalog();
        }
        this.submitMessage();
    }

    AdminLJTopicT(MLJETopicT topicT, AdminClient parent2) {
        this(topicT, new Properties(), parent2);
    }

    void createCatalog() {
        if (this.catalogT == null) {
            this.catalogT = new CatalogT(STATE_NAME, STATE_ADDRESS, EVENT_NAME, EVENT_ADDRESS);
            this.adminState.put("STATE_NAME", STATE_NAME);
            this.adminState.put("STATE_ADDRESS", STATE_ADDRESS);
            this.adminState.put("STATE_ID", "" + this.catalogT.getStateId());
            this.adminState.put("EVENT_NAME", EVENT_NAME);
            this.adminState.put("EVENT_ADDRESS", EVENT_ADDRESS);
            this.adminState.put("EVENT_ID", "" + this.catalogT.getEventId());
        }
    }

    void addInfo(String key, String value2) {
        this.adminState.setProperty(key, value2);
        this.submitMessage();
    }

    void submitMessage() {
        if (AdminClient.rmmLogger.isMaxLogLevel()) {
            AdminClient.rmmLogger.maxInfo("Send message over admin topic " + this.adminState, "Admin");
        }
        this.topicT.submitRetainedMessage(ReportFactory.generateAdminInfoReport(this.adminState));
    }
}

