/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.mtl.admin;

import com.ibm.rmm.intrn.util.Sutils;
import com.ibm.rmm.mtl.admin.AdminClient;
import com.ibm.rmm.mtl.admin.AdminTopic;
import com.ibm.rmm.mtl.receiver.MTopicR;
import com.ibm.rmm.ptl.admin.DataStreamR;
import com.ibm.rmm.ptl.admin.Report;
import com.ibm.rmm.ptl.admin.ReportFactory;
import com.ibm.rmm.ptl.admin.ReportListener;
import com.ibm.rmm.ptl.admin.Reporter;
import com.ibm.rmm.receiver.AdvancedMessageListener;
import com.ibm.rmm.receiver.Event;
import com.ibm.rmm.receiver.Message;
import com.ibm.rmm.util.RmmAddressIf;
import java.io.UnsupportedEncodingException;

class AdminTopicR
extends AdminTopic
implements AdvancedMessageListener,
ReportListener {
    protected static final String mn = "Admin";
    protected MTopicR topicR;
    protected byte[] tag;

    AdminTopicR(MTopicR topicR) {
        this.topicR = topicR;
        try {
            this.tag = Sutils.stringToBytes(topicR.getTopicName());
        }
        catch (UnsupportedEncodingException e2) {
            AdminClient.rmmLogger.baseLog(411, new Object[]{"UTF-8"}, e2, mn);
        }
    }

    void start() {
        this.topicR.setAdvancedMessageListener(this);
    }

    void stop() {
        this.topicR.close();
    }

    MTopicR getTopicR() {
        return this.topicR;
    }

    public void addReportListener(ReportListener listener, int report_type) {
        this.reportDispatcher.addReportListener(listener, report_type);
    }

    public void removeReportListener(ReportListener listener, int report_type) {
        this.reportDispatcher.removeReportListener(listener, report_type);
    }

    public void onReport(Report report, Reporter reporter) {
        this.reportDispatcher.reportReceived(report, reporter);
    }

    public void onEvent(Event ev) {
        DataStreamR dataStreamR;
        AdminClient.rmmLogger.baseInfo(String.valueOf(this.toString()) + ".onEvent " + ev.getDescription() + " from " + ev.getSourceAddress() + ":" + ev.getSourcePort(), mn);
        if (ev.getType() == 10 && (dataStreamR = DataStreamR.getDataStream(this.tag, ev.getSourceAddress(), ev.getSourcePort())) != null) {
            dataStreamR.addReportListener(this, 1);
        }
        if (ev.getType() != 5) {
            ev.getType();
        }
    }

    public void onMessage(Message message) {
        byte[] msg = message.getData();
        Reporter reporter = Reporter.getReporter(message.sourceAddress, message.getSourcePort(), true);
        Report report = ReportFactory.buildReport(msg, 0);
        this.reportDispatcher.reportReceived(report, reporter);
    }

    void sendReport(byte[] msg, RmmAddressIf dest, boolean unicast, boolean multicast) {
        DataStreamR dataStreamR = DataStreamR.getDataStream(this.tag, dest);
        if (dataStreamR != null) {
            dataStreamR.sendReportPacket(msg, unicast, multicast);
        }
    }
}

