/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.mtl.admin;

import com.ibm.rmm.intrn.util.Sutils;
import com.ibm.rmm.mtl.admin.AdminClient;
import com.ibm.rmm.mtl.admin.AdminTopic;
import com.ibm.rmm.mtl.transmitter.MTopicT;
import com.ibm.rmm.ptl.admin.DataStreamT;
import com.ibm.rmm.ptl.admin.Report;
import com.ibm.rmm.ptl.admin.ReportListener;
import com.ibm.rmm.ptl.admin.Reporter;
import java.io.UnsupportedEncodingException;

public class AdminTopicT
extends AdminTopic
implements ReportListener {
    protected static final String mn = "Admin";
    protected final MTopicT topicT;
    protected final DataStreamT dataStream;

    AdminTopicT(MTopicT topicT) {
        DataStreamT tmp;
        this.topicT = topicT;
        try {
            tmp = DataStreamT.getDataStream(Sutils.stringToTag(topicT.getTopicName()));
        }
        catch (UnsupportedEncodingException e2) {
            AdminClient.rmmLogger.baseError("Can not find stream for topic " + topicT.getTopicName(), e2, mn);
            AdminClient.rmmLogger.baseLog(411, new Object[]{"UTF-8"}, e2, mn);
            tmp = null;
        }
        this.dataStream = tmp;
    }

    MTopicT getTopicT() {
        return this.topicT;
    }

    public void addReportListener(ReportListener listener, int report_type) {
        this.reportDispatcher.addReportListener(listener, report_type);
        this.dataStream.addReportListener(this, report_type);
    }

    public void removeReportListener(ReportListener listener, int report_type) {
        this.reportDispatcher.removeReportListener(listener, report_type);
        this.dataStream.removeReportListener(this, report_type);
    }

    public void onReport(Report report, Reporter reporter) {
        this.reportDispatcher.reportReceived(report, reporter);
    }

    void submitMessage(byte[] msg) {
        if (AdminClient.rmmLogger.isMaxLogLevel()) {
            AdminClient.rmmLogger.maxInfo("Send message over admin topic " + Sutils.pb(msg), mn);
        }
        this.topicT.submitMessage(msg);
    }
}

