/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.mtl.admin;

import com.ibm.rmm.intrn.util.Sutils;
import com.ibm.rmm.mtl.admin.AdminClient;
import com.ibm.rmm.mtl.admin.CatalogStateR;
import com.ibm.rmm.mtl.receiver.MReceiver;
import com.ibm.rmm.mtl.receiver.MStreamSetR;
import com.ibm.rmm.ptl.admin.CatalogBook;
import com.ibm.rmm.ptl.admin.CatalogEntry;
import com.ibm.rmm.ptl.admin.CatalogEventReport;
import com.ibm.rmm.ptl.admin.ReportFactory;
import com.ibm.rmm.ptl.admin.Reporter;
import com.ibm.rmm.receiver.AdvancedMessageListener;
import com.ibm.rmm.receiver.Event;
import com.ibm.rmm.receiver.Message;
import com.ibm.rmm.receiver.StreamSelector;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CatalogEventR
implements AdvancedMessageListener {
    private static final String mn = "Admin";
    private static MStreamSetR eventStreams;
    private static Set eventNames;
    private static Map eventReporters;
    private static StreamSelector selector;

    CatalogEventR() {
        eventNames = Collections.synchronizedSet(new HashSet());
        eventReporters = Collections.synchronizedMap(new HashMap());
        selector = this.createStreamSelector();
        eventStreams = MReceiver.getInstance().createStreamSetReceiver(selector, true, true);
        eventStreams.setAdvancedMessageListener(this);
    }

    private StreamSelector createStreamSelector() {
        StreamSelector selector = new StreamSelector(){

            public boolean acceptStream(byte[] tag_buffer, int tag_length, long stream_id, InetAddress source_address, int source_port) {
                String tag = null;
                try {
                    tag = Sutils.bytesToString(tag_buffer, tag_length);
                }
                catch (UnsupportedEncodingException e2) {
                    AdminClient.rmmLogger.baseError("Failed to convert topic name", e2, CatalogEventR.mn);
                    AdminClient.rmmLogger.baseLog(411, new Object[]{"UTF-8"}, e2, CatalogEventR.mn);
                }
                Reporter reporter = Reporter.getReporter(source_address, source_port, true);
                boolean res = eventNames.contains(tag) && eventReporters.keySet().contains(reporter);
                AdminClient.rmmLogger.baseInfo("CatalogEventR.acceptStream topic=" + tag + " id=" + stream_id + " from " + reporter + (res ? " accepted " : " rejected"), CatalogEventR.mn);
                return res;
            }
        };
        return selector;
    }

    void update(Reporter reporter, String topicName, long id, String topicAddress) {
        eventNames.add(topicName);
        eventReporters.put(reporter, new Long(id));
        CatalogEntry ce = new CatalogEntry(id, topicName, topicAddress);
        AdminClient.rmmLogger.baseInfo("CatalogEventR.update new catalog event " + ce + " from " + reporter, mn);
        CatalogBook.add(reporter, ce);
    }

    public void onMessage(Message message) {
        CatalogEventReport cer;
        byte[] msg = message.getData();
        Reporter reporter = Reporter.getReporter(message.getSourceAddress(), message.getSourcePort(), true);
        try {
            cer = (CatalogEventReport)ReportFactory.buildReport(msg, 0);
        }
        catch (Exception e2) {
            AdminClient.rmmLogger.baseError("Internal error - Failed to downcast report to CatalogEventReport", e2, mn);
            return;
        }
        AdminClient.rmmLogger.baseInfo("CatalogEventR.onMessage new catalog entry " + cer.getCatalogEntry() + " from " + reporter + (cer.remove() ? " removed" : " added"), mn);
        CatalogEntry catalogEntry = cer.getCatalogEntry();
        if (cer.remove()) {
            CatalogBook.remove(reporter, catalogEntry);
        } else {
            CatalogBook.add(reporter, catalogEntry);
        }
    }

    public void onEvent(Event event2) {
        AdminClient.rmmLogger.baseInfo("CatalogEventR.onEvent " + event2.getDescription() + " from " + event2.getSourceAddress() + ":" + event2.getSourcePort() + " id=" + event2.getLongField(), mn);
        Reporter reporter = Reporter.getReporter(event2.getSourceAddress(), event2.getSourcePort(), false);
        if (event2.getType() == 5 || event2.getType() == 2) {
            AdminClient.rmmLogger.baseWarn(String.valueOf(reporter.getName()) + " closed its catalog event channel", null, mn);
            CatalogBook.removeEntriesByReporter(reporter);
        } else if (event2.getType() == 1) {
            AdminClient.rmmLogger.baseError("Unrecoverable catalog event packet loss. Will join the catalog's state channel again", null, mn);
            CatalogStateR.rejoin(reporter);
        }
    }
}

