/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.mtl.admin;

import com.ibm.rmm.mtl.admin.AdminClient;
import com.ibm.rmm.mtl.admin.AdminTopic;
import com.ibm.rmm.mtl.admin.AdminTopicR;
import com.ibm.rmm.mtl.admin.CatalogEventR;
import com.ibm.rmm.mtl.admin.CatalogStateR;
import com.ibm.rmm.ptl.admin.AdminInfoReport;
import com.ibm.rmm.ptl.admin.Report;
import com.ibm.rmm.ptl.admin.ReportListener;
import com.ibm.rmm.ptl.admin.Reporter;

public class CatalogR
implements ReportListener {
    private static final String mn = "Admin";
    private static CatalogStateR catalogState;
    private static CatalogEventR catalogEvent;
    private AdminTopic adminTopic;

    CatalogR(AdminTopicR adminTopic) {
        catalogState = new CatalogStateR();
        catalogEvent = new CatalogEventR();
        this.adminTopic = adminTopic;
        adminTopic.addReportListener(this, 5);
    }

    public void onReport(Report report, Reporter reporter) {
        AdminInfoReport adminInfoReport;
        try {
            adminInfoReport = (AdminInfoReport)report;
        }
        catch (ClassCastException e2) {
            AdminClient.rmmLogger.baseError("Internal error - Failed to downcast report to AdminInfoReport", e2, mn);
            return;
        }
        String stateName = adminInfoReport.getStateTopicName();
        String stateAddress = adminInfoReport.getStateTopicAddress();
        long stateId = adminInfoReport.getStateTopicId();
        String eventName = adminInfoReport.getEventTopicName();
        String eventAddress = adminInfoReport.getEventTopicAddress();
        long eventId = adminInfoReport.getEventTopicId();
        if (stateName != null && stateId != 0L) {
            catalogState.update(reporter, stateName, stateId, stateAddress);
        }
        if (eventName != null && eventId != 0L) {
            catalogEvent.update(reporter, eventName, eventId, eventAddress);
        }
    }
}

