/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.mtl.admin;

import com.ibm.rmm.intrn.util.Sutils;
import com.ibm.rmm.mtl.admin.AdminClient;
import com.ibm.rmm.mtl.receiver.MReceiver;
import com.ibm.rmm.mtl.receiver.MStreamSetR;
import com.ibm.rmm.ptl.admin.CatalogBook;
import com.ibm.rmm.ptl.admin.CatalogEntry;
import com.ibm.rmm.ptl.admin.CatalogStateReport;
import com.ibm.rmm.ptl.admin.ReportFactory;
import com.ibm.rmm.ptl.admin.Reporter;
import com.ibm.rmm.receiver.AdvancedMessageListener;
import com.ibm.rmm.receiver.Event;
import com.ibm.rmm.receiver.Message;
import com.ibm.rmm.receiver.StreamSelector;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CatalogStateR
implements AdvancedMessageListener {
    private static final String mn = "Admin";
    private static MStreamSetR stateStreams;
    private static Set stateNames;
    private static Map stateReporters;
    private static Set activeStateReporters;
    private static StreamSelector selector;

    CatalogStateR() {
        stateNames = Collections.synchronizedSet(new HashSet());
        stateReporters = Collections.synchronizedMap(new HashMap());
        activeStateReporters = Collections.synchronizedSet(new HashSet());
        selector = this.createStreamSelector();
        stateStreams = MReceiver.getInstance().createStreamSetReceiver(selector, true, true);
        stateStreams.setAdvancedMessageListener(this);
    }

    private StreamSelector createStreamSelector() {
        StreamSelector selector = new StreamSelector(){

            public boolean acceptStream(byte[] tag_buffer, int tag_length, long stream_id, InetAddress source_address, int source_port) {
                String tag = null;
                try {
                    tag = Sutils.bytesToString(tag_buffer, tag_length);
                }
                catch (UnsupportedEncodingException e2) {
                    AdminClient.rmmLogger.baseError("Failed to convert topic name", e2, CatalogStateR.mn);
                    AdminClient.rmmLogger.baseLog(411, new Object[]{"UTF-8"}, e2, CatalogStateR.mn);
                }
                Reporter reporter = Reporter.getReporter(source_address, source_port, true);
                boolean res = stateNames.contains(tag) && stateReporters.keySet().contains(reporter);
                AdminClient.rmmLogger.baseInfo("CatalogStateR.acceptStream topic=" + tag + " id=" + stream_id + " from " + reporter + (res ? " accepted " : " rejected"), CatalogStateR.mn);
                return res;
            }
        };
        return selector;
    }

    void update(Reporter reporter, String topicName, long id, String topicAddress) {
        stateNames.add(topicName);
        CatalogEntry ce = new CatalogEntry(id, topicName, topicAddress);
        stateReporters.put(reporter, ce);
        activeStateReporters.add(reporter);
        AdminClient.rmmLogger.baseInfo("CatalogStateR.update new catalog state " + ce + " from " + reporter, mn);
        CatalogBook.add(reporter, ce);
        stateStreams.refreshStreamList();
    }

    public void onMessage(Message message) {
        CatalogStateReport csr;
        byte[] msg = message.getData();
        Reporter reporter = Reporter.getReporter(message.getSourceAddress(), message.getSourcePort(), true);
        try {
            csr = (CatalogStateReport)ReportFactory.buildReport(msg, 0);
        }
        catch (Exception e2) {
            AdminClient.rmmLogger.baseError("Internal error - Failed to downcast report to CatalogStateReport", e2, mn);
            return;
        }
        AdminClient.rmmLogger.baseInfo("CatalogStateR.onMessage new catalog " + csr.getCatalogEntries() + " from " + reporter, mn);
        CatalogBook.updateStateForReporter(reporter, csr.getCatalogEntries());
        activeStateReporters.remove(reporter);
        CatalogEntry ce = (CatalogEntry)stateReporters.get(reporter);
        CatalogBook.remove(reporter, ce);
    }

    static void rejoin(Reporter reporter) {
        CatalogEntry ce = (CatalogEntry)stateReporters.get(reporter);
        activeStateReporters.add(reporter);
        CatalogBook.add(reporter, ce);
    }

    public void onEvent(Event event2) {
        AdminClient.rmmLogger.baseInfo("CatalogStateR.onEvent " + event2.getDescription() + " from " + event2.getSourceAddress() + ":" + event2.getSourcePort(), mn);
    }
}

