/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.mtl.admin;

import com.ibm.rmm.mtl.admin.AdminClient;
import com.ibm.rmm.mtl.transmitter.MLJETopicT;
import com.ibm.rmm.mtl.transmitter.MTopicT;
import com.ibm.rmm.ptl.admin.CatalogEntry;
import com.ibm.rmm.ptl.admin.ReportFactory;
import java.util.HashMap;
import java.util.Map;

public class CatalogStateT {
    private static final String mn = "Admin";
    private static Map catalogEntries = new HashMap();
    private MLJETopicT stateTopicT;

    CatalogStateT(MLJETopicT topicT) {
        this.stateTopicT = topicT;
    }

    long getId() {
        return this.stateTopicT.getStreamId();
    }

    public CatalogEntry addTopic(MTopicT topic) {
        CatalogEntry entry = this.newEntry(topic.getStreamId(), topic.getTopicName(), topic.getTopicAddress());
        byte[] msg = this.generateCatalogState();
        this.stateTopicT.submitRetainedMessage(msg);
        return entry;
    }

    public CatalogEntry removeTopic(MTopicT topic) {
        CatalogEntry entry = (CatalogEntry)catalogEntries.remove(topic.getTopicName());
        if (entry != null) {
            byte[] msg = this.generateCatalogState();
            this.stateTopicT.submitRetainedMessage(msg);
        } else if (AdminClient.rmmLogger.isMaxLogLevel()) {
            AdminClient.rmmLogger.maxWarn("CatalogStateT.removeTopic no entry for topic " + topic.getTopicName(), null, mn);
        }
        return entry;
    }

    private CatalogEntry newEntry(long id, String name2, String address) {
        CatalogEntry entry = new CatalogEntry(id, name2, address);
        catalogEntries.put(name2, entry);
        return entry;
    }

    byte[] generateCatalogState() {
        return ReportFactory.generateCatalogStateReport(catalogEntries.values());
    }
}

